''This is to check or modify or delete if the access keys
''at end of tranlation strings are the same as in
''source strings and if not change to the same.
''Please use it only when you exactly know what it does!
''(c) 2007-2008 by gnatix (Last modified on 2008.02.24)
''Modified by wanfu (Last modified on 2013.05.12)

Public Type STRING_INFO
	PreSpace			As String	'ַǰÿո
	EndSpace			As String	'ַÿո
	Spaces				As String	'ַݼǰո
	AccKey				As String	'ַݼ
	AccKeyIFR			As String	'ַݼ־
	AccKeyKey			As String	'ַݼַ
	EndString			As String	'ַֹ
	Shortcut			As String	'ַ
	PreString			As String	'ַݼǰַݼǰĿոֹ
	ExpString			As String	'ַݼǰַ
	AccKeyPos			As Integer	'ַݼλ
	AccKeyNum			As Integer	'ַݼ
	Length				As Integer	'ַ
	LineNum				As Integer	'ַ
End Type

Public Type CHECK_STRING_VALUE
	AscRange()			As Long
End Type

Public UIFileList() As String,UIDataList() As String,UILangList() As String,LangFile As String
Public CheckHexStr() As CHECK_STRING_VALUE,CheckSkipStr() As String,regEx As Object

Public StringSrc As STRING_INFO,StringTrn As STRING_INFO,MoveAcckey As String
Public ModifiedCount As Integer,AddedCount As Integer,MovedCount As Integer,DeledCount As Integer,ReplacedCount As Integer
Public AllCont As Long,AccKey As Long,EndChar As Long,Acceler As Long

Public DefaultCheckList() As String,AppRepStr As String,PreRepStr As String
Public CheckDataList() As String,CheckDataListBak() As String,cSelected() As String
Public DefaultProjectList() As String,ProjectDataList() As String

Public Const Version = "2013.05.12"
Public Const Build = "130512"
Public Const ToUpdateCheckVersion = "2011.11.14"
Public Const CheckRegKey = "HKCU\Software\VB and VBA Program Settings\AccessKey\"
Public Const CheckFilePath = MacroDir & "\Data\PSLCheckAccessKeys.dat"
Public Const JoinStr = vbFormFeed  'vbBack
Public Const SubJoinStr = vbVerticalTab  'Chr$(1)
Public Const LngJoinStr = "|"
Public Const SubLngJoinStr = Chr$(1)

Public Const ConvertStrHexRange = "\x30-\x39,\x41-\x46;\x30-\x37"
Public Const CheckStrHexRange = "\x00-\x07,\x0F-\x1F;\x00-\x40,\x5B-\x60,\x7B-\xBF;" & _
								"\x00-\x60,\x7B-\xBF;\x00-\x40,\x5B-\xBF;\x41-\x5A,\x61-\x7A;" & _
								"\x30-\x39,\x41-\x5A,\x61-\x7A"
			'0=ַ,1=ȫΪֺͷ,2=ȫΪдӢ,3=ȫΪСдӢ,4=СдӢ,5=ݼַΧ
Public Const AppName = "PSLCheckAccessKeys"


'ִĬ
Function CheckSettings(DataName As String,DataType As Long) As String
	Dim i As Long,n As Long,j As Long,Max As Long,CheckName As String
	Dim TempList() As String,readByte() As Byte,DefaultCheckDataList() As String

	If DataType = 0 Then ReDim TempList(17) As String
	If DataType = 1 Then ReDim TempList(20) As String

	If DataName <> "" And DataType = 0 Then
		If DataName = DefaultCheckList(0) Then CheckName = "en2zh"
		If DataName = DefaultCheckList(1) Then CheckName = "zh2en"
	ElseIf DataName <> "" And DataType = 1 Then
		If DataName = DefaultProjectList(0) Then CheckName = "CheckOnly"
		If DataName = DefaultProjectList(1) Then CheckName = "CheckAndCorrect"
		If DataName = DefaultProjectList(2) Then CheckName = "DelAccessKey"
		If DataName = DefaultProjectList(3) Then CheckName = "DelAccelerator"
		If DataName = DefaultProjectList(4) Then CheckName = "DelAccessKeyAndAccelerator"
	End If
	If CheckName = "" Then GoTo ExitFunction

	ConfigFile = MacroDir & "\Data\PSLCheckAccessKeys.ini"
	On Error GoTo ErrMassage
	If Dir(ConfigFile) = "" Then Err.Raise(1,"NotExitFile",LangFile)

	On Error GoTo NotReadFile
	i = FileLen(ConfigFile)
	ReDim readByte(i) As Byte
	FN = FreeFile
	Open ConfigFile For Binary As #FN
	Get #FN,,readByte
	Close #FN
	DefaultCheckDataList = Split(readByte,vbCrLf)
	Erase readByte
	If CheckArray(DefaultCheckDataList) = False Then GoTo ExitFunction

	On Error GoTo ErrMassage
	n = 0
	Max = UBound(DefaultCheckDataList)
	For i = 0 To Max
		l$ = DefaultCheckDataList(i)
		If Trim(l$) <> "" Then
			If Left(Trim(l$),1) = "[" And Right(Trim(l$),1) = "]" Then
				Header$ = Trim(Mid(Trim(l$),2,Len(Trim(l$))-2))
			End If
			If Header$ <> "" And HeaderBak$ = "" Then HeaderBak$ = Header$
			If Header$ <> "" And Header$ = HeaderBak$ Then
				setPreStr$ = ""
				setAppStr$ = ""
				j = InStr(l$,"=")
				If j > 0 Then
					setPreStr$ = Trim(Left(l$,j - 1))
					setAppStr$ = LTrim(Mid(l$,j + 1))
				End If
				If Header$ = "Option" And setPreStr$ <> "" Then
					If setPreStr$ = "Version" Then
						UpdateVersion = setAppStr$
						If UpdateVersion < ToUpdateCheckVersion Or UpdateVersion > Version Then
							CheckName = ""
							Err.Raise(1,"NotVersion",ConfigFile & JoinStr & UpdateVersion & _
										JoinStr & ToUpdateCheckVersion)
							Exit For
						End If
					End If
				End If
				If DataType = 0 And Header$ = CheckName And setPreStr$ <> "" Then
					If setPreStr$ = "ExcludeChar" Then TempList(0) = setAppStr$
					If setPreStr$ = "LineSplitChar" Then TempList(1) = setAppStr$
					If setPreStr$ = "CheckBracket" Then TempList(2) = setAppStr$
					If setPreStr$ = "KeepCharPair" Then TempList(3) = setAppStr$
					If setPreStr$ = "ShowAsiaKey" Then TempList(4) = setAppStr$
					If setPreStr$ = "CheckEndChar" Then TempList(5) = setAppStr$
					If setPreStr$ = "NoTrnEndChar" Then TempList(6) = setAppStr$
					If setPreStr$ = "AutoTrnEndChar" Then TempList(7) = setAppStr$
					If setPreStr$ = "CheckShortChar" Then TempList(8) = setAppStr$
					If setPreStr$ = "CheckShortKey" Then TempList(9) = setAppStr$
					If setPreStr$ = "KeepShortKey" Then TempList(10) = setAppStr$
					If setPreStr$ = "PreRepString" Then TempList(11) = setAppStr$
					If setPreStr$ = "AutoRepString" Then TempList(12) = setAppStr$
					If setPreStr$ = "AccessKeyChar" Then TempList(13) = setAppStr$
					If setPreStr$ = "AddAccessKeyWithFirstChar" Then TempList(14) = setAppStr$
					If setPreStr$ = "LineSplitMode" Then TempList(15) = setAppStr$
					If setPreStr$ = "AppInsertSplitChar" Then TempList(16) = setAppStr$
					If setPreStr$ = "ReplaceSplitChar" Then TempList(17) = setAppStr$
				ElseIf DataType = 1 And Header$ = "Projects" And setPreStr$ <> "" Then
					If setPreStr$ = CheckName Then TempList = Split(setAppStr$,LngJoinStr)
				End If
			End If
		End If
		If Header$ <> "" And (i = Max Or Header$ <> HeaderBak$) Then
			If CheckArray(TempList)  = True Then
				If DataType = 0 And HeaderBak$ = CheckName Then
					CheckSettings = Join(TempList,SubJoinStr)
				ElseIf DataType = 1 And HeaderBak$ = "Projects" Then
					CheckSettings = Join(TempList,LngJoinStr)
				End If
				n = n + 1
				Exit For
			End If
			HeaderBak$ = Header$
		End If
	Next i

	If n = 0 And CheckName <> "" Then
		If DataType = 0 Then Temp = "NotSection"
		If DataType = 1 Then Temp = "NotValue"
		Err.Raise(1,Temp,ConfigFile & JoinStr & CheckName)
	End If
	Exit Function

	NotReadFile:
	Err.Source = "NotReadFile"
	Err.Description = Err.Description & JoinStr & ConfigFile

	ErrMassage:
	Call sysErrorMassage(Err,1)

	ExitFunction:
	If n = 0 Then
		If DataType = 0 Then CheckSettings = Join(TempList,SubJoinStr)
		If DataType = 1 Then CheckSettings = Join(TempList,LngJoinStr)
	End If
End Function


' 
Public Sub PSL_OnEditTransString(TransString As PslTransString)
	Dim i As Long,j As Long,n As Long,trn As PslTransList,Temp As String
	Dim srcString As String,trnString As String,OldTrnString As String,NewTrnString As String
	Dim LineNumErrCount As Integer,accKeyNumErrCount As Integer,ErrorCount As Integer
	Dim CheckID As Long,iVo As Long,ShowOriginalTran As Long,ApplyCheckResult As Long
	Dim strKeyPath As String,WshShell As Object,Stemp As Boolean
	Dim MsgList() As String,TempList() As String,TempArray() As String

	'רõûǷڣڼ˳
	Set trn = TransString.TransList
	If Not trn Is Nothing Then
		If trn.Property(19980) = "CheckAccessKeys" Then Exit Sub
	End If

	'δ롢ֻΪյִ
	If TransString.SourceText = TransString.Text Then GoTo ExitSub
	If TransString.State(pslStateTranslated) = False Then GoTo ExitSub
	If TransString.State(pslStateLocked) = True Then GoTo ExitSub
	If TransString.State(pslStateReadOnly) = True Then GoTo ExitSub
	If Trim(TransString.SourceText) = "" Then GoTo ExitSub
	If Trim(TransString.Text) = "" Then GoTo ExitSub

	'ϵͳ
	On Error Resume Next
	Set WshShell = CreateObject("WScript.Shell")
	If WshShell Is Nothing Then
		PSL.Output(Err.Description & " - " & "WScript.Shell")
		Exit Sub
	End If
	strKeyPath = "HKLM\SYSTEM\CurrentControlSet\Control\Nls\Language\Default"
	OSLanguage = WshShell.RegRead(strKeyPath)
	If OSLanguage = "" Then
		strKeyPath = "HKLM\SYSTEM\CurrentControlSet\Control\Nls\Language\InstallLanguage"
		OSLanguage = WshShell.RegRead(strKeyPath)
		If Err.Source = "WshShell.RegRead" Then
			PSL.Output(Err.Description)
			Exit Sub
		End If
	End If
	Set WshShell = Nothing

	' Adodb.Stream Ƿ
	Set objStream = CreateObject("Adodb.Stream")
	If objStream Is Nothing Then
		PSL.Output(Err.Description & " - " & "Adodb.Stream")
		Exit Sub
	End If
	Set objStream = Nothing
	On Error GoTo SysErrorMsg

	'ʼ
	ReDim UIFileList(0),UIDataList(0),UILangList(0)
	ReDim DefaultCheckList(1),CheckDataList(0),cSelected(26)
	ReDim DefaultProjectList(4),ProjectDataList(0)
	UIFileList(0) = "Auto"
	UIDataList(0) = "Auto" & JoinStr & "0" & JoinStr

	'ת HEX ֵַΪ Long 
	TempList = Split(Replace$(ConvertStrHexRange,"\x",""),";")
	ReDim CheckHexStr(UBound(TempList)) As CHECK_STRING_VALUE
	For i = 0 To UBound(TempList)
		CheckHexStr(i).AscRange = HexToIntArray(TempList(i))
	Next i

	'תֵַΪʽģ壬ıʽȽ
	CheckSkipStr = Split("[" & Replace$(Replace$(CheckStrHexRange,";","];["),",","]|[") & "]",";")
	Set regEx = CreateObject("VBScript.RegExp")

	'ȡ
	CheckGet("Option",CheckDataList,"","")

	'ȡִ
	If GetUIList(UIFileList,UIDataList) = True Then
		If CheckArray(cSelected) = True Then Temp = LCase$(cSelected(26))
		If Temp = "" Or Temp = "0" Then Temp = LCase$(OSLanguage)
		TempList = Split(Temp,";")
		For i = 1 To UBound(UIDataList)
			TempArray = Split(UIDataList(i),JoinStr)
			If LCase$(TempArray(1)) = Temp Then
				LangFile = MacroDir & "\Data\" & TempArray(2)
				Exit For
			End If
			Temp = TempArray(2)
			TempArray = Split(LCase$(TempArray(1)),";")
			For j = 0 To UBound(TempList)
				For n = 0 To UBound(TempArray)
					If TempList(j) = TempArray(n) Then
						LangFile = MacroDir & "\Data\" & Temp
						Exit For
					End If
				Next n
				If LangFile <> "" Then Exit For
			Next j
			If LangFile <> "" Then Exit For
		Next i
	End If
	If LangFile = "" Then LangFile = MacroDir & "\Data\" & AppName & "_" & OSLanguage & ".lng"
	If Dir(LangFile) = "" Then
		LangFile = MacroDir & "\Data\" & AppName & "_" & OSLanguage & ".lng"
		If Dir(LangFile) = "" Then
			LangFile = ""
			For i = 0 To 2
				If i = 0 Then Temp = MacroDir & "\Data\" & AppName & "_0804.lng"
				If i = 1 Then Temp = MacroDir & "\Data\" & AppName & "_0404.lng"
				If i = 2 And UBound(UIDataList) > 0 Then
					TempArray = Split(UIDataList(1),JoinStr)
					Temp = MacroDir & "\Data\" & TempArray(2)
				End If
				If Dir(Temp) <> "" Then
					LangFile = Temp
					Exit For
				End If
			Next i
			If LangFile = "" Then Err.Raise(1,"NotExitFile",MacroDir & "\Data\" & AppName & "_*.lng")
		End If
	End If
	If getUILangList(LangFile,UILangList) = False Then Exit Sub
	If getMsgList(UILangList,MsgList,"Main",0) = False Then Exit Sub

	' PSL 汾
	If PSL.Version < 600 Then
		PSL.Output(MsgList(47) & ":" & MsgList(49))
		Exit Sub
	End If

	'ȡPSLĿԴ
	trnLng = PSL.GetLangCode(trn.Language.LangID,pslCode639_1)
	If trnLng = "" Then trnLng = PSL.GetLangCode(trn.Language.LangID,pslCodeLangRgn)
	If trnLng = "zh" Or trnLng = "ja" Or trnLng = "ko" Then TranLang = "Asia"
	If trnLng = "zh" Then
		trnLng = PSL.GetLangCode(trn.Language.LangID,pslCodeLangRgn)
		If trnLng = "zh-CHS" Or trnLng = "zh-SG" Then trnLng = "zh-CN"
		If trnLng = "zh-CHT" Or trnLng = "zh-HK" Or trnLng = "zh-MO" Then trnLng = "zh-TW"
	End If

	'ȡִ
	DefaultCheckList(0) = MsgList(61)
	DefaultCheckList(1) = MsgList(62)
	DefaultProjectList(0) = MsgList(16)
	DefaultProjectList(1) = MsgList(17)
	DefaultProjectList(2) = MsgList(18)
	DefaultProjectList(3) = MsgList(74)
	DefaultProjectList(4) = MsgList(75)
	j = 0
	CheckName = cSelected(0)
	n = StrToLong(cSelected(3))
	If n = 1 Then j = CheckGet("",CheckDataList,"",trnLng)
	If j <> 4 Then j = CheckGet("",CheckDataList,"","")
	If j <> 4 Then
		If TranLang = "Asia" Then CheckName = DefaultCheckList(0)
		If TranLang <> "Asia" Then CheckName = DefaultCheckList(1)
		Temp = CheckSettings(CheckName,0)
		If Trim(Replace(Temp,SubJoinStr,"")) <> "" Then
			CheckDataList(0) = CheckName & JoinStr & Temp
		Else
			PSL.Output MsgList(71)
			Exit Sub
		End If
	End If
	If CheckArray(ProjectDataList) = False Then
		TempArray = ProjectDataList
		For i = LBound(DefaultProjectList) To UBound(DefaultProjectList)
			ProjectName = DefaultProjectList(i)
			Temp = CheckSettings(ProjectName,1)
			If Trim(Replace(Temp,LngJoinStr,"")) <> "" Then
				Temp = ProjectName & JoinStr & Temp
				CreateArray(ProjectName,Temp,TempArray,ProjectDataList)
			End If
		Next i
		If CheckArray(ProjectDataList) = False Then
			PSL.Output MsgList(72)
			Exit Sub
		End If
	End If
	AllCont = 1
	AccKey = 0
	EndChar = 0
	Acceler = 0
	CheckID = 0

	'ֵתеת
	CheckDataListBak = CheckDataList
	TempArray = Split(CheckDataList(CheckID),JoinStr)
	TempDataList = Split(TempArray(1),SubJoinStr)
	For i = 0 To UBound(TempDataList)
		If i <> 4 And i <> 14 And i <> 15 And i < 18 Then
			If TempDataList(i) <> "" Then
				If i = 1 Or i = 5 Or i = 13 Or i = 16 Or i = 17 Then
					If i = 5 Or i = 7 Then Temp = " " Else Temp = ","
					TempList = SortArray(Split(TempDataList(i),Temp,-1),0,"Lenght","<")
					TempDataList(i) = Convert(Join(TempList,Temp))
				Else
					TempDataList(i) = Convert(TempDataList(i))
				End If
			End If
		End If
	Next i
	TempArray(1) = Join(TempDataList,SubJoinStr)
	CheckDataList(CheckID) = Join(TempArray,JoinStr)
	CheckName = TempArray(0)

	'ҶӦļ鷽 ID 
	ProjectName = DefaultProjectList(1)
	Stemp = False
	For i = LBound(ProjectDataList) To UBound(ProjectDataList)
		TempArray = Split(ProjectDataList(i),JoinStr)
		If TempArray(0) = ProjectName Then
			Stemp = True
			iVo = i
			Exit For
		End If
	Next i
	If Stemp = False Then iVo = 0

	'б־
	LineSplitCharArr = Split(Convert("\r\n,\r,\n"),",",-1)

	'ͷŲʹõĶ̬ʹõڴ
	Erase TempArray,TempList,TempDataList
	Erase UIFileList,UIDataList

	'Ϣִʼȡԭĺͷִ
	Massage = ""
	LineMsg = ""
	AcckeyMsg = ""
	ChangeMsg = ""
	StringSrc.LineNum = 0
	StringTrn.LineNum = 0
	StringSrc.AccKeyNum = 0
	StringTrn.AccKeyNum = 0
	srcString = TransString.SourceText
	trnString = TransString.Text
	OldTrnString = trnString
	OldsrcString = srcString

	'ʼִ
	NewTrnString = CheckHanding(CheckID,srcString,trnString,iVo)
	If cSelected(24) = "1" Then NewTrnString = ReplaceStr(CheckID,NewTrnString,2,1)

	'֯Ϣ
	If NewTrnString <> OldTrnString Then
		'
		For i = 0 To UBound(LineSplitCharArr)
			FindStr = Trim(LineSplitCharArr(i))
			If InStr(OldsrcString,FindStr) Then
				StringSrc.LineNum = StringSrc.LineNum + UBound(Split(OldsrcString,FindStr,-1))
			End If
			If InStr(NewTrnString,FindStr) Then
				StringTrn.LineNum = StringTrn.LineNum + UBound(Split(NewTrnString,FindStr,-1))
			End If
		Next i
		'Ϣ
		If StringSrc.LineNum <> StringTrn.LineNum Then
			LineMsg = LineErrMassage(StringSrc.LineNum,StringTrn.LineNum,LineNumErrCount)
		End If
		i = StringSrc.AccKeyNum - StringTrn.AccKeyNum
		If i > 1 Or i < 1 Then
			AcckeyMsg = AccKeyErrMassage(StringSrc.AccKeyNum,StringTrn.AccKeyNum,accKeyNumErrCount)
		End If
		ChangeMsg = ReplaceMassage(CheckID,iVo)
		Massage = ChangeMsg & AcckeyMsg & LineMsg
	End If
	If Massage <> "" Then TransString.OutputError(Massage)

	'滻ִ
	If NewTrnString <> OldTrnString Then
		'TransString.OutputError(MsgList(58) & OldtrnString)
		TransString.Text = NewTrnString
		trn.Save
	End If

	'ȡרõûԵ
	ExitSub:
	If trn.Property(19980) = "CheckAccessKeys" Then trn.Property(19980) = ""
	Exit Sub

	'ʾϢ
	SysErrorMsg:
	If Err.Source <> "ExitSub" Then Call sysErrorMassage(Err,0)
	GoTo ExitSub
End Sub


'ִǷַָ(ıֵַȽ)
'Mode = 0 ִǷַָҳַָλ
'Mode = 1 ִǷַָֻ
'Mode = 2 ִǷַָ
'Mode = 3 ִǷֻСдַָ
'AscRange  ִ鷶Χ (ַ룬 Min - Max ʾΧ)
Public Function CheckStr(ByVal textStr As String,AscRange() As Long,Mode As Long) As Boolean
	Dim i As Long,j As Long,n As Long,k As Long,l As Long,m As Long
	Dim InpAsc As Long,Stemp As Boolean,FindStemp As Boolean
	Dim minVal As Long,maxVal As Long

	If AscRange(0) = 0 And AscRange(1) = 0 Then Exit Function
	If Trim$(textStr) = "" Then Exit Function
	If Mode = 3 Then
		textStr = Trim$(textStr)
		If Len(textStr) < 3 Or InStr(textStr," ") Then Exit Function
	End If

	n = UBound(AscRange)
	For i = 1 To Len(textStr)
		InpAsc = AscW(Mid(textStr,i,1))
		FindStemp = False
		For j = 0 To n Step 2
			minVal = AscRange(j)
			maxVal = AscRange(j + 1)
			If minVal > -1 And maxVal > -1 Then
				If InpAsc >= minVal And InpAsc <= maxVal Then
					FindStemp = True
				End If
			ElseIf minVal > -1 And maxVal < 0 Then
				If InpAsc >= minVal Then FindStemp = True
			ElseIf minVal < 0 And maxVal > -1 Then
				If InpAsc <= maxVal Then FindStemp = True
			Else
				Exit For
			End If
			If FindStemp = True Then
				If Mode = 0 Then
					k = i
				ElseIf Mode = 3 Then
					If i > 1 Then
						If (j \ 2) And 1 Then l = l + 1 Else m = m + 1
					End If
				End If
				Exit For
			End If
		Next j
		If Mode = 1 Or Mode = 3 Then
			If FindStemp = False Then Stemp = True
		Else
			If FindStemp = True Then Stemp = True
		End If
		If Stemp = True Then Exit For
	Next i

	If Mode = 0 Or Mode = 2 Then
		If Stemp = True Then
			CheckStr = True
			If Mode = 0 Then Mode = k
		End If
	ElseIf Mode = 1 Then
		If Stemp = False Then CheckStr = True
	ElseIf Mode = 3 Then
		If Stemp = False And l > 0 And m > 0 Then CheckStr = True
	End If
End Function


'ִǷַָ(ʽȽ)
'Mode = 0 ִǷַָҳַָλ
'Mode = 1 ִǷַָֻ
'Mode = 2 ִǷַָ
'Mode = 3 ִǷֻСдַָ
'Mode = 4 ִǷַͬStrNum Ϊַ
'Patrn  Ϊʽģ
Public Function CheckStrRegExp(RegExp As Object,ByVal textStr As String,Patrn As String,StrNum As Long,Mode As Long) As Boolean
	Dim i As Long,n As Long,k As Long,l As Long,m As Long
	Dim TempList() As String,Matches As Object

	'Set RegExp = CreateObject("VBScript.RegExp")
	If Patrn = "" Then Exit Function
	If Trim$(textStr) = "" Then Exit Function
	If Mode = 0 Then
		RegExp.Global = True
		RegExp.Pattern = Patrn
		Set Matches = RegExp.Execute(textStr)
		If Matches.Count > 0 Then
			CheckStrRegExp = True
			Mode = Matches(0).FirstIndex + 1
		End If
	ElseIf Mode = 1 Then
		RegExp.Global = True
		RegExp.Pattern = Patrn
		Set Matches = RegExp.Execute(textStr)
		If Matches.Count = Len(textStr) Then
			CheckStrRegExp = True
		End If
	ElseIf Mode = 2 Then
		RegExp.Pattern = Patrn
		If RegExp.Test(textStr) Then
			CheckStrRegExp = True
		End If
	ElseIf Mode = 3 Then
		textStr = Trim$(textStr)
		n = Len(textStr)
		If n < 3 Or InStr(textStr," ") Then Exit Function
		RegExp.Global = True
		RegExp.Pattern = Patrn
		Set Matches = RegExp.Execute(textStr)
		If Matches.Count = n Then
			textStr = Mid$(textStr,2)
			n = Len(textStr)
			TempList = Split(Patrn,"|")
			For i = 0 To UBound(TempList)
				RegExp.Pattern = TempList(i)
				Set Matches = RegExp.Execute(textStr)
				If i And 1 Then
					k = Matches.Count
				Else
					m = Matches.Count
				End If
				If k + m = 0 Then Exit For
				If k + m = n Then
					CheckStrRegExp = True
					Exit For
				End If
			Next i
		End If
	ElseIf Mode = 4 Then
		If StrNum < 2 Or Len(textStr) < StrNum Then Exit Function
		If InStr(textStr," ") Then Exit Function
		RegExp.Pattern = "(" & Patrn & ")\1{" & StrNum - 1 & "}"
		If RegExp.Test(textStr) Then
			CheckStrRegExp = True
		End If
	End If
	'Set RegExp = Nothing
End Function


'滻ضַ
'fType = 0 滻ʹõһ滻ַ
'fType = 1 ԭ滻ʹõһ滻ַ
'fType = 2 滻ʹõڶ滻ַ
'fType = 3 ԭ滻ʹõڶ滻ַ
'Record = 0 ¼滻ַ
'Record = 1 ¼滻ַ
Function ReplaceStr(CheckID As Long,trnStr As String,fType As Long,Record As Long) As String
	Dim i As Long,PreStr As String,AppStr As String
	ReplaceStr = trnStr
	PreRepStr = ""
	AppRepStr = ""
	If Trim(trnStr) = "" Then Exit Function
	'ȡѡõĲ
	TempArray = Split(CheckDataListBak(CheckID),JoinStr)
	SetsArray = Split(TempArray(1),SubJoinStr)
	If fType < 2 Then AutoRepChar = SetsArray(11) Else AutoRepChar = SetsArray(12)
	If AutoRepChar <> "" Then
		FindStrArr = Split(AutoRepChar,",",-1)
		For i = 0 To UBound(FindStrArr)
			FindStr = FindStrArr(i)
			PreStr = ""
			AppStr = ""
			If InStr(FindStr,"|") Then
				TempArray = Split(FindStr,"|")
				If fType = 0 Or fType = 2 Then
					PreStr = TempArray(0)
					AppStr = TempArray(1)
				Else
					PreStr = TempArray(1)
					AppStr = TempArray(0)
				End If
				cPreStr = Convert(PreStr)
				cAppStr = Convert(AppStr)
			End If
			If PreStr <> "" And InStr(ReplaceStr,cPreStr) Then
				ReplaceStr = Replace(ReplaceStr,cPreStr,cAppStr)
				If Record = 1 Then
					If PreRepStr <> "" Then
						If InStr(PreRepStr,PreStr) = 0 Then PreRepStr = PreRepStr & JoinStr & PreStr
					Else
						PreRepStr = PreStr
					End If
					If AppRepStr <> "" Then
						If InStr(AppRepStr,AppStr) = 0 Then AppRepStr = AppRepStr & JoinStr & AppStr
					Else
						AppRepStr = AppStr
					End If
				End If
			End If
		Next i
	End If
End Function


'ݼֹͼ
Function CheckHanding(CheckID As Long,srcStr As String,trnStr As String,iVo As Long) As String
	Dim i As Long,srcStrBak As String,trnStrBak As String,LineSplitMode As Long
	Dim srcNum As Long,trnNum As Long,srcSplitNum As Long,trnSplitNum As Long,Stemp As Boolean
	Dim FindStr As String,srcStrArr() As String,trnStrArr() As String,TempArray() As String
	Dim k As Long,l As Long,m As Long

	'ʼ
	srcNum = 0
	trnNum = 0
	srcSplitNum = 0
	trnSplitNum = 0
	srcStrBak = srcStr
	trnStrBak = trnStr
	CheckHanding = trnStr
	If Trim(srcStr) = "" Or Trim(trnStr) = "" Then Exit Function

	'ȡѡõĲ
	TempArray = Split(CheckDataList(CheckID),JoinStr)
	SetsArray = Split(TempArray(1),SubJoinStr)
	ExcludeChar = SetsArray(0)
	PreInsertSplitChar = SetsArray(1)
	KeepCharPair = SetsArray(3)
	AccessKeyChar = SetsArray(13)
	LineSplitMode = StrToLong(SetsArray(15))
	AppInsertSplitChar = SetsArray(16)
	ReplaceSplitChar = SetsArray(17)

	TempArray = Split(ProjectDataList(iVo),JoinStr)
	SetsArray = Split(TempArray(1),LngJoinStr)
	EnableStringSplit = StrToLong(SetsArray(16))

	'ò黯
	If ExcludeChar <> "" Then ExcludeCharArr = Split(ExcludeChar,",",-1)
	If KeepCharPair <> "" Then KeepCharPairArr = Split(KeepCharPair,",",-1)
	If AccessKeyChar <> "" Then AccessKeyCharArr = Split(AccessKeyChar,",",-1)

	If EnableStringSplit = 1 Then
		LineSplitChar = PreInsertSplitChar & AppInsertSplitChar & ReplaceSplitChar
		Temp = PreInsertSplitChar & "," & AppInsertSplitChar & "," & ReplaceSplitChar
		If LineSplitChar <> "" Then LineSplitCharArr = Split(Temp,",",-1)
		If PreInsertSplitChar <> "" Then k = UBound(Split(PreInsertSplitChar,",",-1)) + 1
		If AppInsertSplitChar <> "" Then l = UBound(Split(AppInsertSplitChar,",",-1)) + 1
		If ReplaceSplitChar <> "" Then m = UBound(Split(ReplaceSplitChar,",",-1)) + 1
	End If

	'ųִеķǿݼ
	If ExcludeChar <> "" Then
		For i = 0 To UBound(ExcludeCharArr)
			FindStr = LTrim(ExcludeCharArr(i))
			If FindStr <> "" Then
				srcStrBak = Replace(srcStrBak,FindStr,"*a" & i & "!N!" & i & "d*")
				trnStrBak = Replace(trnStrBak,FindStr,"*a" & i & "!N!" & i & "d*")
			End If
		Next i
	End If

	'˲ǿݼĿݼ
	If KeepCharPair <> "" Then
		For i = 0 To UBound(KeepCharPairArr)
			FindStr = Trim(KeepCharPairArr(i))
			If FindStr <> "" Then
				LFindStr = Trim(Left(FindStr,1))
				RFindStr = Trim(Right(FindStr,1))
				ToRepStr = LFindStr & "&" & RFindStr
				BeRepStr = LFindStr & "*!N!" & i & "!M!" & i & "!N!*" & RFindStr
				srcStrBak = Replace(srcStrBak,ToRepStr,BeRepStr)
				trnStrBak = Replace(trnStrBak,ToRepStr,BeRepStr)
			End If
		Next i
	End If

	'滻ִ
	If EnableStringSplit = 1 Then
		BaksrcStr = srcStrBak
		BaktrnStr = trnStrBak
		If LineSplitChar <> "" Then
			For i = 0 To UBound(LineSplitCharArr)
				FindStr = Trim(LineSplitCharArr(i))
				If FindStr <> "" Then
					Stemp = False
					If LineSplitMode = 1 Then
						srcNum = UBound(Split(BaksrcStr,FindStr,-1))
						trnNum = UBound(Split(BaktrnStr,FindStr,-1))
						If srcNum = trnNum And srcNum > 0 And trnNum > 0 Then Stemp = True
					End If
					If LineSplitMode = 0 Or Stemp = True Then
						If InStr(LCase(AccessKeyChar),LCase(FindStr)) Then
							BaksrcStr = Insert(BaksrcStr,FindStr,"*c!N!g*",1)
							BaktrnStr = Insert(BaktrnStr,FindStr,"*c!N!g*",1)
						ElseIf i < k And k <> 0 Then
							BaksrcStr = Replace(BaksrcStr,FindStr,"*c!N!g*" & FindStr)
							BaktrnStr = Replace(BaktrnStr,FindStr,"*c!N!g*" & FindStr)
						ElseIf i >= k And i < k + l + 1 And l <> 0 Then
							BaksrcStr = Replace(BaksrcStr,FindStr,FindStr & "*c!N!g*")
							BaktrnStr = Replace(BaktrnStr,FindStr,FindStr & "*c!N!g*")
						ElseIf i >= k + l And i < k + l + m + 2 And m <> 0 Then
							BaksrcStr = Replace(BaksrcStr,FindStr,"*c!N!g*")
							BaktrnStr = Replace(BaktrnStr,FindStr,"*c!N!g*")
						End If
					End If
				End If
			Next i
		End If
		srcStrArr = Split(BaksrcStr,"*c!N!g*",-1)
		trnStrArr = Split(BaktrnStr,"*c!N!g*",-1)

		'ִ
		Stemp = False
		srcNum = UBound(srcStrArr)
		trnNum = UBound(trnStrArr)
		If srcNum > 0 And trnNum > 0 Then
			If LineSplitMode = 0 Then Stemp = True
			If LineSplitMode = 1 And srcNum = trnNum Then Stemp = True
		End If
		If Stemp = True Then
			TempArray = MergeArray(srcStrArr,trnStrArr)
			trnStrBak = ReplaceStrSplit(CheckID,trnStrBak,TempArray,iVo)
		Else
			trnStrBak = StringReplace(CheckID,srcStrBak,trnStrBak,iVo)
		End If
	Else
		trnStrBak = StringReplace(CheckID,srcStrBak,trnStrBak,iVo)
	End If

	'ݼ
	BaksrcStr = srcStrBak
	BaktrnStr = trnStrBak
	toRepStr = Trim(AccessKeyCharArr(0))
	If AccessKeyChar <> "" Then
		For i = 0 To UBound(AccessKeyCharArr)
			FindStr = Trim(AccessKeyCharArr(i))
			If FindStr <> "" And FindStr <> toRepStr Then
				BaksrcStr = Replace(BaksrcStr,FindStr,toRepStr)
				BaktrnStr = Replace(BaktrnStr,FindStr,toRepStr)
			End If
		Next i
	End If
	StringSrc.AccKeyNum = UBound(Split(BaksrcStr,toRepStr,-1))
	StringTrn.AccKeyNum = UBound(Split(BaktrnStr,toRepStr,-1))

	'ԭǿݼĿݼ
	If KeepCharPair <> "" Then
		For i = 0 To UBound(KeepCharPairArr)
			FindStr = Trim(KeepCharPairArr(i))
			If FindStr <> "" Then
				LFindStr = Trim(Left(FindStr,1))
				RFindStr = Trim(Right(FindStr,1))
				ToRepStr = LFindStr & "*!N!" & i & "!M!" & i & "!N!*" & RFindStr
				BeRepStr = LFindStr & "&" & RFindStr
				srcStrBak = Replace(srcStrBak,ToRepStr,BeRepStr)
				trnStrBak = Replace(trnStrBak,ToRepStr,BeRepStr)
			End If
		Next i
	End If

	'ԭִбųķǿݼ
	If ExcludeChar <> "" Then
		For i = 0 To UBound(ExcludeCharArr)
			FindStr = LTrim(ExcludeCharArr(i))
			If FindStr <> "" Then
				srcStrBak = Replace(srcStrBak,"*a" & i & "!N!" & i & "d*",FindStr)
				trnStrBak = Replace(trnStrBak,"*a" & i & "!N!" & i & "d*",FindStr)
			End If
		Next i
	End If
	CheckHanding = trnStrBak
End Function


'ڿݼضַԴ˲ִ
Function Insert(SplitString As String,SplitStr As String,InsStr As String,Leng As Long) As String
	Dim i As Long,j As Long,accesskeyStr As String
	Insert = SplitString
	If UBound(Split(SplitString,SplitStr)) < 2 Then Exit Function
	i = InStr(Insert,SplitStr)
	Do While i > Leng
		j = InStr(i + 1,Insert,SplitStr)
		If j > i Then
			accesskeyStr = Mid(Insert,i - Leng,j - i)
			If accesskeyStr <> "" Then
				Insert = Replace(Insert,accesskeyStr,accesskeyStr & InsStr)
			End If
		End If
		i = InStr(i + 1,Insert,SplitStr)
	Loop
	'PSL.Output "Insert = " & Insert       '
End Function


'ȡеÿִ滻
Function ReplaceStrSplit(CheckID As Long,trnStr As String,StrSplitArr() As String,iVo As Long) As String
	Dim srcStrSplit As String,trnStrSplit As String,trnStrSplitNew As String,i As Long,j As Long

	j = 1
	ReplaceStrSplit = trnStr
	For i = 0 To UBound(StrSplitArr) Step 2
		srcStrSplit = StrSplitArr(i)
		trnStrSplit = StrSplitArr(i + 1)
		trnStrSplitNew = StringReplace(CheckID,srcStrSplit,trnStrSplit,iVo)

		'ǰаظַ
		If trnStrSplit <> trnStrSplitNew Then
			Temp = Replace(ReplaceStrSplit,trnStrSplit,trnStrSplitNew,j,1)
			If j = 1 Then
				ReplaceStrSplit = Temp
			Else
				ReplaceStrSplit = Left(ReplaceStrSplit,j - 1) & Temp
			End If
		End If
		j = j + Len(trnStrSplitNew)

		'ÿеݽӣϢ
		TPreSpaceSrc = TPreSpaceSrc & StringSrc.PreSpace
		TPreSpaceTrn = TPreSpaceTrn & StringTrn.PreSpace
		TacckeySrc = TacckeySrc & StringSrc.AccKey
		TacckeyTrn = TacckeyTrn & StringTrn.AccKey
		TEndStringSrc = TEndStringSrc & StringSrc.EndString
		TEndStringTrn = TEndStringTrn & StringTrn.EndString
		TShortcutSrc = TShortcutSrc & StringSrc.Shortcut
		TShortcutTrn = TShortcutTrn & StringTrn.Shortcut
		TEndSpaceSrc = TEndSpaceSrc & StringSrc.EndSpace
		TEndSpaceTrn = TEndSpaceTrn & StringTrn.EndSpace
		TSpaceTrn = TSpaceTrn & StringTrn.Spaces
		TExpStringTrn = TExpStringTrn & StringTrn.ExpString
		TPreStringTrn = TPreStringTrn & StringTrn.PreString
		TMoveAcckey = TMoveAcckey & MoveAcckey
	Next i

	'ΪϢԭб滻Ӻ
	StringSrc.PreSpace = TPreSpaceSrc
	StringTrn.PreSpace = TPreSpaceTrn
	StringSrc.AccKey = TacckeySrc
	StringTrn.AccKey = TacckeyTrn
	StringSrc.EndString = TEndStringSrc
	StringTrn.EndString = TEndStringTrn
	StringSrc.Shortcut = TShortcutSrc
	StringTrn.Shortcut = TShortcutTrn
	StringSrc.EndSpace = TEndSpaceSrc
	StringTrn.EndSpace = TEndSpaceTrn
	StringTrn.Spaces = TSpaceTrn
	StringTrn.ExpString = TExpStringTrn
	StringTrn.PreString = TPreStringTrn
	MoveAcckey = TMoveAcckey
End Function


'лȡִĸֶβ滻ַ
Function StringReplace(CheckID As Long,srcStr As String,trnStr As String,iVo As Long) As String
	Dim i As Long,j As Long,x As Long,y As Long,m As Long,n As Long
	Dim AsiaKey As Long,AddAccessKeyWithFirstChar As Long,LeadingSpaceInSource As Long
	Dim LeadingSpaceInTarget As Long,LeadingSpaceInBoth As Long,TrailingSpaceInSource As Long
	Dim TrailingSpaceInTarget As Long,TrailingSpaceInBoth As Long,AccessKeyInSource As Long
	Dim AccessKeyInTarget As Long,AccessKeyInBoth As Long,EndCharInSource As Long,EndCharInTarget As Long
	Dim EndCharInBoth As Long,ShortcutInSource As Long,ShortcutInTarget As Long,ShortcutInBoth As Long
	Dim DeleteExtraSpace As Long,TranslateEndChar As Long,AccKeyInShort As Long,TempArray() As String
	Dim FindStr As String,LastStringTrn As String,Temp As String,TempBak As String,Stemp As Boolean

	'ʼ
	StringSrc.Length = 0
	StringTrn.Length = 0
	StringSrc.PreSpace = ""
	StringTrn.PreSpace = ""
	StringSrc.EndSpace = ""
	StringTrn.EndSpace = ""
	StringSrc.AccKey = ""
	StringTrn.AccKey = ""
	StringSrc.AccKeyIFR = ""
	StringTrn.AccKeyIFR = ""
	StringSrc.AccKeyKey = ""
	StringTrn.AccKeyKey = ""
	StringSrc.AccKeyPos = 0
	StringTrn.AccKeyPos = 0
	StringSrc.EndString = ""
	StringTrn.EndString = ""
	StringSrc.Shortcut = ""
	StringTrn.Shortcut = ""
	StringTrn.Spaces = ""
	StringTrn.ExpString = ""
	StringTrn.PreString = ""
	LastStringTrn = ""
	MoveAcckey = ""
	StringReplace = trnStr
	If Trim(srcStr) = "" Or Trim(trnStr) = "" Then Exit Function

	'ȡѡõĲ
	TempArray = Split(CheckDataList(CheckID),JoinStr)
	SetsArray = Split(TempArray(1),SubJoinStr)
	CheckBracket = SetsArray(2)
	AsiaKey = StrToLong(SetsArray(4))
	CheckEndChar = SetsArray(5)
	NoTrnEndChar = SetsArray(6)
	AutoTrnEndChar = SetsArray(7)
	CheckShortChar = SetsArray(8)
	CheckShortKey = SetsArray(9)
	KeepShortKey = SetsArray(10)
	AccessKeyChar = SetsArray(13)
	AddAccessKeyWithFirstChar = StrToLong(SetsArray(14))

	TempArray = Split(ProjectDataList(iVo),JoinStr)
	SetsArray = Split(TempArray(1),LngJoinStr)
	LeadingSpaceInSource = StrToLong(SetsArray(0))
	LeadingSpaceInTarget = StrToLong(SetsArray(1))
	LeadingSpaceInBoth = StrToLong(SetsArray(2))
	TrailingSpaceInSource = StrToLong(SetsArray(3))
	TrailingSpaceInTarget = StrToLong(SetsArray(4))
	TrailingSpaceInBoth = StrToLong(SetsArray(5))
	AccessKeyInSource = StrToLong(SetsArray(6))
	AccessKeyInTarget = StrToLong(SetsArray(7))
	AccessKeyInBoth = StrToLong(SetsArray(8))
	EndCharInSource = StrToLong(SetsArray(9))
	EndCharInTarget = StrToLong(SetsArray(10))
	EndCharInBoth = StrToLong(SetsArray(11))
	ShortcutInSource = StrToLong(SetsArray(12))
	ShortcutInTarget = StrToLong(SetsArray(13))
	ShortcutInBoth = StrToLong(SetsArray(14))
	DeleteExtraSpace = StrToLong(SetsArray(15))
	TranslateEndChar = StrToLong(SetsArray(17))
	AccKeyInShort = StrToLong(SetsArray(18))

	'ò黯
	If CheckBracket <> "" Then CheckBracketArr = Split(CheckBracket,",",-1)
	If CheckEndChar <> "" Then CheckEndCharArr = Split(CheckEndChar," ",-1)
	If AutoTrnEndChar <> "" Then AutoTrnEndCharArr = Split(AutoTrnEndChar," ",-1)
	If CheckShortChar <> "" Then CheckShortCharArr = Split(CheckShortChar,",",-1)
	If AccessKeyChar <> "" Then AccessKeyCharArr = Split(AccessKeyChar,",",-1)

	'ȡԴͷĳ
	StringSrc.Length = Len(srcStr)
	StringTrn.Length = Len(trnStr)

	'ȡԴͷǰÿո
	StringSrc.PreSpace = Space(StringSrc.Length - Len(LTrim(srcStr)))
	StringTrn.PreSpace = Space(StringTrn.Length - Len(LTrim(trnStr)))

	'ȡԴͷβո
	StringSrc.EndSpace = Space(StringSrc.Length - Len(RTrim(srcStr)))
	StringTrn.EndSpace = Space(StringTrn.Length - Len(RTrim(trnStr)))

	'ȡԴͷļ
	If CheckShortChar <> "" Then
		CheckShortKey = CheckShortKey & "," & KeepShortKey
		If AccessKeyChar <> "" Then m = UBound(AccessKeyCharArr)
		For i = 0 To UBound(CheckShortCharArr)
			FindStr = Trim(CheckShortCharArr(i))
			If FindStr <> "" Then
				For n = 0 To 1
					If n = 0 Then Temp = RTrim(srcStr)
					If n = 1 Then Temp = RTrim(trnStr)
					Shortcut = ""
					ShortcutKey = ""
					If InStrRev(LTrim(Temp),FindStr) > 1 Then
						y = InStrRev(Temp,FindStr)
						ShortcutKey = Trim(Mid(Temp,y + 1))
					End If
					If ShortcutKey <> "" Then
						If AccessKeyChar <> "" Then
							For j = 0 To m
								ShortcutKey =Replace(ShortcutKey,AccessKeyCharArr(j),"")
							Next j
						End If
						If ShortcutKey = "+" Then
							If CheckKeyCode(ShortcutKey,CheckShortKey) <> 0 Then
								Shortcut = Mid(Temp,y)
							End If
						ElseIf InStr(ShortcutKey,"+") Then
							x = 0
							TempArray = Split(ShortcutKey,"+",-1)
							For j = 0 To UBound(TempArray)
								x = x + CheckKeyCode(TempArray(j),CheckShortKey)
							Next j
							If x > 0 And x >= UBound(TempArray) Then
								Shortcut = Mid(Temp,y)
							End If
						Else
							If CheckKeyCode(ShortcutKey,CheckShortKey) <> 0 Then
								Shortcut = Mid(Temp,y)
							End If
						End If
						If Shortcut <> "" Then
							If n = 0 And StringSrc.Shortcut = "" Then
								StringSrc.Shortcut = Shortcut
								ShortcutKeySrc = ShortcutKey
							ElseIf n = 1 And StringTrn.Shortcut = "" Then
								StringTrn.Shortcut = Shortcut
								ShortcutKeyTrn = ShortcutKey
							End If
						End If
					End If
				Next n
			End If
			If StringSrc.Shortcut <> "" And StringTrn.Shortcut <> "" Then Exit For
		Next i
	End If

	'ȡԴͷֹǰո
	If CheckEndChar <> "" Then
		xTemp = Left(srcStr,StringSrc.Length - Len(StringSrc.Shortcut & StringSrc.EndSpace))
		yTemp = Left(trnStr,StringTrn.Length - Len(StringTrn.Shortcut & StringTrn.EndSpace))
		If NoTrnEndChar <> "" Then
			If CheckKeyCode(xTemp,NoTrnEndChar) = 1 Then xTemp = ""
			If CheckKeyCode(yTemp,NoTrnEndChar) = 1 Then yTemp = ""
		End If
	End If
	If xTemp <> "" And yTemp <> "" Then
		If AccessKeyChar <> "" Then m = UBound(AccessKeyCharArr)
		For i = 0 To UBound(CheckEndCharArr)
			FindStr = Trim(CheckEndCharArr(i))
			If FindStr <> "" Then
				PreFindStr = Left(FindStr,1)
				AppFindStr = Right(FindStr,1)
				For j = 0 To 1
					If j = 0 Then
						Temp = xTemp
						EndSpace = StringSrc.EndSpace
						Shortcut = StringSrc.Shortcut
					Else
						Temp = yTemp
						EndSpace = StringTrn.EndSpace
						Shortcut = StringTrn.Shortcut
					End If
					n = 0
					y = InStrRev(Temp,FindStr)
					If y > 0 Then
						If Trim(Mid(Temp,y)) Like FindStr Then
							n = y
						ElseIf Right(Trim(Temp),1) = AppFindStr Then
							y = InStr(Temp,PreFindStr)
							Do While y > 0
								TempBak = Trim(Mid(Temp,y))
								If AccessKeyChar <> "" Then
									For x = 0 To m
										TempBak = Replace(TempBak,AccessKeyCharArr(x),"")
									Next x
								End If
								If TempBak Like FindStr Then
									n = y
									Exit Do
								End If
								y = InStr(y + 1,Temp,PreFindStr)
							Loop
						End If
					End If
					If n <> 0 Then
						PreStr = Left(Temp,n - 1)
						AppStr = Mid(Temp,n)
						x = Len(PreStr) - Len(RTrim(PreStr))
						If j = 0 And StringSrc.EndString = "" Then
							StringSrc.EndString = Space(x) & AppStr
						ElseIf j = 1 And StringTrn.EndString = "" Then
							StringTrn.EndString = Space(x) & AppStr
						End If
					End If
				Next j
			End If
			If StringSrc.EndString <> "" And StringTrn.EndString <> "" Then Exit For
		Next i
	End If

	'ȡԴͷĿݼλüַ
	If AccessKeyChar <> "" Then
		For i = 0 To UBound(AccessKeyCharArr)
			FindStr = Trim(AccessKeyCharArr(i))
			If FindStr <> "" Then
				For j = 0 To 1
					If j = 0 Then Temp = srcStr
					If j = 1 Then Temp = trnStr
					n = InStrRev(Temp,FindStr)
					If n > 0 Then
						If j = 0 And n > StringSrc.AccKeyPos Then
							StringSrc.AccKeyPos = n
							StringSrc.AccKeyIFR = FindStr
							StringSrc.AccKeyKey = Mid(Temp,n + Len(FindStr),1)
						ElseIf j = 1 And n > StringTrn.AccKeyPos Then
							StringTrn.AccKeyPos = n
							StringTrn.AccKeyIFR = FindStr
							StringTrn.AccKeyKey = Mid(Temp,n + Len(FindStr),1)
						End If
					End If
				Next j
			End If
		Next i
	End If
	If StringSrc.AccKeyIFR = "" Then StringSrc.AccKeyIFR = "&"
	If StringTrn.AccKeyIFR = "" Then StringTrn.AccKeyIFR = "&"

	'ȡԴͷĿݼ (ݼǰַ)
	If (StringSrc.AccKeyPos > 1 Or StringTrn.AccKeyPos > 1) And CheckBracket <> "" Then
		For i = 0 To UBound(CheckBracketArr)
			FindStr = Trim(CheckBracketArr(i))
			If FindStr <> "" Then
				PreFindStr = Trim(Left(FindStr,1))
				AppFindStr = Trim(Right(FindStr,1))
				For n = 0 To 1
					If n = 0 Then
						Temp = srcStr
						j = StringSrc.AccKeyPos
						xTemp = StringSrc.AccKeyIFR
						yTemp = StringSrc.AccKeyKey
					ElseIf n = 1 Then
						Temp = trnStr
						j = StringTrn.AccKeyPos
						xTemp = StringTrn.AccKeyIFR
						yTemp = StringTrn.AccKeyKey
					End If
					AccessKey = ""
					If j > 1 Then
						x = InStrRev(Temp,PreFindStr,j)
						y = InStr(j,Temp,AppFindStr)
						If x > 0 And y > x Then
							TempBak = Mid(Temp,x + 1,y - x - 1)
							If Trim(TempBak) = xTemp & yTemp Then
								AccessKey = Mid(Temp,x,y - x + 1)
								j = x
							End If
						End If
					ElseIf j = 1 Then
						AccessKey = xTemp
					End If
					If AccessKey <> "" Then
						If n = 0 And StringSrc.AccKey = "" Then
							StringSrc.AccKeyPos = j
							StringSrc.AccKey = AccessKey
						ElseIf n = 1 And StringTrn.AccKey = "" Then
							StringTrn.AccKeyPos = j
							StringTrn.AccKey = AccessKey
						End If
					End If
				Next n
			End If
			If StringSrc.AccKey <> "" And StringTrn.AccKey <> "" Then Exit For
		Next i
	End If
	If StringSrc.AccKey = "" And StringSrc.AccKeyPos > 0 Then StringSrc.AccKey = StringSrc.AccKeyIFR
	If StringTrn.AccKey = "" And StringTrn.AccKeyPos > 0 Then StringTrn.AccKey = StringTrn.AccKeyIFR

	'ȡĿݼķֹͷǼַ(ո)
	If StringTrn.AccKeyPos > 0 Then
		x = Len(StringTrn.EndString & StringTrn.Shortcut & StringTrn.EndSpace)
		'If InStr(StringTrn.Shortcut,StringTrn.AcckeyIFR) Then x = Len(StringTrn.EndSpace)
		'If InStr(StringTrn.EndString,StringTrn.AcckeyIFR) Then x = Len(StringTrn.Shortcut & StringTrn.EndSpace)
		If StringTrn.Length > x Then
			Temp = Left(trnStr,StringTrn.Length - x)
			StringTrn.ExpString = Mid(Temp,StringTrn.AccKeyPos + Len(StringTrn.AccKey))
		End If
	End If

	'ȡĿݼֹǰĿո
	Temp = StringTrn.AccKey & StringTrn.ExpString & StringTrn.EndString & _
			StringTrn.Shortcut & StringTrn.EndSpace
	If Temp <> "" Then
		x = Len(Temp)
		If InStr(StringTrn.EndString & StringTrn.Shortcut,StringTrn.AccKeyIFR) Then
			x = Len(StringTrn.EndString & StringTrn.Shortcut & StringTrn.EndSpace)
		End If
		If StringTrn.Length > x Then
			Temp = Left(trnStr,StringTrn.Length - x)
			y = Len(Temp) - Len(RTrim(Temp))
			If y > 0 Then StringTrn.Spaces = Space(y)
		End If
	End If

	'ȡĿݼǰֹֹǰĿո
	If StringTrn.AccKey <> "" And CheckEndChar <> "" Then
		x = Len(StringTrn.Spaces & StringTrn.AccKey & StringTrn.ExpString & StringTrn.EndString & _
			StringTrn.Shortcut & StringTrn.EndSpace)
		If InStr(StringTrn.EndString & StringTrn.Shortcut,StringTrn.AccKeyIFR) Then
			x = Len(StringTrn.Spaces & StringTrn.EndString & StringTrn.Shortcut & StringTrn.EndSpace)
		End If
		Temp = Left(trnStr,StringTrn.Length - x)
		If Trim(Temp) <> "" Then
			If NoTrnEndChar <> "" Then
				If CheckKeyCode(Temp,NoTrnEndChar) = 1 Then Temp = ""
			End If
			If Temp <> "" Then
				For i = 0 To UBound(CheckEndCharArr)
					FindStr = Trim(CheckEndCharArr(i))
					PreFindStr = Left(FindStr,1)
					AppFindStr = Right(FindStr,1)
					n = 0
					y = InStrRev(Temp,FindStr)
					If y > 0 Then
						If Trim(Mid(Temp,y)) Like FindStr Then
							n = y
						ElseIf Right(Trim(Temp),1) = AppFindStr Then
							y = InStr(Temp,PreFindStr)
							Do While y > 0
								TempBak = Trim(Mid(Temp,y))
								If TempBak Like FindStr Then
									n = y
									Exit Do
								End If
								y = InStr(y + 1,Temp,PreFindStr)
							Loop
						End If
					End If
					If n > 0 Then
						PreStr = Left(Temp,n - 1)
						AppStr = Mid(Temp,n)
						x = Len(PreStr) - Len(RTrim(PreStr))
						StringTrn.PreString = Space(x) & AppStr
					End If
					If StringTrn.PreString <> "" Then Exit For
				Next i
			End If
		End If
	End If

	'ȡгȡַַ
	Temp = StringTrn.PreString & StringTrn.Spaces & StringTrn.AccKey & StringTrn.ExpString & _
			StringTrn.EndString & StringTrn.Shortcut & StringTrn.EndSpace
	If Temp <> "" Then
		x = Len(Temp)
		If InStr(StringTrn.EndString & StringTrn.Shortcut,StringTrn.AccKeyIFR) Then
			x = Len(StringTrn.PreString & StringTrn.Spaces & StringTrn.EndString & _
				StringTrn.Shortcut & StringTrn.EndSpace)
		End If
		Temp = LTrim(trnStr)
		y = Len(Temp)
		If y > x Then LastStringTrn = Left(Temp,y - x)
	Else
		LastStringTrn = Trim(trnStr)
	End If

	'ļ
	If StringSrc.Shortcut <> "" And StringTrn.Shortcut <> "" And KeepShortKey <> "" Then
		SrcKeyArr = Split(ShortcutKeySrc,"+",-1)
		x = UBound(SrcKeyArr)
		TrnKeyArr = Split(ShortcutKeyTrn,"+",-1)
		y = UBound(TrnKeyArr)
		If x = y Then
			For i = 0 To x
				Temp = Trim(SrcKeyArr(i))
				TempBak = Trim(TrnKeyArr(i))
				If Temp <> "" And TempBak <> "" Then
					If CheckKeyCode(TempBak,KeepShortKey) <> 0 Then
						StringSrc.Shortcut = Replace(StringSrc.Shortcut,Temp,TempBak)
					End If
				End If
			Next i
		End If
	End If

	'PSL.Output "------------------------------ "   		'
	'PSL.Output "srcStr = " & srcStr                		'
	'PSL.Output "trnStr = " & trnStr               			'
	'PSL.Output "SpaceTrn = " & StringTrn.Spaces            '
	'PSL.Output "KeySrc = " & StringTrnKeySrc               '
	'PSL.Output "acckeySrc = " & StringSrc.AccKey          	'
	'PSL.Output "acckeyTrn = " & StringTrn.AccKey         	'
	'PSL.Output "EndStringSrc = " & StringSrc.EndString   	'
	'PSL.Output "EndStringTrn = " & StringTrn.EndString   	'
	'PSL.Output "ShortcutSrc = " & StringSrc.Shortcut     	'
	'PSL.Output "ShortcutTrn = " & StringTrn.Shortcut     	'
	'PSL.Output "ExpStringTrn = " & StringTrn.ExpString   	'
	'PSL.Output "PreStringTrn = " & StringTrn.PreString   	'
	'PSL.Output "LastStringTrn = " & LastStringTrn  		'
	'PSL.Output "MoveAcckey = " & MoveAcckey                '

	'ݲֵ
	SpaceTrnBak = StringTrn.Spaces
	ExpStringTrnBak = StringTrn.ExpString
	PreStringTrnBak = StringTrn.PreString
	ShortcutSrcBak = StringSrc.Shortcut
	EndStringSrcBak = StringTrn.EndString

	'ִѡ
	If AllCont <> 1 Then
		If Acceler <> 1 Then
			ShortcutInSource = 0
			ShortcutInTarget = 0
			ShortcutInBoth = 0
		End If
		If EndChar <> 1 Then
			EndCharInSource = 0
			EndCharInTarget = 0
			EndCharInBoth = 0
			TranslateEndChar = 0
		End If
		If AccKey <> 1 Then
			AccessKeyInSource = 0
			AccessKeyInTarget = 0
			AccessKeyInBoth = 0
			If AsiaKey = 1 Then
				If StringTrn.AccKey = StringTrn.AccKeyIFR Then AsiaKey = 0
			Else
				If StringTrn.AccKey <> StringTrn.AccKeyIFR Then AsiaKey = 1
			End If
		End If
	End If

	'ݼ
	If iVo >= 0 Then
		'ִм
		If StringSrc.PreSpace <> "" And StringTrn.PreSpace = "" Then
			If LeadingSpaceInSource = 0 Then StringSrc.PreSpace = StringTrn.PreSpace
		ElseIf StringSrc.PreSpace = "" And StringTrn.PreSpace <> "" Then
			If LeadingSpaceInTarget = 0 Then StringSrc.PreSpace = StringTrn.PreSpace
		ElseIf StringSrc.PreSpace <> "" And StringTrn.PreSpace <> "" Then
			If LeadingSpaceInBoth = 0 Then StringSrc.PreSpace = StringTrn.PreSpace
			If LeadingSpaceInBoth = 2 Then StringSrc.PreSpace = ""
		End If
		If StringSrc.EndSpace <> "" And StringTrn.EndSpace = "" Then
			If LeadingSpaceInSource = 0 Then StringSrc.EndSpace = StringTrn.EndSpace
		ElseIf StringSrc.EndSpace = "" And StringTrn.EndSpace <> "" Then
			If TrailingSpaceInTarget = 0 Then StringSrc.EndSpace = StringTrn.EndSpace
		ElseIf StringSrc.EndSpace <> "" And StringTrn.EndSpace <> "" Then
			If TrailingSpaceInBoth = 0 Then StringSrc.EndSpace = StringTrn.EndSpace
			If TrailingSpaceInBoth = 2 Then StringSrc.EndSpace = ""
		End If
		If StringSrc.AccKey <> "" And StringTrn.AccKey = "" Then
			If AccessKeyInSource = 0 Then
				StringSrc.AccKey = StringTrn.AccKey
				StringSrc.AccKeyIFR = StringTrn.AccKeyIFR
				StringSrc.AccKeyKey = StringTrn.AccKeyKey
			End If
		ElseIf StringSrc.AccKey = "" And StringTrn.AccKey <> "" Then
			If AccessKeyInTarget = 0 Then
				StringSrc.AccKey = StringTrn.AccKey
				StringSrc.AccKeyIFR = StringTrn.AccKeyIFR
				StringSrc.AccKeyKey = StringTrn.AccKeyKey
			End If
		ElseIf StringSrc.AccKey <> "" And StringTrn.AccKey <> "" Then
			If AccessKeyInBoth = 0 Then
				StringSrc.AccKey = StringTrn.AccKey
				StringSrc.AccKeyIFR = StringTrn.AccKeyIFR
				StringSrc.AccKeyKey = StringTrn.AccKeyKey
			ElseIf AccessKeyInBoth = 2 Then
				StringSrc.AccKey = ""
			End If
		End If
		If StringSrc.EndString <> "" And StringTrn.EndString = "" Then
			If EndCharInSource = 0 Then StringSrc.EndString = StringTrn.EndString
		ElseIf StringSrc.EndString = "" And StringTrn.EndString <> "" Then
			If EndCharInTarget = 0 Then StringSrc.EndString = StringTrn.EndString
		ElseIf StringSrc.EndString <> "" And StringTrn.EndString <> "" Then
			If EndCharInBoth = 0 Then StringSrc.EndString = StringTrn.EndString
			If EndCharInBoth = 2 Then StringSrc.EndString = ""
		End If
		If StringSrc.Shortcut <> "" And StringTrn.Shortcut = "" Then
			If ShortcutInSource = 0 Then StringSrc.Shortcut = StringTrn.Shortcut
		ElseIf StringSrc.Shortcut = "" And StringTrn.Shortcut <> "" Then
			If ShortcutInTarget = 0 Then StringSrc.Shortcut = StringTrn.Shortcut
		ElseIf StringSrc.Shortcut <> "" And StringTrn.Shortcut <> "" Then
			If ShortcutInBoth = 0 Then StringSrc.Shortcut = StringTrn.Shortcut
			If ShortcutInBoth = 2 Then StringSrc.Shortcut = ""
		End If

		'ÿݼʽ
		If InStr(StringTrn.EndString & StringTrn.Shortcut,StringTrn.AccKeyIFR) Then
			StringTrn.ExpString = ""
			If AsiaKey = 0 Then StringTrn.PreString = ""
		End If
		If StringTrn.AccKey = StringTrn.AccKeyIFR Then
			StringTrn.AccKey = StringTrn.AccKeyIFR & StringTrn.AccKeyKey
		End If
		If StringSrc.AccKey <> "" Then
			If AsiaKey = 0 Then
				StringSrc.AccKey = StringSrc.AccKeyIFR & StringSrc.AccKeyKey
				KeySrc = StringSrc.AccKeyIFR
			Else
				StringSrc.AccKey = "(" & StringSrc.AccKeyIFR & UCase(StringSrc.AccKeyKey) & ")"
				KeySrc = StringSrc.AccKey
			End If
		End If

		'ȷݼǷƶ
		Stemp = False
		If StringSrc.AccKey <> "" Then
			i = InStr(StringSrc.Shortcut,StringSrc.AccKeyIFR)
			j = InStr(StringTrn.Shortcut,StringTrn.AccKeyIFR)
			x = InStr(StringSrc.EndString,StringSrc.AcckeyIFR)
			y = InStr(StringTrn.EndString,StringTrn.AcckeyIFR)
			If LCase(StringSrc.AccKey) = LCase(StringTrn.AccKey) Then
				If AccKeyInShort = 1 Then
					If i > 0 And j = 0 Then MoveAcckey = "ShortcutSrc"
					If x > 0 And y = 0 Then MoveAcckey = "EndStringSrc"
					If i = 0 And j > 0 Then MoveAcckey = "ShortcutTrn"
					If x = 0 And y > 0 Then MoveAcckey = "EndStringTrn"
				Else
					If j > 0 Then MoveAcckey = "ShortcutTrn"
					If y > 0 Then MoveAcckey = "EndStringTrn"
				End If
			Else
				i = InStr(ShortcutSrcBak,StringSrc.AccKeyIFR)
				x = InStr(EndStringSrcBak,StringSrc.AccKeyIFR)
				If i = 0 And j > 0 Then Stemp = True
				If x = 0 And y > 0 Then Stemp = True
			End If
		End If

		'ƶɾݼǰֹ
		If StringTrn.PreString <> "" And AsiaKey = 1 Then
			If StringSrc.EndString & StringTrn.EndString = "" Then
				StringSrc.EndString = StringTrn.PreString
			End If
			StringTrn.PreString = ""
		End If

		'ɾжո
		If DeleteExtraSpace = 1 Then
			If StringTrn.Spaces <> "" Then
				If AsiaKey = 0 Then
					If Len(StringTrn.Spaces) > 1 Then StringTrn.Spaces = Space(1)
				Else
					StringTrn.Spaces = ""
				End If
			End If
			If StringTrn.PreString <> "" Then StringTrn.PreString = Trim(StringTrn.PreString)
			If StringTrn.ExpString <> "" Then StringTrn.ExpString = Trim(StringTrn.ExpString)
			If StringSrc.Shortcut <> "" Then StringSrc.Shortcut = Trim(StringSrc.Shortcut)
			If StringSrc.EndString <> "" Then
				If StringSrc.EndString = Space(1) & LTrim(StringSrc.EndString) Then
					StringSrc.EndString = RTrim(StringSrc.EndString)
				Else
					StringSrc.EndString = Trim(StringSrc.EndString)
				End If
			End If
		End If

		'ȷݼķʽ
		If StringSrc.AccKey <> "" And AccKeyInShort = 1 Then
			If InStr(StringSrc.EndString & StringSrc.Shortcut,StringSrc.AccKeyIFR) Then
				If Stemp = False Then
					StringSrc.AccKey = StringSrc.AccKeyIFR & StringSrc.AccKeyKey
					KeySrc = ""
				End If
			End If
		End If
		If StringSrc.AccKey = "" Or KeySrc <> "" Then
			If InStr(StringSrc.Shortcut,StringSrc.AccKeyIFR) Then
				StringSrc.Shortcut = Replace(StringSrc.Shortcut,StringSrc.AccKeyIFR,"")
			End If
			If InStr(StringSrc.EndString,StringSrc.AccKeyIFR) Then
				StringSrc.EndString = Replace(StringSrc.EndString,StringSrc.AccKeyIFR,"")
			End If
		End If

		'Զֹ
		If StringSrc.EndString <> "" And TranslateEndChar = 1 And AutoTrnEndChar <> "" Then
			Temp = Replace(Trim(StringSrc.EndString),StringSrc.AccKeyIFR,"")
			If Trim(Temp) <> "" Then
				For i = 0 To UBound(AutoTrnEndCharArr)
					FindStr = Trim(AutoTrnEndCharArr(i))
					If InStr(FindStr,"|") Then
						TempArray = Split(FindStr,"|")
						If Temp = TempArray(0) Then
							StringSrc.EndString = Replace(StringSrc.EndString,Temp,TempArray(1))
							Exit For
						End If
					End If
				Next i
			End If
		End If

		'ҿݼַÿݼ
		If StringSrc.AccKey <> "" And KeySrc <> "" And AsiaKey = 0 Then
			If LCase(StringSrc.AccKey) <> LCase(StringTrn.AccKey) Or MoveAcckey <> "" Then
				For i = 0 To 3
					Temp = ""
					If AccKeyInShort = 0 Then
						If i = 0 Then Temp = LastStringTrn
						If i = 1 Then Temp = StringTrn.ExpString
					Else
						If i = 0 Then Temp = LastStringTrn
						If i = 1 Then Temp = StringTrn.ExpString
						If i = 2 Then Temp = StringSrc.Shortcut
						If i = 3 Then Temp = StringSrc.EndString
					End If
					If Trim(Temp) <> "" Then
						StringTrn.AccKeyPos = InStr(Temp,StringSrc.AccKeyKey)
						If StringTrn.AccKeyPos = 0 Then
							StringTrn.AccKeyPos = InStr(LCase(Temp),LCase(StringSrc.AccKeyKey))
						End If
						If StringTrn.AccKeyPos > 0 Then
							StringTrn.AccKeyKey = Mid(Temp,StringTrn.AccKeyPos,1)
							Temp = Replace(Temp,StringTrn.AccKeyKey,StringSrc.AccKeyIFR & StringTrn.AccKeyKey,,1)
							StringSrc.AccKey = StringSrc.AccKeyIFR & StringTrn.AccKeyKey
							KeySrc = ""
						End If
					End If
					If AccKeyInShort = 0 Then
						If i = 0 Then LastStringTrn = Temp
						If i = 1 Then StringTrn.ExpString = Temp
					Else
						If i = 0 Then LastStringTrn = Temp
						If i = 1 Then StringTrn.ExpString = Temp
						If i = 2 Then StringSrc.Shortcut = Temp
						If i = 3 Then StringSrc.EndString = Temp
					End If
					If KeySrc = "" Then Exit For
				Next i
				If KeySrc <> "" Then
					If AddAccessKeyWithFirstChar = 1 Then
						i = 0
						If Trim(LastStringTrn) <> "" Then
							CheckStrRegExp(regEx,LastStringTrn,CheckSkipStr(5),0,i)
							If i = 0 Then
								i = Len(LastStringTrn) - Len(LTrim(LastStringTrn)) + 1
							End If
							If i > 0 Then
								PreTrn = Left(LastStringTrn,i - 1)
								AppTrn = Mid(LastStringTrn,i)
								StringTrn.AccKeyKey = Mid(LastStringTrn,i,1)
								LastStringTrn = PreTrn & StringSrc.AccKeyIFR & AppTrn
								StringSrc.AccKey = StringSrc.AccKeyIFR & StringTrn.AccKeyKey
							Else
								StringSrc.AccKey = ""
							End If
							MoveAcckey = ""
							KeySrc = ""
						ElseIf Trim(StringTrn.ExpString) <> "" Then
							CheckStrRegExp(regEx,StringTrn.ExpString,CheckSkipStr(5),0,i)
							If i = 0 Then
								i = Len(StringTrn.ExpString) - Len(LTrim(StringTrn.ExpString)) + 1
							End If
							If i > 0 Then
								PreTrn = Left(StringTrn.ExpString,i - 1)
								AppTrn = Mid(StringTrn.ExpString,i)
								StringTrn.AccKeyKey = Mid(StringTrn.ExpString,i,1)
								StringTrn.ExpString = PreTrn & StringSrc.AccKeyIFR & AppTrn
								StringSrc.AccKey = StringSrc.AccKeyIFR & StringTrn.AccKeyKey
							Else
								StringSrc.AccKey = ""
							End If
							MoveAcckey = ""
							KeySrc = ""
						End If
					Else
						MoveAcckey = ""
						StringSrc.AccKey = ""
						KeySrc = ""
					End If
				End If
			Else
				StringTrn.AccKey = StringSrc.AccKey
			End If
		End If

		'֯滻ַ
		If AsiaKey = 0 Then
			NewStringTrn = StringSrc.PreSpace & LastStringTrn & StringTrn.PreString & StringTrn.Spaces & KeySrc & _
							StringTrn.ExpString & StringSrc.EndString & StringSrc.Shortcut & StringSrc.EndSpace
		Else
			NewStringTrn = StringSrc.PreSpace & LastStringTrn & StringTrn.PreString & StringTrn.Spaces & _
							StringTrn.ExpString & KeySrc & StringSrc.EndString & StringSrc.Shortcut & StringSrc.EndSpace
		End If

		'ִ滻
		If StringReplace <> NewStringTrn Then StringReplace = NewStringTrn
	End If

	'ԭ
	StringTrn.Spaces = SpaceTrnBak
	StringTrn.ExpString = ExpStringTrnBak
	StringTrn.PreString = PreStringTrnBak

	'ɾֹͼеĿݼԱȷȽֹͼ
	If InStr(StringSrc.Shortcut,StringSrc.AccKeyIFR) Then StringSrc.Shortcut = Replace(StringSrc.Shortcut,StringSrc.AccKeyIFR,"")
	If InStr(StringSrc.Shortcut,StringTrn.AccKeyIFR) Then StringSrc.Shortcut = Replace(StringSrc.Shortcut,StringTrn.AccKeyIFR,"")
	If InStr(StringTrn.Shortcut,StringSrc.AccKeyIFR) Then StringTrn.Shortcut = Replace(StringTrn.Shortcut,StringSrc.AcckeyIFR,"")
	If InStr(StringTrn.Shortcut,StringTrn.AccKeyIFR) Then StringTrn.Shortcut = Replace(StringTrn.Shortcut,StringTrn.AccKeyIFR,"")
	If InStr(StringSrc.EndString,StringSrc.AccKeyIFR) Then StringSrc.EndString = Replace(StringSrc.EndString,StringSrc.AccKeyIFR,"")
	If InStr(StringSrc.EndString,StringTrn.AccKeyIFR) Then StringSrc.EndString = Replace(StringSrc.EndString,StringTrn.AccKeyIFR,"")
	If InStr(StringTrn.EndString,acckeyIFRSrc) Then StringTrn.EndString = Replace(StringTrn.EndString,StringSrc.AccKeyIFR,"")
	If InStr(StringTrn.EndString,acckeyIFRTrn) Then StringTrn.EndString = Replace(StringTrn.EndString,StringTrn.AccKeyIFR,"")
	If InStr(MoveAcckey,StringSrc.AccKeyIFR) Then MoveAcckey = Replace(MoveAcckey,StringSrc.AccKeyIFR,"")
	If InStr(MoveAcckey,StringTrn.AccKeyIFR) Then MoveAcckey = Replace(MoveAcckey,StringTrn.AccKeyIFR,"")
End Function


' ޸Ϣ
Function ReplaceMassage(CheckID As Long,iVo As Long) As String
	Dim i As Long,j As Long,m As Long,a As Long,v As Long,d As Long,r As Long
	Dim ModifiedMsg() As String,AddedMsg() As String,MovedMsg() As String
	Dim DeledMsg() As String,ReplacedMsg() As String,Massage() As String
	Dim sL As Long,tL As Long,sR As Long,tR As Long,MsgList() As String
	Dim AsiaKey As Long,DeleteExtraSpace As Long

	If getMsgList(UILangList,MsgList,"ReplaceMassage",1) = False Then Exit Function

	'ȡѡõĲ
	TempArray = Split(CheckDataList(CheckID),JoinStr)
	SetsArray = Split(TempArray(1),SubJoinStr)
	AsiaKey = StrToLong(SetsArray(4))

	TempArray = Split(ProjectDataList(iVo),JoinStr)
	SetsArray = Split(TempArray(1),LngJoinStr)
	DeleteExtraSpace = StrToLong(SetsArray(15))
	If StrToLong(SetsArray(20)) = 0 Then
		For i = 23 To 27
			MsgList(i) = MsgList(i + 8)
		Next i
	End If

	'ʼ
	ReDim ModifiedMsg(m),AddedMsg(a),MovedMsg(v),DeledMsg(d),ReplacedMsg(r),Massage(0)

	'ݼ
	If StringSrc.AccKey <> StringTrn.AccKey Then
		If StringSrc.AccKey <> "" And StringTrn.AccKey <> "" Then ModifiedMsg(m) = MsgList(0)
		If StringSrc.AccKey <> "" And StringTrn.AccKey = "" Then AddedMsg(a) = MsgList(0)
		If StringSrc.AccKey = "" And StringTrn.AccKey <> "" Then DeledMsg(d) = MsgList(0)
		If LCase(StringSrc.AccKey) = LCase(StringTrn.AccKey) Then ModifiedMsg(m) = MsgList(1)
		If ModifiedMsg(m) <> "" Then m = m + 1
		If AddedMsg(a) <> "" Then a = a + 1
		If DeledMsg(d) <> "" Then d = d + 1
	End If

	'ֹ
	If StringSrc.EndString <> StringTrn.EndString Then
		If StringSrc.EndString <> "" And StringTrn.EndString <> "" Then
			If Trim(StringSrc.EndString) <> Trim(StringTrn.EndString) Then
				ReDim Preserve ModifiedMsg(m)
				ModifiedMsg(m) = MsgList(2)
				m = m + 1
			End If
		ElseIf StringSrc.EndString <> "" And StringTrn.EndString = "" Then
			If Trim(StringSrc.EndString) <> Trim(PreStringTrn) Then
				ReDim Preserve AddedMsg(a)
				AddedMsg(a) = MsgList(2)
				a = a + 1
			End If
		ElseIf StringSrc.EndString = "" And StringTrn.EndString <> "" Then
			ReDim Preserve DeledMsg(d)
			DeledMsg(d) = MsgList(2)
			d = d + 1
		End If
	End If

	'
	If StringSrc.Shortcut <> StringTrn.Shortcut Then
		If StringSrc.Shortcut <> "" And StringTrn.Shortcut <> "" Then
			ReDim Preserve ModifiedMsg(m)
			ModifiedMsg(m) = MsgList(3)
			m = m + 1
		ElseIf StringSrc.Shortcut <> "" And StringTrn.Shortcut = "" Then
			ReDim Preserve AddedMsg(a)
			AddedMsg(a) = MsgList(3)
			a = a + 1
		ElseIf StringSrc.Shortcut = "" And StringTrn.Shortcut <> "" Then
			ReDim Preserve DeledMsg(d)
			DeledMsg(d) = MsgList(3)
			d = d + 1
		End If
	End If

	'ǰÿո
	If StringSrc.PreSpace <> StringTrn.PreSpace Then
		If StringSrc.PreSpace <> "" And StringTrn.PreSpace <> "" Then
			ReDim Preserve ModifiedMsg(m)
			ModifiedMsg(m) = MsgList(4)
			m = m + 1
		ElseIf StringSrc.PreSpace <> "" And StringTrn.PreSpace = "" Then
			ReDim Preserve AddedMsg(a)
			AddedMsg(a) = MsgList(4)
			a = a + 1
		ElseIf StringSrc.PreSpace = "" And StringTrn.PreSpace <> "" Then
			ReDim Preserve DeledMsg(d)
			DeledMsg(d) = MsgList(4)
			d = d + 1
		End If
	End If

	'ÿո
	If StringSrc.EndSpace <> StringTrn.EndSpace Then
		If StringSrc.EndSpace <> "" And StringTrn.EndSpace <> "" Then
			ReDim Preserve ModifiedMsg(m)
			ModifiedMsg(m) = MsgList(5)
			m = m + 1
		ElseIf StringSrc.EndSpace <> "" And StringTrn.EndSpace = "" Then
			ReDim Preserve AddedMsg(a)
			AddedMsg(a) = MsgList(5)
			a = a + 1
		ElseIf StringSrc.EndSpace = "" And StringTrn.EndSpace <> "" Then
			ReDim Preserve DeledMsg(d)
			DeledMsg(d) = MsgList(5)
			d = d + 1
		End If
	End If

	'ݼֹǰĿո
	If DeleteExtraSpace = 1 Then
		If StringTrn.Spaces <> "" And StringTrn.ExpString = "" Then
			ReDim Preserve DeledMsg(d)
			If StringSrc.Shortcut <> "" Or StringTrn.Shortcut <> "" Then DeledMsg(d) = MsgList(6)
			If StringSrc.EndString <> "" Or StringTrn.EndString <> "" Then DeledMsg(d) = MsgList(7)
			If StringSrc.AccKey <> "" Or StringTrn.AccKey <> "" Then DeledMsg(d) = MsgList(10)
			If DeledMsg(d) <> "" Then d = d + 1
		ElseIf StringTrn.Spaces <> "" And StringTrn.ExpString <> "" Then
			i = Len(StringTrn.ExpString) - Len(LTrim(StringTrn.ExpString))
			j = Len(StringTrn.ExpString) - Len(RTrim(StringTrn.ExpString))
			ReDim Preserve DeledMsg(d)
			If i = 0 Then DeledMsg(d) = MsgList(10)
			If i > 0 Then DeledMsg(d) = MsgList(12)
			d = d + 1
			If Trim(StringTrn.ExpString) <> "" And j > 0 Then
				ReDim Preserve DeledMsg(d)
				If StringTrn.Shortcut <> "" Then DeledMsg(d) = MsgList(6)
				If StringTrn.EndString <> "" Then DeledMsg(d) = MsgList(7)
				If DeledMsg(d) <> "" Then d = d + 1
			End If
		ElseIf StringTrn.Spaces = "" And StringTrn.ExpString <> "" Then
			i = Len(StringTrn.ExpString) - Len(LTrim(StringTrn.ExpString))
			j = Len(StringTrn.ExpString) - Len(RTrim(StringTrn.ExpString))
			If i > 0 Then
				ReDim Preserve DeledMsg(d)
				DeledMsg(d) = MsgList(11)
				d = d + 1
			End If
			If Trim(StringTrn.ExpString) <> "" And j > 0 Then
				ReDim Preserve DeledMsg(d)
				If StringTrn.Shortcut <> "" Then DeledMsg(d) = MsgList(6)
				If StringTrn.EndString <> "" Then DeledMsg(d) = MsgList(7)
				If DeledMsg(d) <> "" Then d = d + 1
			End If
		End If
		If StringTrn.PreString <> "" And StringTrn.PreString <> LTrim(StringTrn.PreString) Then
			ReDim Preserve DeledMsg(d)
			DeledMsg(d) = MsgList(13)
			d = d + 1
		End If

		'ֹǰĿո
		If StringSrc.EndString <> StringTrn.EndString Then
			If StringSrc.EndString <> "" And StringTrn.EndString <> "" Then
				sL = Len(StringSrc.EndString) - Len(LTrim(StringSrc.EndString))
				tL = Len(StringTrn.EndString) - Len(LTrim(StringTrn.EndString))
				sR = Len(StringSrc.EndString) - Len(RTrim(StringSrc.EndString))
				tR = Len(StringTrn.EndString) - Len(RTrim(StringTrn.EndString))
				i = sL - tL
				j = sR - tR
				If i > 0 Or j > 0 Then
					ReDim Preserve AddedMsg(a)
					If i > 0 And j = 0 Then AddedMsg(a) = MsgList(7)
					If i = 0 And j > 0 Then AddedMsg(a) = MsgList(8)
					If i > 0 And j > 0 Then AddedMsg(a) = MsgList(9)
					If AddedMsg(a) <> "" Then a = a + 1
				End If
				If i < 0 Or j < 0 Then
					ReDim Preserve DeledMsg(d)
					If i < 0 And j = 0 Then DeledMsg(d) = MsgList(7)
					If i = 0 And j < 0 Then DeledMsg(d) = MsgList(8)
					If i < 0 And j < 0 Then DeledMsg(d) = MsgList(9)
					If DeledMsg(d) <> "" Then d = d + 1
				End If
			ElseIf StringSrc.EndString = "" And StringTrn.EndString <> "" Then
				i = Len(StringTrn.EndString) - Len(LTrim(StringTrn.EndString))
				j = Len(StringTrn.EndString) - Len(RTrim(StringTrn.EndString))
				If i + j <> 0 Then
					ReDim Preserve DeledMsg(d)
					If i > 0 And j = 0 Then DeledMsg(d) = MsgList(7)
					If i = 0 And j > 0 Then DeledMsg(d) = MsgList(8)
					If i > 0 And j > 0 Then DeledMsg(d) = MsgList(9)
					If DeledMsg(d) <> "" Then d = d + 1
				End If
			End If
		End If
	End If

	'ݼǰַƶɾ
	If AsiaKey = 1 Then
		If StringTrn.ExpString <> "" And Trim(StringTrn.ExpString) <> "" Then
			ReDim Preserve MovedMsg(v)
			If StringSrc.AccKey <> "" Or StringTrn.AccKey <> "" Then MovedMsg(v) = MsgList(14)
			If StringSrc.EndSpace <> "" Or StringTrn.EndSpace <> "" Then MovedMsg(v) = MsgList(15)
			If StringSrc.Shortcut <> "" Or StringTrn.Shortcut <> "" Then MovedMsg(v) = MsgList(16)
			If StringSrc.EndString <> "" Or StringTrn.EndString <> "" Then MovedMsg(v) = MsgList(17)
			If MovedMsg(v) <> "" Then v = v + 1
		End If
		If StringTrn.PreString <> "" And Trim(StringTrn.PreString) <> "" Then
			If StringSrc.EndString = "" And StringTrn.EndString = "" Then
				ReDim Preserve MovedMsg(v)
				MovedMsg(v) = MsgList(17)
				v = v + 1
			ElseIf StringSrc.EndString = "" And StringTrn.EndString <> "" Then
				ReDim Preserve DeledMsg(d)
				DeledMsg(d) = MsgList(18)
				d = d + 1
			ElseIf StringSrc.EndString <> "" And StringTrn.EndString = "" Then
				If Trim(StringSrc.EndString) = Trim(StringTrn.PreString) Then
					ReDim Preserve MovedMsg(v)
					MovedMsg(v) = MsgList(17)
					v = v + 1
				Else
					ReDim Preserve DeledMsg(d)
					DeledMsg(d) = MsgList(18)
					d = d + 1
				End If
			ElseIf StringSrc.EndString <> "" And StringTrn.EndString <> "" Then
				ReDim Preserve DeledMsg(d)
				DeledMsg(d) = MsgList(18)
				d = d + 1
			End If
		End If
	End If
	If MoveAcckey <> "" Then
		ReDim Preserve MovedMsg(v)
		If MoveAcckey = "EndStringSrc" Then MovedMsg(v) = MsgList(19)
		If MoveAcckey = "ShortcutSrc" Then MovedMsg(v) = MsgList(20)
		If MoveAcckey = "EndStringTrn" Then MovedMsg(v) = MsgList(21)
		If MoveAcckey = "ShortcutTrn" Then MovedMsg(v) = MsgList(22)
		If MovedMsg(v) <> "" Then v = v + 1
	End If

	'滻ַ
	If PreRepStr <> "" And AppRepStr <> "" Then
		ReDim Preserve ReplacedMsg(r + 1)
		ReplacedMsg(r) = Replace(PreRepStr,JoinStr,MsgList(28))
		ReplacedMsg(r + 1) = Replace(AppRepStr,JoinStr,MsgList(28))
	ElseIf PreRepStr <> "" And AppRepStr = "" Then
		ReDim Preserve DeledMsg(d)
		DeledMsg(d) = Replace(PreRepStr,JoinStr,MsgList(28))
	End If

	'֯Ϣ
	i = 0
	If CheckArray(ModifiedMsg) = True Then
		Massage(i) = Replace(MsgList(23),"%s",Join(ClearArray(ModifiedMsg,1),MsgList(28)))
		ModifiedCount = ModifiedCount + 1
		i = i + 1
	End If
	If CheckArray(AddedMsg) = True Then
		ReDim Preserve Massage(i)
		Massage(i) = Replace(MsgList(24),"%s",Join(ClearArray(AddedMsg,1),MsgList(28)))
		AddedCount = AddedCount + 1
		i = i + 1
	End If
	If CheckArray(MovedMsg) = True Then
		ReDim Preserve Massage(i)
		Massage(i) = Replace(MsgList(25),"%s",Join(ClearArray(MovedMsg,1),MsgList(28)))
		MovedCount = MovedCount + 1
		i = i + 1
	End If
	If CheckArray(DeledMsg) = True Then
		ReDim Preserve Massage(i)
		Massage(i) = Replace(MsgList(26),"%s",Join(ClearArray(DeledMsg,1),MsgList(28)))
		DeledCount = DeledCount + 1
		i = i + 1
	End If
	If CheckArray(ReplacedMsg) = True Then
		ReDim Preserve Massage(i)
		Massage(i) = Replace(Replace(MsgList(27),"%s",ReplacedMsg(r)),"%d",ReplacedMsg(r + 1))
		ReplacedCount = ReplacedCount + 1
	End If

	If CheckArray(Massage) = True Then ReplaceMassage = Join(Massage,MsgList(29)) & MsgList(30)
End Function


'Ϣ
Function LineErrMassage(srcLineNum As Integer,trnLineNum As Integer,LineNumErrCount As Integer) As String
	Dim LineNumErr As Integer,MsgList() As String
	If getMsgList(UILangList,MsgList,"LineErrMassage",1) = False Then Exit Function
	LineNumErr = 0
	If srcLineNum <> trnLineNum Then
		If srcLineNum > trnLineNum Then
			LineNumErr = srcLineNum - trnLineNum
			LineErrMassage = Replace(MsgList(0),"%s",CStr(LineNumErr))
			LineNumErrCount = LineNumErrCount + 1
		ElseIf srcLineNum < trnLineNum Then
			LineNumErr = trnLineNum - srcLineNum
			LineErrMassage = Replace(MsgList(1),"%s",CStr(LineNumErr))
			LineNumErrCount = LineNumErrCount + 1
		End If
	End If
End Function


'ݼϢ
Function AccKeyErrMassage(srcAccKeyNum As Integer,trnAccKeyNum As Integer,accKeyNumErrCount As Integer) As String
	Dim accKeyNumErr As Integer,MsgList() As String
	If getMsgList(UILangList,MsgList,"AccKeyErrMassage",1) = False Then Exit Function
	accKeyNumErr = 0
	If srcAccKeyNum <> trnAccKeyNum Then
		If srcAccKeyNum > trnAccKeyNum Then
			accKeyNumErr = srcAccKeyNum - trnAccKeyNum
			AccKeyErrMassage = Replace(MsgList(0),"%s",CStr(accKeyNumErr))
			accKeyNumErrCount = accKeyNumErrCount + 1
		ElseIf srcAccKeyNum < trnAccKeyNum Then
			accKeyNumErr = trnAccKeyNum - srcAccKeyNum
			AccKeyErrMassage = Replace(MsgList(1),"%s",CStr(accKeyNumErr))
			accKeyNumErrCount = accKeyNumErrCount + 1
		End If
	End If
End Function


'Ϣ
Function CountMassage(ErrorCount As Integer,LineNumErrCount As Integer,accKeyNumErrCount As Integer,iVo As Long) As String
	Dim MsgList() As String
	If getMsgList(UILangList,MsgList,"CountMassage",1) = False Then Exit Function

	If iVo = 0 And ErrorCount = 0 Then CountMassage = MsgList(0)
	If iVo = 0 And ErrorCount <> 0 Then
		MsgList(1) = Replace(MsgList(1),"%s",CStr(ErrorCount))
		MsgList(2) = Replace(MsgList(2),"%m",CStr(ModifiedCount))
		MsgList(2) = Replace(MsgList(2),"%a",CStr(AddedCount))
		MsgList(2) = Replace(MsgList(2),"%v",CStr(MovedCount))
		MsgList(2) = Replace(MsgList(2),"%d",CStr(DeledCount))
		MsgList(2) = Replace(MsgList(2),"%r",CStr(ReplacedCount))
		MsgList(3) = Replace(MsgList(3),"%ln",CStr(LineNumErrCount))
		MsgList(3) = Replace(MsgList(3),"%dn",CStr(accKeyNumErrCount))
		CountMassage = MsgList(1) & MsgList(2) & MsgList(3)
	End If

	If (iVo = 1 Or iVo > 3) And ErrorCount = 0 Then CountMassage = MsgList(10)
	If (iVo = 1 Or iVo > 3) And ErrorCount <> 0 Then
		MsgList(1) = Replace(MsgList(11),"%s",CStr(ErrorCount))
		MsgList(4) = Replace(MsgList(4),"%m",CStr(ModifiedCount))
		MsgList(4) = Replace(MsgList(4),"%a",CStr(AddedCount))
		MsgList(4) = Replace(MsgList(4),"%v",CStr(MovedCount))
		MsgList(4) = Replace(MsgList(4),"%d",CStr(DeledCount))
		MsgList(4) = Replace(MsgList(4),"%r",CStr(ReplacedCount))
		MsgList(3) = Replace(MsgList(3),"%ln",CStr(LineNumErrCount))
		MsgList(3) = Replace(MsgList(3),"%dn",CStr(accKeyNumErrCount))
		CountMassage = MsgList(1) & MsgList(4) & MsgList(3)
	End If

	If iVo = 2 And ErrorCount = 0 Then CountMassage = MsgList(5)
	If iVo = 2 And ErrorCount <> 0 Then
		MsgList(6) = Replace(MsgList(6),"%s",CStr(ErrorCount))
		MsgList(7) = Replace(MsgList(7),"%m",CStr(ModifiedCount))
		MsgList(7) = Replace(MsgList(7),"%a",CStr(AddedCount))
		MsgList(7) = Replace(MsgList(7),"%w",CStr(DeledCount))
		CountMassage = MsgList(6) & MsgList(7)
	End If

	If iVo = 3 And ErrorCount = 0 Then CountMassage = MsgList(8)
	If iVo = 3 And ErrorCount <> 0 Then
		MsgList(9) = Replace(MsgList(9),"%s",CStr(ErrorCount))
		MsgList(7) = Replace(MsgList(7),"%m",CStr(ModifiedCount))
		MsgList(7) = Replace(MsgList(7),"%a",CStr(AddedCount))
		MsgList(7) = Replace(MsgList(7),"%w",CStr(DeledCount))
		CountMassage = MsgList(9) & MsgList(7)
	End If
End Function


'Ϣ
Sub sysErrorMassage(sysError As ErrObject,fType As Long)
	Dim TempArray() As String,MsgList() As String
	Dim ErrorNumber As Long,ErrorSource As String,ErrorDescription As String
	Dim TitleMsg As String,ContinueMsg As String,Msg As String

	ErrorNumber = sysError.Number
	ErrorSource = sysError.Source
	ErrorDescription = sysError.Description

	TitleMsg = "Error"
	If fType = 0 Then
		ContinueMsg = vbCrLf & vbCrLf & "The program cannot continue and will exit."
	ElseIf fType = 1 Then
		ContinueMsg = vbCrLf & vbCrLf & "Do you want to continue?"
	ElseIf fType = 2 Then
		ContinueMsg = vbCrLf & vbCrLf & "The program will continue to run."
	End If

	If CheckArray(UILangList) = True Then
		If getMsgList(UILangList,MsgList,"sysErrorMassage",3) = False Then
			If getMsgList(UILangList,MsgList,"Main",3) = False Then
				Msg = "The following file is missing [Main|sysErrorMassage] section." & vbCrLf & "%s"
				Msg = Replace(Msg,"%s",LangFile)
			Else
				TitleMsg = MsgList(48)
				If fType <> 0 Then ContinueMsg = MsgList(78) Else ContinueMsg = MsgList(79)
				Msg = Replace(Replace(MsgList(77),"%s","sysErrorMassage"),"%d",LangFile)
			End If
		Else
			TitleMsg = MsgList(0)
			If fType = 0 Then ContinueMsg = MsgList(10)
			If fType = 1 Then ContinueMsg = MsgList(11)
			If fType = 2 Then ContinueMsg = MsgList(12)

			If ErrorSource = "" Then
				Msg = Replace(Replace(MsgList(1),"%d",CStr(ErrorNumber)),"%v",ErrorDescription)
			ElseIf ErrorSource = "NotSection" Then
				TempArray = Split(ErrorDescription,JoinStr,-1)
				Msg = Replace(Replace(MsgList(3),"%s",TempArray(1)),"%d",TempArray(0))
			ElseIf ErrorSource = "NotValue" Then
				TempArray = Split(ErrorDescription,JoinStr,-1)
				Msg = Replace(Replace(MsgList(4),"%s",TempArray(1)),"%d",TempArray(0))
			ElseIf ErrorSource = "NotReadFile" Then
				TempArray = Split(ErrorDescription,JoinStr,-1)
				Msg = Replace(MsgList(5),"%s",TempArray(1))
			ElseIf ErrorSource = "NotWriteFile" Then
				TempArray = Split(ErrorDescription,JoinStr,-1)
				Msg = Replace(MsgList(6),"%s",TempArray(1))
			ElseIf ErrorSource = "NotINIFile" Then
				Msg = Replace(MsgList(7),"%s",ErrorDescription)
			ElseIf ErrorSource = "NotExitFile" Then
				Msg = Replace(MsgList(8),"%s",ErrorDescription)
			ElseIf ErrorSource = "NotVersion" Then
				TempArray = Split(ErrorDescription,JoinStr,-1)
				Msg = Replace(MsgList(9),"%s",TempArray(0))
				Msg = Replace(Replace(Msg,"%d",TempArray(1)),"%v",TempArray(2))
			Else
				Msg = Replace(MsgList(2),"%s",ErrorSource)
				Msg = Replace(Replace(Msg,"%d",CStr(ErrorNumber)),"%v",ErrorDescription)
			End If
		End If
	Else
		If ErrorSource = "" Then
			Msg = "An Error occurred in the program design." & vbCrLf & "Error Code: %d, Content: %v"
			Msg = Replace(Replace(Msg,"%s",CStr(ErrorNumber)),"%v",ErrorDescription)
		ElseIf ErrorSource = "NotSection" Then
			TempArray = Split(ErrorDescription,JoinStr,-1)
			Msg = "The following file is missing [%s] section." & vbCrLf & "%d"
			Msg = Replace(Replace(Msg,"%s",TempArray(1)),"%d",TempArray(0))
		ElseIf ErrorSource = "NotValue" Then
			TempArray = Split(ErrorDescription,JoinStr,-1)
			Msg = "The following file is missing [%s] Value." & vbCrLf & "%d"
			Msg = Replace(Replace(Msg,"%s",TempArray(1)),"%d",TempArray(0))
		ElseIf ErrorSource = "NotReadFile" Then
			Msg = Replace(ErrorDescription,JoinStr,vbCrLf)
		ElseIf ErrorSource = "NotWriteFile" Then
			Msg = Replace(ErrorDescription,JoinStr,vbCrLf)
		ElseIf ErrorSource = "NotINIFile" Then
			Msg = "The following contents of the file is not correct." & vbCrLf & "%s"
			Msg = Replace(Msg,"%s",ErrorDescription)
		ElseIf ErrorSource = "NotExitFile" Then
			Msg = "The following file does not exist! Please check and try again." & vbCrLf & "%s"
			Msg = Replace(Msg,"%s",ErrorDescription)
		ElseIf ErrorSource = "NotVersion" Then
			TempArray = Split(ErrorDescription,JoinStr,-1)
			Msg = "The following file version is %d, requires version at least %v." & vbCrLf & "%s"
			Msg = Replace(Msg,"%s",TempArray(0))
			Msg = Replace(Replace(Msg,"%d",TempArray(1)),"%v",TempArray(2))
		Else
			Msg = "Your system is missing %s server." & vbCrLf & "Error Code: %d, Content: %v"
			Msg = Replace(Msg,"%s",ErrorSource)
			Msg = Replace(Replace(Msg,"%d",CStr(ErrorNumber)),"%v",ErrorDescription)
		End If
	End If

	If Msg <> "" Then
		'Msg = Msg & ContinueMsg
		If fType = 0 Then
			PSL.Output(TitleMsg & ": "  & Msg)
			Exit All
		ElseIf fType = 1 Then
			PSL.Output(TitleMsg & ": "  & Msg)
			Exit All 'Err.Raise(1,"ExitSub")
		Else
			PSL.Output(TitleMsg & ": "  & Msg)
		End If
	End If
End Sub


'ϲ
Function MergeArray(srcStrArr() As String,trnStrArr() As String) As Variant
	Dim i As Long,srcNum As Long,trnNum As Long
	Dim srcPassNum As Long,trnPassNum As Long,TempArray() As String
	srcNum = UBound(srcStrArr)
	trnNum = UBound(trnStrArr)
	ReDim TempArray(srcNum + trnNum + 1) As String
	For i = 0 To (srcNum + trnNum + 1) Step 2
		If srcNum >= srcPassNum Then
			TempArray(i) = srcStrArr(srcPassNum)
			srcPassNum = srcPassNum + 1
		End If
		If trnNum >= trnPassNum Then
			TempArray(i + 1) = trnStrArr(trnPassNum)
			trnPassNum = trnPassNum + 1
		End If
	Next i
	MergeArray = TempArray
End Function


'ִת
Public Function Convert(ConverString As String) As String
	Convert = ConverString
	If Convert = "" Then Exit Function
	If InStr(Convert,"\") = 0 Then Exit Function
	If InStr(Convert,"\\") Then Convert = Replace$(Convert,"\\","*a!N!d*")
	If InStr(Convert,"\r\n") Then Convert = Replace$(Convert,"\r\n",vbCrLf)
	If InStr(Convert,"\r\n") Then Convert = Replace$(Convert,"\r\n",vbNewLine)
	If InStr(Convert,"\r") Then Convert = Replace$(Convert,"\r",vbCr)
	If InStr(Convert,"\r") Then Convert = Replace$(Convert,"\r",vbNewLine)
	If InStr(Convert,"\n") Then Convert = Replace$(Convert,"\n",vbLf)
	If InStr(Convert,"\b") Then Convert = Replace$(Convert,"\b",vbBack)
	If InStr(Convert,"\f") Then Convert = Replace$(Convert,"\f",vbFormFeed)
	If InStr(Convert,"\v") Then Convert = Replace$(Convert,"\v",vbVerticalTab)
	If InStr(Convert,"\t") Then Convert = Replace$(Convert,"\t",vbTab)
	If InStr(Convert,"\'") Then Convert = Replace$(Convert,"\'","'")
	If InStr(Convert,"\""") Then Convert = Replace$(Convert,"\""","""")
	If InStr(Convert,"\?") Then Convert = Replace$(Convert,"\?","?")
	If InStr(Convert,"\") Then Convert = ConvertB(Convert)
	If InStr(Convert,"\0") Then Convert = Replace$(Convert,"\0",vbNullChar)
	If InStr(Convert,"*a!N!d*") Then Convert = Replace$(Convert,"*a!N!d*","\")
End Function


'ת˽ƻʮת
Private Function ConvertB(ConverString As String) As String
	Dim i As Long,EscStr As String,ConvCode As String
	Dim ConvString As String,Stemp As Boolean
	ConvertB = ConverString
	i = InStr(ConvertB,"\")
	Do While i > 0
		EscStr = Mid$(ConvertB,i,2)
		Stemp = False
		If EscStr = "\x" Then
			ConvCode = Mid$(ConvertB,i + 2,2)
			Stemp = CheckStr(UCase$(ConvCode),CheckHexStr(0).AscRange,1)
		ElseIf EscStr = "\u" Then
			ConvCode = Mid$(ConvertB,i + 2,4)
			Stemp = CheckStr(UCase$(ConvCode),CheckHexStr(0).AscRange,1)
		ElseIf EscStr = "\U" Then
			ConvCode = Mid$(ConvertB,i + 2,4)
			Stemp = CheckStr(UCase$(ConvCode),CheckHexStr(0).AscRange,1)
		ElseIf EscStr <> "" Then
			EscStr = "\"
			ConvCode = Mid$(ConvertB,i + 1,3)
			Stemp = CheckStr(ConvCode,CheckHexStr(1).AscRange,1)
		End If
		If Stemp = True Then
			ConvString = ""
			If EscStr = "\x" Then ConvString = ChrW(Val("&H" & ConvCode))
			If LCase$(EscStr) = "\u" Then ConvString = ChrW(Val("&H" & ConvCode))
			If EscStr = "\" Then ConvString = ChrW(Val("&O" & ConvCode))
			If ConvString <> "" Then
				ConvertB = Replace$(ConvertB,EscStr & ConvCode,ConvString)
			End If
		End If
		i = InStr(i + 1,ConvertB,"\")
	Loop
End Function


'ת HEX ֵΪ Long 
Public Function HexToIntArray(HexRange As String) As Long()
	Dim i As Long,n As Long,TempList() As Long
	Dim HexValue() As String,TempArray() As String
	If HexRange = "" Then
		ReDim TempList(1) As Long
		HexToIntArray = TempList
		Exit Function
	End If
	HexValue = Split(HexRange,",",-1)
	n = UBound(HexValue)
	ReDim TempList(n * 2 + 1) As Long
	For i = 0 To n
		TempArray = Split(HexValue(i),"-")
		If UBound(TempArray) > 0 Then
			If TempArray(0) <> "" Then
				TempList(i * 2) = Val("&H" & TempArray(0))
			Else
				TempList(i * 2) = -1
			End If
			If TempArray(1) <> "" Then
				TempList(i * 2 + 1) = Val("&H" & TempArray(1))
			Else
				TempList(i * 2 + 1) = -1
			End If
		Else
			If TempArray(0) <> "" Then
				TempList(i * 2) = Val("&H" & TempArray(0))
				TempList(i * 2 + 1) = TempList(i * 2)
			Else
				TempList(i * 2) = -1
				TempList(i * 2 + 1) = -1
			End If
		End If
	Next i
	HexToIntArray = TempList
End Function


'תַΪֵ
Public Function StrToLong(mStr As String) As Long
	On Error GoTo localError
	If Trim$(mStr) = "" Then
		StrToLong = 0
	Else
		StrToLong = CLng(mStr)
	End If
	Exit Function
	localError:
	StrToLong = 0
End Function


'ȡִ
Function CheckGet(SelSet As String,DataList() As String,Path As String,Lang As String) As Long
	Dim i As Long,n As Long,j As Long,k As Long,Header As String,HeaderIDArr() As String
	Dim TempArray() As String,LineArray() As String,SetsArray() As String,Temp As String

	CheckGet = 0
	NewVersion = ToUpdateCheckVersion
	ReDim SetsArray(17)
	If SelSet = DefaultCheckList(0) Then SelSet = "en2zh"
	If SelSet = DefaultCheckList(1) Then SelSet = "zh2en"

	If Path = CheckRegKey Then GoTo GetFromRegistry
	If Path = "" Then Path = CheckFilePath
	If Dir(Path) = "" Then GoTo GetFromRegistry
	On Error GoTo GetFromRegistry
	LineArray = Split(ReadFile(Path,"_autodetect_all"),vbCrLf)
	n = UBound(LineArray)
	For i = 0 To n
		l$ = LineArray(i)
		If Trim(l$) <> "" Then
			If Left(Trim(l$),1) = "[" And Right(Trim(l$),1) = "]" Then
				Header = Trim(Mid(Trim(L$),2,Len(Trim(L$))-2))
			End If
			If Header <> "" And HeaderBak = "" Then HeaderBak = Header
			If Header <> "" And Header = HeaderBak Then
				setPreStr = ""
				setAppStr = ""
				j = InStr(L$,"=")
				If j > 0 Then
					setPreStr = Trim(Left(L$,j - 1))
					setAppStr = LTrim(Mid(L$,j + 1))
				End If
				If setPreStr <> "" Then
					'ȡ Option ֵ
					If setPreStr = "Version" Then CheckVersion = setAppStr
					If Header = "Option" Then
						If SelSet = "" Or SelSet = "Option" Then
							If setPreStr = "AutoMacroSet" Then cSelected(0) = setAppStr
							If setPreStr = "AutoSelection" Then cSelected(3) = setAppStr
							If setPreStr = "AutoRepString" Then cSelected(24) = setAppStr
							If setPreStr = "UILanguageID" Then cSelected(26) = setAppStr
						End If
					'ȡ Project ֵ
					ElseIf Header = "Projects" Then
						If SelSet = "" Or SelSet = "Project" Then
							If setAppStr <> "" Then
								If setPreStr = "CheckOnly" Then setPreStr = DefaultProjectList(0)
								If setPreStr = "CheckAndCorrect" Then setPreStr = DefaultProjectList(1)
								If setPreStr = "DelAccessKey" Then setPreStr = DefaultProjectList(2)
								If setPreStr = "DelAccelerator" Then setPreStr = DefaultProjectList(3)
								If setPreStr = "DelAccessKeyAndAccelerator" Then setPreStr = DefaultProjectList(4)
								ReDim Preserve ProjectDataList(k)
								ProjectDataList(k) = setPreStr & JoinStr & setAppStr
								k = k + 1
							End If
						End If
					'ȡ Option ȫֵ
					ElseIf Header <> "Update" Then
						If SelSet = "" Or SelSet = "Sets" Or SelSet = Header Then
							If setPreStr = "ExcludeChar" Then SetsArray(0) = setAppStr
							If setPreStr = "LineSplitChar" Then SetsArray(1) = setAppStr
							If setPreStr = "CheckBracket" Then SetsArray(2) = setAppStr
							If setPreStr = "KeepCharPair" Then SetsArray(3) = setAppStr
							If setPreStr = "ShowAsiaKey" Then SetsArray(4) = setAppStr
							If setPreStr = "CheckEndChar" Then SetsArray(5) = setAppStr
							If setPreStr = "NoTrnEndChar" Then SetsArray(6) = setAppStr
							If setPreStr = "AutoTrnEndChar" Then SetsArray(7) = setAppStr
							If setPreStr = "CheckShortChar" Then SetsArray(8) = setAppStr
							If setPreStr = "CheckShortKey" Then SetsArray(9) = setAppStr
							If setPreStr = "KeepShortKey" Then SetsArray(10) = setAppStr
							If setPreStr = "PreRepString" Then SetsArray(11) = setAppStr
							If setPreStr = "AutoRepString" Then SetsArray(12) = setAppStr
							If setPreStr = "AccessKeyChar" Then SetsArray(13) = setAppStr
							If setPreStr = "AddAccessKeyWithFirstChar" Then SetsArray(14) = setAppStr
							If setPreStr = "LineSplitMode" Then SetsArray(15) = setAppStr
							If setPreStr = "AppInsertSplitChar" Then SetsArray(16) = setAppStr
							If setPreStr = "ReplaceSplitChar" Then SetsArray(17) = setAppStr
							If setPreStr = "ApplyLangList" Then LngPair = setAppStr
						End If
					End If
				End If
			End If
		End If
		If Header <> "" And (i = n Or Header <> HeaderBak) Then
			If SelSet = "Option" And HeaderBak = "Option" Then
				If CheckArray(cSelected) = True Then CheckGet = 1
				Exit For
			ElseIf SelSet = "Project" And HeaderBak = "Projects" Then
				If k > 0 Then CheckGet = 3
				Exit For
			ElseIf HeaderBak <> "Option" And HeaderBak <> "Update" And HeaderBak <> "Projects" Then
				If SelSet = "" And cSelected(0) = "" And cSelected(3) = "" Then cSelected(3) = "1"
				If Lang <> "" And cSelected(3) = "1" Then
					If getCheckID(LngPair,Lang) = True Then SelSet = HeaderBak
				End If
				If HeaderBak = SelSet Or (Lang = "" And HeaderBak = cSelected(0)) Then
					Temp = Join(SetsArray,"")
					If Temp <> "" And Temp <> "0" And Temp <> "1" Then
						If HeaderBak = "en2zh" Then HeaderBak = DefaultCheckList(0)
						If HeaderBak = "zh2en" Then HeaderBak = DefaultCheckList(1)
						Data = HeaderBak & JoinStr & Join(SetsArray,SubJoinStr) & JoinStr & LngPair
						'¾ɰĬֵ
						If CheckVersion <> "" And StrComp(NewVersion,CheckVersion) = 1 Then
							Data = CheckDataUpdate(HeaderBak,Data)
						End If
						DataList(0) = Data
						CheckGet = 4
						Exit For
					End If
					'ݳʼ
					ReDim SetsArray(17)
					LngPair = ""
				End If
			End If
			HeaderBak = Header
		End If
	Next i
	On Error GoTo 0
	If CheckGet = 0 Then GoTo GetFromRegistry
	Exit Function

	GetFromRegistry:
	ReDim SetsArray(17)
	'ȡ Option ֵ
	CheckVersion = GetSetting("AccessKey","Option","Version","")
	If SelSet = "" Or SelSet = "Option" Then
		cSelected(0) = GetSetting("AccessKey","Option","AutoMacroSet","")
		cSelected(3) = GetSetting("AccessKey","Option","AutoSelection",1)
		cSelected(24) = GetSetting("AccessKey","Option","AutoRepString",0)
		cSelected(26) = GetSetting("AccessKey","Option","UILanguageID",0)
		If SelSet = "Option" Then
			If CheckArray(cSelected) = True Then CheckGet = 1
			Exit Function
		End If
	End If
	'ȡ Project ֵ
	If SelSet = "" Or SelSet = "Project" Then
		k = 0
		On Error GoTo NextItem
		TempArray = GetAllSettings("AccessKey","Projects")
		For i = LBound(TempArray) To UBound(TempArray)
			setPreStr = TempArray(i,0)
			setAppStr = TempArray(i,1)
			If setPreStr <> "" And setAppStr <> "" Then
				If setPreStr = "CheckOnly" Then setPreStr = DefaultProjectList(0)
				If setPreStr = "CheckAndCorrect" Then setPreStr = DefaultProjectList(1)
				If setPreStr = "DelAccessKey" Then setPreStr = DefaultProjectList(2)
				If setPreStr = "DelAccelerator" Then setPreStr = DefaultProjectList(3)
				If setPreStr = "DelAccessKeyAndAccelerator" Then setPreStr = DefaultProjectList(4)
				ReDim Preserve ProjectDataList(k)
				ProjectDataList(k) = setPreStr & JoinStr & setAppStr
				k = k + 1
			End If
		Next i
		On Error GoTo 0
		NextItem:
		If SelSet = "Project" Then
			If k > 0 Then CheckGet = 3
			Exit Function
		End If
	End If
	'ȡ Option ֵ
	If SelSet <> "Option" And SelSet <> "Update" And SelSet <> "Project" Then
		If SelSet = "" And cSelected(0) = "" And cSelected(3) = "" Then cSelected(3) = "1"
		Header = GetSetting("AccessKey","Option","Headers","")
		If Header <> "" Then
			HeaderIDArr = Split(Header,";",-1)
			n = UBound(HeaderIDArr)
			For i = 0 To n
				HeaderID = HeaderIDArr(i)
				If HeaderID <> "" Then
					'תɰÿֵ
					Header = GetSetting("AccessKey",HeaderID,"Name","")
				End If
				If Header = "" Then Header = HeaderID
				If Lang <> "" And cSelected(3) = "1" Then
					LngPair = GetSetting("AccessKey",HeaderID,"ApplyLangList","")
					If getCheckID(LngPair,Lang) = True Then SelSet = Header
				End If
				If Header = SelSet Or (Lang = "" And Header = cSelected(0)) Then
					SetsArray(0) = GetSetting("AccessKey",HeaderID,"ExcludeChar","")
					SetsArray(1) = GetSetting("AccessKey",HeaderID,"LineSplitChar","")
					SetsArray(2) = GetSetting("AccessKey",HeaderID,"CheckBracket","")
					SetsArray(3) = GetSetting("AccessKey",HeaderID,"KeepCharPair","")
					SetsArray(4) = GetSetting("AccessKey",HeaderID,"ShowAsiaKey","")
					SetsArray(5) = GetSetting("AccessKey",HeaderID,"CheckEndChar","")
					SetsArray(6) = GetSetting("AccessKey",HeaderID,"NoTrnEndChar","")
					SetsArray(7) = GetSetting("AccessKey",HeaderID,"AutoTrnEndChar","")
					SetsArray(8) = GetSetting("AccessKey",HeaderID,"CheckShortChar","")
					SetsArray(9) = GetSetting("AccessKey",HeaderID,"CheckShortKey","")
					SetsArray(10) = GetSetting("AccessKey",HeaderID,"KeepShortKey","")
					SetsArray(11) = GetSetting("AccessKey",HeaderID,"PreRepString","")
					SetsArray(12) = GetSetting("AccessKey",HeaderID,"AutoRepString","")
					SetsArray(13) = GetSetting("AccessKey",HeaderID,"AccessKeyChar","")
					SetsArray(14) = GetSetting("AccessKey",HeaderID,"AddAccessKeyWithFirstChar","")
					SetsArray(15) = GetSetting("AccessKey",HeaderID,"LineSplitMode","")
					SetsArray(16) = GetSetting("AccessKey",HeaderID,"AppInsertSplitChar","")
					SetsArray(17) = GetSetting("AccessKey",HeaderID,"ReplaceSplitChar","")
					LngPair = GetSetting("AccessKey",HeaderID,"ApplyLangList","")
					Temp = Join(SetsArray,"")
					If Temp <> "" And Temp <> "0" And Temp <> "1" Then
						If Header = "en2zh" Then Header = DefaultCheckList(0)
						If Header = "zh2en" Then Header = DefaultCheckList(1)
						Data = Header & JoinStr & Join(SetsArray,SubJoinStr) & JoinStr & LngPair
						'¾ɰĬֵ
						If CheckVersion <> "" And StrComp(NewVersion,CheckVersion) = 1 Then
							Data = CheckDataUpdate(Header,Data)
						End If
						DataList(0) = Data
						CheckGet = 4
						Exit For
					End If
					'ݳʼ
					ReDim SetsArray(17)
					LngPair = ""
				End If
			Next i
		End If
	End If
End Function


'¼ɰ汾ֵ
Function CheckDataUpdate(Header As String,Data As String) As String
	Dim UpdatedData As String,uV As String,dV As String,spStr As String,Stemp As Boolean
	Dim i As Long,j As Long,m As Long,uDataList() As String,dDataList() As String,dSetsArray() As String
	CheckDataUpdate = Data
	Stemp = False
	For i = LBound(DefaultCheckList) To UBound(DefaultCheckList)
		If DefaultCheckList(i) = Header Then
			Stemp = True
			Exit For
		End If
	Next i
	If Stemp = False Then Exit Function
	dData = CheckSettings(Header,0)
	If CheckDataUpdate = dData Then Exit Function
	dSetsArray = Split(dData,SubJoinStr)
	If CheckArray(dSetsArray) = False Then Exit Function
	TempArray = Split(Data,JoinStr)
	uSetsArray = Split(TempArray(1),SubJoinStr)
	For i = 0 To UBound(uSetsArray)
		uV = uSetsArray(i)
		dV = dSetsArray(i)
		If Trim(uV) = "" Or i = 1 Or i = 6 Then uV = dV
		If i <> 4 And i <> 14 And i <> 15 And i < 18 And uV <> "" And uV <> dV Then
			If i = 5 Or i = 7 Then spStr = " " Else spStr = ","
			If i = 7 And InStr(uV,"|") = 0 Then
				uDataList = Split(uV,spStr)
				For m = 0 To UBound(uDataList)
					uV = uDataList(m)
					uDataList(m) = Left(Trim(uV),1) & "|" & Right(Trim(uV),1)
				Next m
				uV = Join(uDataList,spStr)
			End If
			uV = Join(ClearArray(Split(uV & spStr & dV,spStr,-1)),spStr)
		End If
		uSetsArray(i) = uV
	Next i
	TempArray(1) = Join(uSetsArray,SubJoinStr)
	CheckDataUpdate = Join(TempArray,JoinStr)
End Function


'ӻĿ
Function CreateArray(Header As String,Data As String,HeaderList() As String,DataList() As String) As Boolean
	Dim i As Long,n As Long,FindHeader As String,Stemp As Boolean
	If HeaderList(0) = "" Then
		HeaderList(0) = Header
		DataList(0) = Data
		CreateArray = True
	Else
		Stemp = False
		n = UBound(HeaderList)
		FindHeader = LCase$(Header)
		For i = LBound(HeaderList) To n
			If LCase$(HeaderList(i)) = FindHeader Then
				If DataList(i) <> Data Then DataList(i) = Data
				Stemp = True
				Exit For
			End If
		Next i
		If Stemp = False Then
			n = n + 1
			ReDim Preserve HeaderList(n),DataList(n)
			HeaderList(n) = Header
			If DataList(n) <> Data Then DataList(n) = Data
			CreateArray = True
		End If
	End If
End Function


'ֵָǷ
Function getCheckID(Data As String,LngCode As String) As Boolean
	Dim i As Long,FindCode As String,Stemp As Boolean
	getCheckID = False
	If LngCode = "" Or Data = "" Then Exit Function
	FindCode = LCase(LngCode)
	LangArray = Split(Data,SubLngJoinStr)
	For i = 0 To UBound(LangArray)
		LangPairList = Split(LangArray(i),LngJoinStr)
		If LCase(LangPairList(1)) = FindCode Then
			getCheckID = True
			Exit For
		End If
	Next i
End Function


'
Function SortArray(xArray() As String,Comp As Long,CompType As String,Operator As String) As Variant
	Dim rMin As Long,rMax As Long,MaxLng As Long,Lng As Long,yArray() As String
	Dim fLng As Long,sLng As Long,MyComp As Long,x As Long,y As Long
	SortArray = xArray
	rMin = LBound(xArray)
	rMax = UBound(xArray)
	If rMax = 0 Or CompType = "" Or Operator = "" Then Exit Function
	yArray = xArray
    MaxLng = 1
    For x = rMin To rMax
        Lng = Len(Trim(yArray(x)))
        If Lng > MaxLng Then MaxLng = Lng
    Next
	For x = rMax To rMin Step -1
		For y = rMin To rMax - 1
			fLng = Len(Trim(yArray(y)))
			sLng = Len(Trim(yArray(y+1)))
			If CompType = "Size" Then
				fValue = String(MaxLng - fLng,"0") & yArray(y)
				sValue = String(MaxLng - sLng,"0") & yArray(y+1)
				MyComp = StrComp(fValue,sValue,Comp)
			End If
			If CompType = "Lenght" Then
				If fLng < sLng Then MyComp = -1
				If fLng = sLng Then MyComp = 0
				If fLng > sLng Then MyComp = 1
			End If
			If Operator = ">" Then
				If MyComp > 0 Then
					Mx = yArray(y + 1)
					yArray(y+1) = yArray(y)
					yArray(y) = Mx
				End If
			ElseIf Operator = "<" Then
				If MyComp < 0 Then
					Mx = yArray(y + 1)
					yArray(y+1) = yArray(y)
					yArray(y) = Mx
				End If
			ElseIf Operator = "=" Then
				If MyComp = 0 Then
					Mx = yArray(y + 1)
					yArray(y+1) = yArray(y)
					yArray(y) = Mx
				End If
			End If
		Next y
	Next x
	SortArray = yArray
End Function


'ظ
'Mode = 0 
Function ClearArray(xArray() As String,Optional Mode As Long) As String()
	Dim i As Long,n As Long,yArray() As String,Dic As Object
	ClearArray = xArray
	n = UBound(xArray)
	If n = 0 Then Exit Function
	Set Dic = CreateObject("Scripting.Dictionary")
	ReDim yArray(n)
	n = 0
	For i = LBound(xArray) To UBound(xArray)
		If Mode > 0 Then
			If xArray(i) <> "" Then
				If Not Dic.Exists(xArray(i)) Then
					Dic.Add(xArray(i),"")
					yArray(n) = xArray(i)
					n = n + 1
				End If
			End If
		ElseIf Not Dic.Exists(xArray(i)) Then
			Dic.Add(xArray(i),"")
			yArray(n) = xArray(i)
			n = n + 1
		End If
	Next i
	If n > 0 Then n = n - 1
	ReDim Preserve yArray(n)
	ClearArray = yArray
End Function


'ִǷΪգǿշ True
Function CheckArray(DataList() As String) As Boolean
	Dim i As Long
	For i = LBound(DataList) To UBound(DataList)
		If DataList(i) <> "" Then
			CheckArray = True
			Exit For
		End If
	Next i
End Function


'ֵָͨ
Function CheckKeyCode(FindKey As String,CheckKey As String) As Long
	Dim KeyCode As Boolean,FindStr As String,Key As String,Pos As Long
	Key = Trim(FindKey)
	CheckKeyCode = 0
	If InStr(Key,"%") Then Key = Replace(Key,"%","x")
	If CheckKey <> "" And Key <> "" Then
		FindStrArr = Split(Convert(CheckKey),",",-1)
		For i = 0 To UBound(FindStrArr)
			FindStr = Trim(FindStrArr(i))
			If InStr(FindStr,"%") Then FindStr = Replace(FindStr,"%","x")
			If InStr(FindStr,"-") Then
				If Left(FindStr,1) <> "[" And Right(FindStr,1) <> "]" Then
					FindStr = "[" & FindStr & "]"
				End If
			End If
			Pos = InStr(FindStr,"[")
			If Pos > 0 Then
				If Left(FindStr,Pos-1) <> "[" And Right(FindStr,Pos+1) <> "]" Then
					FindStr = Replace(FindStr,"[","[[]")
				End If
			End If
			KeyCode = False
			CheckKeyCode = 0
			'PSL.Output Key & " : " &  FindStr  '
			KeyCode = UCase(Key) Like UCase(FindStr)
			If KeyCode = True Then
				CheckKeyCode = 1
				Exit For
			End If
		Next i
	ElseIf CheckKey = "" And Key <> "" Then
		CheckKeyCode = 1
	End If
End Function


'ȥִǰָ PreStr  AppStr
'fType = 0 ȥִǰĿոָ PreStr  AppStrȥִǰո
'fType = 1 ȥִǰĿոָ PreStr  AppStrȥִǰո
'fType = 2 ȥִǰĿոָ PreStr  AppStr 1 Σȥִǰո
'fType > 2 ȥִǰĿոָ PreStr  AppStr 1 Σȥִǰո
Function RemoveBackslash(Path As String,PreStr As String,AppStr As String,fType As Long) As String
	Dim i As Long,a As Long,p As Long,Stemp As Boolean
	RemoveBackslash = Path
	If Path = "" Then Exit Function
	a = Len(AppStr)
	p = Len(PreStr)
	RemoveBackslash = Trim(RemoveBackslash)
	Do
		Stemp = False
		If p <> 0 Then
			If Left(RemoveBackslash,p) = PreStr Then
				RemoveBackslash = Mid(RemoveBackslash,p + 1)
				Stemp = True
			End If
		End If
		If a <> 0 Then
			If Right(RemoveBackslash,a) = AppStr Then
				RemoveBackslash = Left(RemoveBackslash,Len(RemoveBackslash) - a)
				Stemp = True
			End If
		End If
		If fType = 1 Or fType > 2 Then RemoveBackslash = Trim(RemoveBackslash)
		If Stemp = True Then
			If fType < 2 Then i = 0 Else i = 1
		Else
			i = 1
		End If
	Loop Until i = 1
End Function


' ȡıļ
Function ReadFile(FilePath As String,CharSet As String) As String
	Dim objStream As Object,Code As String,FN As Variant,l As String
	If Dir$(FilePath) = "" Then Exit Function
	On Error Resume Next
	Set objStream = CreateObject("Adodb.Stream")
	On Error GoTo ErrorMsg
	Code = CharSet
	If Not objStream Is Nothing Then
		'If Code = "" Then Code = CheckCode(FilePath)
		If Code = "" Then Code = "_autodetect_all"
		If Code = "utf-8EFBB" Then Code = "utf-8"
		If Code <> "ANSI" Then
			With objStream
				.Type = 2
				.Mode = 3
				.Charset = Code
				.Open
				.LoadFromFile FilePath
				ReadFile = .ReadText
				.Close
			End With
		End If
	End If
	If objStream Is Nothing Or Code = "ANSI" Then
		FN = FreeFile
		Open FilePath For Input As #FN
		While Not EOF(FN)
			Line Input #FN,l$
			If ReadFile <> "" Then ReadFile = ReadFile & vbCrLf & l$
			If ReadFile = "" Then ReadFile = l$
		Wend
		Close #FN
	End If
	If CharSet = "" Then CharSet = Code
	Set objStream = Nothing
	Exit Function

	ErrorMsg:
	ReadFile = ""
	If objStream Is Nothing Or Code = "ANSI" Then Close #FN
	Set objStream = Nothing
	Err.Source = "NotReadFile"
	Err.Description = Err.Description & JoinStr & FilePath
	Call sysErrorMassage(Err,1)
End Function


'ԴблȡָĿĿб
Function getMsgList(SourceList() As String,TargetList() As String,Items As String,fType As Long) As Boolean
	Dim i As Long,j As Long,n As Long,ItemMax As Long
	Dim ItemList() As String,TempList() As String,TempArray() As String
	getMsgList = False
	ItemList = Split(Items,"|")
	ItemMax = UBound(ItemList)
	n = 0
	For i = 0 To UBound(SourceList)
		TempArray = Split(SourceList(i),JoinStr)
		For j = 0 To ItemMax
			If TempArray(0) = ItemList(j) Then
				ReDim Preserve TempList(n)
				TempList(n) = TempArray(2)
				ItemList(j) = ""
				n = n + 1
				Exit For
			End If
		Next j
		If n = ItemMax + 1 Then
			TargetList = Split(Join(TempList,SubJoinStr),SubJoinStr)
			Items = Join(ItemList,"|")
			getMsgList = True
			Exit For
		End If
	Next i
	If getMsgList = False Then
		If fType = 0 Then
			Err.Raise(1,"NotSection",LangFile & JoinStr & Items)
		ElseIf fType < 3 Then
			On Error GoTo ErrorMassage
			Err.Raise(1,"NotSection",LangFile & JoinStr & Items)
			ErrorMassage:
			Call sysErrorMassage(Err,fType)
		End If
	End If
End Function


'ȡ INI ļ
Function getUILangList(UIFile As String,TargetList() As String) As Boolean
	Dim i As Long,m As Long,n As Long,j As Long,Max As Long,FN As Variant
	Dim ItemList() As String,ValueList() As String,LineArray() As String,readByte() As Byte
	Dim l As String,Header As String,HeaderBak As String,setPreStr As String,setAppStr As String
	On Error GoTo ErrorMsg
	i = FileLen(UIFile)
	ReDim readByte(i) As Byte,ItemList(0) As String,ValueList(0) As String
	FN = FreeFile
	Open UIFile For Binary As #FN
	Get #FN,,readByte
	Close #FN
	LineArray = Split(readByte,vbCrLf)
	Erase readByte
	If CheckArray(LineArray) = False Then Exit Function
	Max = UBound(LineArray)
	n = 0
	For i = 0 To Max
		l$ = Trim(LineArray(i))
		If l$ <> "" Then
			If Left$(l$,1) = "[" And Right$(l$,1) = "]" Then
				Header$ = Trim$(Mid$(l$,2,Len(l$)-2))
			End If
			If Header$ <> "" And HeaderBak$ = "" Then HeaderBak$ = Header$
			If Header$ <> "" And Header$ = HeaderBak$ Then
				j = InStr(l$,"=")
				If j > 0 Then
					setPreStr$ = Trim$(Left$(l$,j - 1))
					setAppStr$ = Trim$(Mid$(l$,j + 1))
					If setPreStr$ <> "" Then
						ReDim Preserve ItemList(n),ValueList(n)
						ItemList(n) = setPreStr$
						ValueList(n) = Convert(RemoveBackslash(setAppStr$,"""","""",2))
						n = n + 1
					End If
				End If
			End If
		End If
		If Header$ <> "" And (i = Max Or Header$ <> HeaderBak$) Then
			If n > 0 Then
				ReDim Preserve TargetList(m)
				TargetList(m) = HeaderBak$ & JoinStr & Join(ItemList,SubJoinStr) & _
								JoinStr &  Join(ValueList,SubJoinStr)
				m = m + 1
				n = 0
				getUILangList = True
			End If
			HeaderBak$ = Header$
		End If
	Next i
	Exit Function

	ErrorMsg:
	Err.Source = "NotINIFile"
	Err.Description = Err.Description & JoinStr & UIFile
	Call sysErrorMassage(Err,0)
End Function


'ȡļб
Function GetUIList(List() As String,DataList() As String) As Boolean
	Dim i As Long,j As Long,Max As Long,readByte() As Byte,FN As Variant
	Dim File As String,Header As String,setPreStr As String,setAppStr As String,l As String
	Dim TempArray() As String,OldAppName As String,OldVersion As String,LangName As String
	Dim LangID As String,Encoding As String
	GetUIList = False
	File = Dir$(MacroDir & "\Data\" & AppName & "_*.lng")
	Do While File <> ""
		If LCase$(Mid$(File,InStrRev(File,".") + 1)) = "lng" Then
			i = FileLen(MacroDir & "\Data\" & File)
			ReDim readByte(i) As Byte
			On Error Resume Next
			FN = FreeFile
			Open MacroDir & "\Data\" & File For Binary As #FN
			Get #FN,,readByte
			Close #FN
			On Error GoTo 0
			TempArray = Split(readByte,vbCrLf)
			Max = UBound(TempArray)
			For i = 0 To Max
				l$ = Trim(TempArray(i))
				If l$ <> "" Then
					If Left$(l$,1) = "[" And Right$(l$,1) = "]" Then
						Header = Trim$(Mid$(l$,2,Len(l$)-2))
					End If
					If Header = "Option" Then
						j = InStr(l$,"=")
						If j > 0 Then
							setPreStr = Trim$(Left$(l$,j - 1))
							setAppStr = Trim$(Mid$(l$,j + 1))
							If setAppStr <> "" Then setAppStr = RemoveBackslash(setAppStr,"""","""",0)
							If setPreStr = "AppName" Then OldAppName = setAppStr
							If setPreStr = "Version" Then OldVersion = setAppStr
							If setPreStr = "LanguageName" Then LangName = setAppStr
							If setPreStr = "LanguageID" Then LangID = setAppStr
							If setPreStr = "Encoding" Then Encoding = setAppStr
						End If
					End If
				End If
				If Header <> "" And (i = Max Or Header <> "Option") Then
					Header = ""
					Exit For
				End If
			Next i
			If LCase$(OldAppName) = LCase$(AppName) And OldVersion = Version And LangName <> "" Then
				CreateArray(LangName,LangName & JoinStr & LangID & JoinStr & File,List,DataList)
				OldVersion = ""
				OldAppName = ""
				LangName = ""
				LangID = ""
				Encoding = ""
				GetUIList = True
			End If
		End If
		File = Dir$()
	Loop
End Function
