/*
 * Decompiled with CFR 0.152.
 */
package com.tulskiy.keymaster.osx;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.MediaKey;
import com.tulskiy.keymaster.common.Provider;
import com.tulskiy.keymaster.osx.Carbon;
import com.tulskiy.keymaster.osx.KeyMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.swing.KeyStroke;

public class CarbonProvider
extends Provider {
    private static final int kEventHotKeyPressed = 5;
    private static final int kEventClassKeyboard = CarbonProvider.OS_TYPE("keyb");
    private static final int typeEventHotKeyID = CarbonProvider.OS_TYPE("hkid");
    private static final int kEventParamDirectObject = CarbonProvider.OS_TYPE("----");
    private static int idSeq = 1;
    private Map<Integer, OSXHotKey> hotKeys = new HashMap<Integer, OSXHotKey>();
    private Queue<OSXHotKey> registerQueue = new LinkedList<OSXHotKey>();
    private final Object lock = new Object();
    private boolean listen;
    private boolean reset;
    private Carbon.EventHandlerProcPtr keyListener;
    private PointerByReference eventHandlerReference;
    public Thread thread;

    public void init() {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = CarbonProvider.this.lock;
                synchronized (object) {
                    Provider.logger.info("Installing Event Handler");
                    CarbonProvider.this.eventHandlerReference = new PointerByReference();
                    CarbonProvider.this.keyListener = new EventHandler();
                    Carbon.EventTypeSpec[] eventTypes = (Carbon.EventTypeSpec[])new Carbon.EventTypeSpec().toArray(1);
                    eventTypes[0].eventClass = kEventClassKeyboard;
                    eventTypes[0].eventKind = 5;
                    int status = Carbon.Lib.InstallEventHandler(Carbon.Lib.GetEventDispatcherTarget(), CarbonProvider.this.keyListener, 1, eventTypes, null, CarbonProvider.this.eventHandlerReference);
                    if (status != 0) {
                        Provider.logger.warning("Could not register Event Handler, error code: " + status);
                    }
                    if (CarbonProvider.this.eventHandlerReference.getValue() == null) {
                        Provider.logger.warning("Event Handler reference is null");
                    }
                    CarbonProvider.this.listen = true;
                    while (CarbonProvider.this.listen) {
                        if (CarbonProvider.this.reset) {
                            CarbonProvider.this.resetAll();
                            CarbonProvider.this.reset = false;
                            CarbonProvider.this.lock.notify();
                        }
                        while (!CarbonProvider.this.registerQueue.isEmpty()) {
                            CarbonProvider.this.register((OSXHotKey)CarbonProvider.this.registerQueue.poll());
                        }
                        try {
                            CarbonProvider.this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        this.thread.start();
    }

    private void resetAll() {
        logger.info("Resetting hotkeys");
        for (OSXHotKey hotKey : this.hotKeys.values()) {
            int ret = Carbon.Lib.UnregisterEventHotKey(hotKey.handler.getValue());
            if (ret == 0) continue;
            logger.warning("Could not unregister hotkey. Error code: " + ret);
        }
        this.hotKeys.clear();
    }

    private void register(OSXHotKey hotKey) {
        int id;
        KeyStroke keyCode = hotKey.keyStroke;
        Carbon.EventHotKeyID.ByValue hotKeyReference = new Carbon.EventHotKeyID.ByValue();
        hotKeyReference.id = id = idSeq++;
        hotKeyReference.signature = CarbonProvider.OS_TYPE("hk" + String.format("%02d", id));
        PointerByReference gMyHotKeyRef = new PointerByReference();
        int status = Carbon.Lib.RegisterEventHotKey(KeyMap.getKeyCode(keyCode), KeyMap.getModifier(keyCode), hotKeyReference, Carbon.Lib.GetEventDispatcherTarget(), 0, gMyHotKeyRef);
        if (status != 0) {
            logger.warning("Could not register HotKey: " + keyCode + ". Error code: " + status);
            return;
        }
        if (gMyHotKeyRef.getValue() == null) {
            logger.warning("HotKey returned null handler reference");
            return;
        }
        hotKey.handler = gMyHotKeyRef;
        logger.info("Registered hotkey: " + keyCode);
        this.hotKeys.put(id, hotKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        logger.info("Stopping now");
        try {
            Object object = this.lock;
            synchronized (object) {
                this.listen = false;
                this.lock.notify();
            }
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.eventHandlerReference.getValue() != null) {
            Carbon.Lib.RemoveEventHandler(this.eventHandlerReference.getValue());
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.reset = true;
            this.lock.notify();
            try {
                this.lock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(KeyStroke keyCode, HotKeyListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new OSXHotKey(keyCode, listener));
            this.lock.notify();
        }
    }

    public void register(MediaKey mediaKey, HotKeyListener listener) {
        logger.warning("Media keys are not supported on this platform");
    }

    private static int OS_TYPE(String osType) {
        byte[] bytes = osType.getBytes();
        return (bytes[0] << 24) + (bytes[1] << 16) + (bytes[2] << 8) + bytes[3];
    }

    class OSXHotKey
    extends HotKey {
        PointerByReference handler;

        public OSXHotKey(KeyStroke keyStroke, HotKeyListener listener) {
            super(keyStroke, listener);
        }
    }

    private class EventHandler
    implements Carbon.EventHandlerProcPtr {
        private EventHandler() {
        }

        public int callback(Pointer inHandlerCallRef, Pointer inEvent, Pointer inUserData) {
            Carbon.EventHotKeyID eventHotKeyID = new Carbon.EventHotKeyID();
            int ret = Carbon.Lib.GetEventParameter(inEvent, kEventParamDirectObject, typeEventHotKeyID, null, eventHotKeyID.size(), null, eventHotKeyID);
            if (ret != 0) {
                Provider.logger.warning("Could not get event parameters. Error code: " + ret);
            } else {
                int eventId = eventHotKeyID.id;
                Provider.logger.info("Received event id: " + eventId);
                CarbonProvider.this.fireEvent((HotKey)CarbonProvider.this.hotKeys.get(eventId));
            }
            return 0;
        }
    }
}

