/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.note;

import java.io.Serializable;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.gui.mydoc.note.NoteSpecBuilder;
import myencyclopedia.model.Entity;
import myencyclopedia.model.mydoc.Note;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotePropertyEditingStage
extends Stage {
    private EntityView entityView;
    private static final Logger logger = LoggerFactory.getLogger(NotePropertyEditingStage.class);
    private Note note;
    private SessionFactory sf;
    private boolean isSaved;
    private MenuItem mFav;
    private MenuItem mSave;
    private MenuItem mCancel;
    private MenuItem mOpen;
    private MenuItem mDelete;
    private MenuItem mContaining;
    protected BorderPane bp;
    protected Scene scene;

    public NotePropertyEditingStage(SessionFactory sf) {
        this.sf = sf;
        this.getIcons().add((Object)ImageFactory.IMG_STAGE_NOTE_PROP);
        this.entityView = new EntityView();
        this.entityView.enableDisplayEntityToString(true);
        this.entityView.setCollapsible(false);
        NoteSpecBuilder.buildNoteNewSpec(this.entityView);
        ScrollPane sp = new ScrollPane();
        sp.setFitToWidth(true);
        sp.setContent((Node)this.entityView);
        MenuBar bar = new MenuBar();
        Menu menuAction = new Menu(MydocMain.rb.getString("MENU_ACTION"));
        menuAction.setMnemonicParsing(true);
        this.mOpen = new MenuItem(MydocMain.rb.getString("MENU_OPEN"));
        this.mOpen.setMnemonicParsing(true);
        this.mOpen.setOnAction(t -> {
            MydocMain.getInstance().releaseEntity((Entity)this.note);
            this.hide();
            MydocMain.actionOpen((Entity)this.note);
        });
        this.mDelete = new MenuItem(MydocMain.rb.getString("MENU_DELETE"));
        this.mDelete.setMnemonicParsing(true);
        this.mDelete.setOnAction(t -> {
            MydocMain.actionDelete((Entity)this.note);
            this.hide();
        });
        this.mFav = new MenuItem(MydocMain.rb.getString("MENU_FAVOURITE"));
        this.mFav.setMnemonicParsing(true);
        this.mFav.setOnAction(t -> MydocMain.actionFavourite((Entity)this.note));
        this.mContaining = new MenuItem(MydocMain.rb.getString("MENU_CONTAINING_FOLDER"));
        this.mContaining.setMnemonicParsing(true);
        this.mContaining.setOnAction(t -> MydocMain.actionGotoFolder((Entity)this.note));
        this.mSave = new MenuItem(MydocMain.rb.getString("MENU_SAVE_QUIT"));
        this.mSave.setMnemonicParsing(true);
        this.mSave.setOnAction(t -> {
            this.save();
            this.hide();
        });
        this.mCancel = new MenuItem(MydocMain.rb.getString("MENU_QUIT_NO_SAVE"));
        this.mCancel.setMnemonicParsing(true);
        this.mCancel.setOnAction(t -> this.hide());
        menuAction.getItems().addAll((Object[])new MenuItem[]{this.mOpen, this.mContaining, this.mFav, this.mDelete, new SeparatorMenuItem(), this.mSave, this.mCancel});
        bar.getMenus().addAll((Object[])new Menu[]{menuAction});
        this.bp = new BorderPane();
        this.bp.setCenter((Node)sp);
        this.bp.setTop((Node)bar);
        this.scene = new Scene((Parent)this.bp);
        this.setScene(this.scene);
        this.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                MydocMain.getInstance().releaseEntity((Entity)NotePropertyEditingStage.this.note);
                if (NotePropertyEditingStage.this.isSaved) {
                    MydocMain.getInstance().updateMainList((Entity)NotePropertyEditingStage.this.note, MydocMain.ListOperationMode.Modify);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntity(Long id) {
        this.isSaved = false;
        try (Session s = this.sf.openSession();){
            this.note = (Note)s.get(Note.class, (Serializable)id);
            this.setTitle(this.note.toString());
            if (this.note.isFavourite()) {
                this.mFav.setText(MydocMain.rb.getString("MENU_UNMAKR_FAV"));
            } else {
                this.mFav.setText(MydocMain.rb.getString("MENU_MAKR_FAV"));
            }
            this.entityView.setEntity((Entity)this.note);
        }
    }

    protected void save() {
        Session s = this.sf.openSession();
        s.beginTransaction();
        try {
            s.update((Object)this.note);
            s.getTransaction().commit();
            this.isSaved = true;
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        finally {
            s.close();
        }
    }
}

