/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.note;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import myencyclopedia.logic.mydoc.NoteManager;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentParser {
    private static final Logger logger = LoggerFactory.getLogger(ContentParser.class);
    public int fontSize = -1;
    public boolean isMathEnabled = false;
    public boolean isCodeHighlightEnabled = false;

    public String parse(Path file) throws IOException {
        Source source = new Source(new URL("file:///" + file.toAbsolutePath()));
        List headLst = source.getAllElements("head");
        if (headLst == null || headLst.isEmpty()) {
            throw new IOException("no head");
        }
        List styles = ((Segment)headLst.get(0)).getAllElements("style");
        for (Object style : styles) {
            String styleStr = CharacterReference.decodeCollapseWhiteSpace((CharSequence)style.getContent());
            Pattern pattern = Pattern.compile("font-size: (\\d*)px", 9);
            Matcher m = pattern.matcher(styleStr);
            if (!m.find()) continue;
            this.fontSize = Integer.parseInt(m.group(1));
            break;
        }
        List scripts = ((Segment)headLst.get(0)).getAllElements("script");
        for (Element el : scripts) {
            String srcAttrib = el.getAttributeValue("src");
            if (srcAttrib == null) continue;
            if (srcAttrib.contains("MathJax.js")) {
                this.isMathEnabled = true;
                continue;
            }
            if (!srcAttrib.contains("highlight.js")) continue;
            this.isCodeHighlightEnabled = true;
        }
        List bodyLst = source.getAllElements("body");
        if (bodyLst == null || bodyLst.isEmpty()) {
            throw new IOException("no body");
        }
        String ret = NoteManager.readFile((File)file.toFile(), (long)((Segment)bodyLst.get(0)).getBegin(), (long)(((Segment)bodyLst.get(0)).getEnd() - 1));
        int start = ret.indexOf(62);
        int end = ret.lastIndexOf(60);
        ret = ret.substring(start + 1, end);
        return ret;
    }
}

