/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.ebook;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import myencyclopedia.common.gui.TemplateStage;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.model.ebook.TitleI18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleFieldStage
extends TemplateStage {
    private static final Logger logger = LoggerFactory.getLogger(TitleFieldStage.class);
    private TitleI18N t;
    private TextField inputTitle;
    private TextField inputSub;
    private TextField inputVolumn;
    private TextField inputEditionDesc;

    public TitleFieldStage(TitleI18N title) {
        this.setTitle(MydocMain.rb.getString("TitleFieldStage.dialog_title"));
        this.initModality(Modality.APPLICATION_MODAL);
        this.t = title;
        this.inputTitle = new TextField();
        if (title.getTitle() != null) {
            this.inputTitle.setText(title.getTitle());
        }
        this.inputSub = new TextField();
        if (title.getSubtitle() != null) {
            this.inputSub.setText(title.getSubtitle());
        }
        this.inputVolumn = new TextField();
        if (title.getVolumn() != null) {
            this.inputVolumn.setText(title.getVolumn());
        }
        this.inputEditionDesc = new TextField();
        if (title.getEditionDecription() != null) {
            this.inputEditionDesc.setText(title.getEditionDecription());
        }
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        gridPane.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
        ColumnConstraints column1 = new ColumnConstraints();
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        Label lblTitle = new Label(MydocMain.rb.getString("TitleFieldStage.title"));
        gridPane.add((Node)lblTitle, 0, 0);
        gridPane.add((Node)this.inputTitle, 1, 0);
        gridPane.add((Node)new Label(MydocMain.rb.getString("TitleFieldStage.subtitle")), 0, 1);
        gridPane.add((Node)this.inputSub, 1, 1);
        gridPane.add((Node)new Label(MydocMain.rb.getString("TitleFieldStage.volumn")), 0, 2);
        gridPane.add((Node)this.inputVolumn, 1, 2);
        gridPane.add((Node)new Label(MydocMain.rb.getString("TitleFieldStage.special_ed")), 0, 3);
        gridPane.add((Node)this.inputEditionDesc, 1, 3);
        this.bp.setCenter((Node)gridPane);
    }

    protected Object prepareResult() {
        this.t.setTitle(this.inputTitle.getText());
        this.t.setSubtitle(this.inputSub.getText());
        this.t.setVolumn(this.inputVolumn.getText());
        this.t.setEditionDecription(this.inputEditionDesc.getText());
        return this.t;
    }
}

