/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.ebook;

import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import myencyclopedia.common.gui.entity.view.AbstractRenderer;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.logic.mydoc.ConfigMydoc;
import myencyclopedia.model.ebook.EbookFileInfo;

public class FilesListRenderer
extends AbstractRenderer {
    protected ListView list = new ListView();
    final int ROW_HEIGHT = 24;

    public FilesListRenderer() {
        this.list.setPrefHeight(24.0);
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    EbookFileInfo fileInfo = (EbookFileInfo)FilesListRenderer.this.list.getSelectionModel().getSelectedItem();
                    MydocMain.launchEbookFile(fileInfo, ConfigMydoc.getInstance().getCopyDocPathEnabled());
                }
            }
        });
        this.list.getItems().addListener(new ListChangeListener(){

            public void onChanged(ListChangeListener.Change change) {
                if (FilesListRenderer.this.list.getItems().isEmpty()) {
                    FilesListRenderer.this.list.setPrefHeight(24.0);
                } else if (FilesListRenderer.this.list.getItems().size() < 4) {
                    FilesListRenderer.this.list.setPrefHeight((double)(FilesListRenderer.this.list.getItems().size() * 24));
                } else {
                    FilesListRenderer.this.list.setPrefHeight(96.0);
                }
            }
        });
    }

    public Control getRendererControl() {
        return this.list;
    }

    public void loadRendererObject(Object obj) {
        this.list.getItems().clear();
        if (obj == null) {
            return;
        }
        if (obj instanceof Object[]) {
            EbookFileInfo[] lst;
            for (EbookFileInfo element : lst = (EbookFileInfo[])obj) {
                this.list.getItems().add((Object)element);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return new FilesListRenderer();
    }
}

