/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.ebook;

import java.io.File;
import java.util.List;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.FxOptionPane;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.entity.EntityValidator;
import myencyclopedia.common.gui.entity.Spec;
import myencyclopedia.common.gui.entity.SpecElement;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.common.gui.progress.SimpleProgressStage;
import myencyclopedia.common.utils.HashUtil;
import myencyclopedia.common.utils.Tuple;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.gui.mydoc.ebook.AuthorEditorRenderer;
import myencyclopedia.gui.mydoc.ebook.EbookBulletin;
import myencyclopedia.gui.mydoc.ebook.EbookEntityValidator;
import myencyclopedia.gui.mydoc.ebook.EbookSpecBuilder;
import myencyclopedia.logic.ebook.EbookDAO;
import myencyclopedia.logic.mydoc.tag.TagManager;
import myencyclopedia.model.Entity;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.ebook.Author;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.ebook.EbookAuthor;
import myencyclopedia.model.ebook.EbookFileInfo;
import myencyclopedia.search.mydoc.FullTextClassBridge;
import myencyclopedia.search.mydoc.parser.IndexingReporter;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EbookNewStage
extends Stage
implements GUIListener {
    private Button btnSave;
    private Button btnCancel;
    private EntityView entityView;
    private Ebook ebook;
    private EntityValidator validator;
    private List<Ebook> existingEbooks;
    private EbookBulletin ebookBulletin;
    private static final Logger logger = LoggerFactory.getLogger(EbookNewStage.class);
    private Session s;
    private Spec specEbook;
    private boolean isSaved = false;
    private AuthorEditorRenderer authorComp;

    public EbookNewStage(Stage owner, Session s) {
        this.getIcons().add((Object)ImageFactory.IMG_STAGE_BOOK);
        this.s = s;
        this.entityView = new EntityView();
        this.entityView.setGUIListener((GUIListener)this);
        Tuple<Spec, AuthorEditorRenderer> ret = EbookSpecBuilder.buildEbookNewSpecs(this.entityView, s);
        this.specEbook = (Spec)ret.x;
        this.authorComp = (AuthorEditorRenderer)((Object)ret.y);
        this.validator = new EbookEntityValidator();
        this.entityView.setEntityValidator(this.validator);
        this.entityView.setGUIListener((GUIListener)this);
        this.ebookBulletin = new EbookBulletin(this);
        this.btnSave = new Button(MydocMain.rb.getString("SAVE"));
        this.btnSave.setOnAction(e -> {
            RelationCollection r = (RelationCollection)this.ebook.getRelation("file_info");
            if (r.getTarget() == null) {
                Alert alert = new Alert(Alert.AlertType.ERROR, MydocMain.rb.getString("EBOOK_AT_LEAST_ONE_FILE"), new ButtonType[0]);
                alert.showAndWait();
                return;
            }
            if (!this.entityView.validateEntity()) {
                return;
            }
            this.save();
        });
        this.btnCancel = new Button(MydocMain.rb.getString("CANCEL"));
        this.btnCancel.setOnAction(e -> this.hide());
        this.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                EbookNewStage.this.cleanUp();
            }
        });
        FlowPane controlFlowPane = new FlowPane();
        controlFlowPane.getChildren().add((Object)this.btnSave);
        controlFlowPane.getChildren().add((Object)this.btnCancel);
        BorderPane border = new BorderPane();
        ScrollPane sp = new ScrollPane((Node)this.entityView);
        sp.setFitToWidth(true);
        border.setCenter((Node)sp);
        border.setBottom((Node)controlFlowPane);
        Scene scene = new Scene((Parent)border, 600.0, 700.0);
        this.setScene(scene);
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public void setEbook(Ebook ebook, String title) {
        this.ebook = ebook;
        this.isSaved = false;
        this.entityView.setEntity((Entity)ebook);
        this.setTitle(MydocMain.rb.getString("EBOOK_TITLE_NEW_EBOOK") + title);
    }

    private void cleanUp() {
        this.s.close();
        MydocMain.getInstance().releaseEntity((Entity)this.ebook);
    }

    public Ebook getEbook() {
        return this.ebook;
    }

    private void save() {
        final SimpleProgressStage progressStage = new SimpleProgressStage((Stage)this, null);
        final IndexingReporter reporter = new IndexingReporter(){

            public void progress(final int current, final int total) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        progressStage.updateProgress(String.format(MydocMain.rb.getString("PROGRESS_PAGE"), current, total), (double)current / (double)total);
                    }
                });
            }
        };
        final Task task = new Task(){

            protected Boolean call() throws Exception {
                FullTextClassBridge.reporter = reporter;
                try {
                    List<Author> authors = EbookNewStage.this.authorComp.getSavedAuthors();
                    if (!authors.isEmpty()) {
                        RelationCollection authorR = (RelationCollection)EbookNewStage.this.ebook.getRelation("authors");
                        for (Author au : authors) {
                            EbookAuthor ebookAuthor = new EbookAuthor();
                            ebookAuthor.getRelation("author").setTarget((Object)au);
                            EbookNewStage.this.s.save((Object)ebookAuthor);
                            authorR.addTarget((Entity)ebookAuthor);
                        }
                    }
                    EbookDAO.newEbook((Session)EbookNewStage.this.s, (Ebook)EbookNewStage.this.ebook);
                    return true;
                }
                catch (Exception ex) {
                    logger.error("", (Throwable)ex);
                    Alert alert = new Alert(Alert.AlertType.ERROR, ex.toString(), new ButtonType[0]);
                    alert.setTitle(MydocMain.rb.getString("EBOOK_ERROR_ADDING"));
                    alert.showAndWait();
                    return false;
                }
            }
        };
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                EbookNewStage.this.isSaved = (Boolean)task.getValue();
                progressStage.hide();
                EbookNewStage.this.hide();
            }
        });
        new Thread((Runnable)task).start();
    }

    public Object dispatch(GUIEvent e) {
        if ("EntityView_committed".equals(e.getEventName())) {
            SpecElement specE = (SpecElement)e.getValue();
            if (this.specEbook.get("tags").equals((Object)specE) && this.ebook.getDiscipline() == null) {
                RelationCollection rc = (RelationCollection)this.ebook.getRelation("tags");
                Tag category = null;
                for (Tag t : (Tag[])rc.getTarget()) {
                    Tag parentTag;
                    while ((parentTag = t.getParentTag()) != null) {
                        if (parentTag.getExtID().equals(1)) {
                            category = t;
                            break;
                        }
                        t = parentTag;
                    }
                    if (category != null) break;
                }
                if (category != null) {
                    this.ebook.setDiscipline(TagManager.getInstance().getDiscipline(category));
                    this.entityView.refresh((Entity)this.ebook, this.specEbook.get("discipline"));
                }
            }
            return null;
        }
        if ("EntityView_add".equals(e.getEventName())) {
            FileChooser fileChooser = new FileChooser();
            File file = fileChooser.showOpenDialog((Window)this);
            if (file == null) {
                return null;
            }
            String md5 = null;
            try {
                md5 = HashUtil.computeMD5((File)file);
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
            if (md5 != null) {
                this.existingEbooks = EbookDAO.searchForMD5((Session)this.s, (String)md5);
                if (this.existingEbooks.size() > 0) {
                    this.ebookBulletin.setEbookList(this.existingEbooks);
                    FxOptionPane.Response r = FxOptionPane.showConfirmDialog((Stage)this, (String)MydocMain.rb.getString("EBOOK_SAME_MD5"), (String)MydocMain.rb.getString("EBOOK_SAME_MD5"), (Node)this.ebookBulletin);
                    if (r != FxOptionPane.Response.YES) {
                        return null;
                    }
                }
            }
            EbookFileInfo fileInfo = new EbookFileInfo();
            fileInfo.setFileName(file.getAbsolutePath());
            fileInfo.setMd5(md5);
            RelationCollection r = (RelationCollection)this.getEbook().getRelation("file_info");
            r.addTarget((Entity)fileInfo);
            return fileInfo;
        }
        return null;
    }
}

