/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.ebook;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.entity.ObjectWrapper;
import myencyclopedia.common.gui.entity.view.AbstractEditorRenderer;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.gui.mydoc.ebook.AuthorListStage;
import myencyclopedia.gui.mydoc.ebook.AuthorSelectionStage;
import myencyclopedia.model.ebook.Author;
import myencyclopedia.model.ebook.AuthorI18N;
import myencyclopedia.model.ebook.EbookAuthor;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorEditorRenderer
extends AbstractEditorRenderer
implements GUIListener {
    protected ListView<ObjectWrapper> list = new ListView();
    protected TextField input = new TextField();
    protected Button btn;
    final int ROW_HEIGHT = 24;
    protected BorderPane pane;
    private Session s;
    private static final Logger logger = LoggerFactory.getLogger(AuthorEditorRenderer.class);

    public AuthorEditorRenderer(Session s) {
        this.s = s;
        this.pane = new BorderPane();
        this.btn = new Button(MydocMain.rb.getString("EBOOK_AUTHOR_SELECT_EXISTING"));
        this.btn.setOnAction(e -> {
            AuthorSelectionStage stage = new AuthorSelectionStage(s);
            stage.showAndWait();
            Author author = (Author)stage.getResult();
            if (author != null) {
                ObjectWrapper wrapper = new ObjectWrapper((Object)author, author.toString());
                this.list.getItems().add((Object)wrapper);
            }
        });
        this.list.setPrefHeight(74.0);
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    Object obj = AuthorEditorRenderer.this.list.getSelectionModel().getSelectedItem();
                    AuthorEditorRenderer.this.list.getItems().remove(obj);
                }
            }
        });
        this.input.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                event.getCode();
                if (keyCode.equals((Object)KeyCode.ENTER) && !AuthorEditorRenderer.this.input.getText().trim().isEmpty()) {
                    AuthorEditorRenderer.this.search(AuthorEditorRenderer.this.input.getText());
                }
            }
        });
        this.input.focusedProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue.equals(false)) {
                    // empty if block
                }
            }
        });
        this.pane.setCenter(this.list);
        HBox hbox = new HBox();
        HBox.setHgrow((Node)this.input, (Priority)Priority.ALWAYS);
        hbox.getChildren().addAll((Object[])new Node[]{this.input, this.btn});
        this.pane.setTop((Node)hbox);
    }

    private void search(String name) {
        AuthorI18N i18n = new AuthorI18N();
        String[] strs = name.split(" ");
        if (strs.length == 1) {
            i18n.setFirstName(strs[0]);
        } else if (strs.length == 2) {
            i18n.setFirstName(strs[0]);
            i18n.setLastName(strs[1]);
        } else if (strs.length == 3) {
            i18n.setFirstName(strs[0]);
            i18n.setMiddleName(strs[1]);
            i18n.setLastName(strs[2]);
        } else {
            i18n.setFirstName(name);
        }
        List<Author> authors = null;
        try {
            authors = AuthorEditorRenderer.searchAuthor(i18n, this.s);
            if (authors != null && !authors.isEmpty()) {
                ObjectWrapper wrapper;
                AuthorListStage stage = new AuthorListStage(authors);
                stage.showAndWait();
                Author author = (Author)stage.getResult();
                if (author != null) {
                    wrapper = new ObjectWrapper((Object)author, author.toString());
                } else {
                    author = new Author(i18n);
                    AuthorEditorRenderer.saveAuthor(author, this.s);
                    wrapper = new ObjectWrapper((Object)author, "* " + author.toString());
                }
                this.list.getItems().add((Object)wrapper);
            } else {
                Author author = new Author(i18n);
                ObjectWrapper wrapper = new ObjectWrapper((Object)author, "* " + author.toString());
                this.list.getItems().add((Object)wrapper);
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    public List<Author> getSavedAuthors() {
        ArrayList<Author> authors = new ArrayList<Author>();
        for (ObjectWrapper wrapper : this.list.getItems()) {
            Author author = (Author)wrapper.get();
            if (wrapper.toString().startsWith("*")) {
                this.s.save((Object)author);
            }
            authors.add(author);
        }
        return authors;
    }

    public static void saveAuthor(Author author, Session s) {
    }

    public static List<Author> searchAuthor(AuthorI18N authorI18n, Session s) {
        Criteria c = s.createCriteria(Author.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).createCriteria("authorI18nList").add(Restrictions.ilike((String)"firstName", (Object)(authorI18n.getFirstName() + "%")));
        if (authorI18n.getLastName() != null) {
            c.add(Restrictions.ilike((String)"lastName", (Object)(authorI18n.getLastName() + "%")));
        }
        List authors = c.list();
        return authors;
    }

    public Region getComponent() {
        return this.pane;
    }

    public void loadObject(Object obj) {
        this.list.getItems().clear();
        if (obj == null) {
            return;
        }
        if (obj instanceof Object[]) {
            EbookAuthor[] lst;
            for (EbookAuthor element : lst = (EbookAuthor[])obj) {
                String str = this.fromObjToString(element);
                ObjectWrapper wrapper = new ObjectWrapper((Object)element, str);
                this.list.getItems().add((Object)wrapper);
            }
        }
    }

    public boolean forceCommit() {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object dispatch(GUIEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

