/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.ebook;

import java.util.ArrayList;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.model.common.StringConverter;
import myencyclopedia.model.ebook.Author;
import myencyclopedia.model.ebook.AuthorI18N;
import myencyclopedia.model.ebook.EbookAuthor;

public class AuthorConverter
implements StringConverter<EbookAuthor> {
    public String toString(EbookAuthor ebookAuthor) {
        if (ebookAuthor == null) {
            return null;
        }
        Author author = (Author)ebookAuthor.getRelation("author").getTarget();
        if (author == null) {
            return null;
        }
        AuthorI18N i18n = (AuthorI18N)author.getAuthorI18nList().get(0);
        return i18n.toString();
    }

    public EbookAuthor fromString(String str) {
        EbookAuthor ebookAuthor = new EbookAuthor();
        Author author = new Author();
        AuthorI18N i18n = new AuthorI18N();
        ArrayList<AuthorI18N> lst = new ArrayList<AuthorI18N>();
        lst.add(i18n);
        author.setAuthorI18nList(lst);
        ebookAuthor.getRelation("author").setTarget((Object)author);
        String[] strs = str.split(" ");
        if (strs.length == 1) {
            i18n.setFirstName(strs[0]);
        } else if (strs.length == 2) {
            i18n.setFirstName(strs[0]);
            i18n.setLastName(strs[1]);
        } else if (strs.length == 3) {
            i18n.setFirstName(strs[0]);
            i18n.setMiddleName(strs[1]);
            i18n.setLastName(strs[2]);
        } else {
            i18n.setFirstName(MydocMain.rb.getString("EBOOK_AUTHOR_PARSING_ERROR"));
        }
        return ebookAuthor;
    }
}

