/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.doc;

import java.io.Serializable;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.gui.mydoc.doc.DocSpecBuilder;
import myencyclopedia.model.Entity;
import myencyclopedia.model.mydoc.Doc;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocPropertyEditingStage
extends Stage {
    private EntityView entityView;
    private static final Logger logger = LoggerFactory.getLogger(DocPropertyEditingStage.class);
    private Doc doc;
    private SessionFactory sf;
    private MenuItem mFav;
    private MenuItem mSave;
    private MenuItem mCancel;
    private MenuItem mOpenOrig;
    private MenuItem mOpen;
    private MenuItem mDelete;
    private MenuItem mContaining;
    private boolean isSaved;
    protected BorderPane bp;
    protected Scene scene;

    public DocPropertyEditingStage(SessionFactory sf) {
        this.sf = sf;
        this.getIcons().add((Object)ImageFactory.IMG_STAGE_DOC);
        this.entityView = new EntityView();
        this.entityView.enableDisplayEntityToString(true);
        this.entityView.setCollapsible(false);
        DocSpecBuilder.buildDocNewSpec(this.entityView);
        ScrollPane sp = new ScrollPane();
        sp.setFitToWidth(true);
        sp.setContent((Node)this.entityView);
        MenuBar bar = new MenuBar();
        Menu menuFile = new Menu(MydocMain.rb.getString("MENU_ACTION"));
        menuFile.setMnemonicParsing(true);
        this.mOpen = new MenuItem(MydocMain.rb.getString("MENU_OPEN"));
        this.mOpen.setMnemonicParsing(true);
        this.mOpen.setOnAction(t -> MydocMain.actionOpen((Entity)this.doc));
        this.mOpenOrig = new MenuItem(MydocMain.rb.getString("MENU_OPEN_ORIG"));
        this.mOpenOrig.setMnemonicParsing(true);
        this.mOpenOrig.setOnAction(t -> MydocMain.actionOpenOrig((Entity)this.doc));
        this.mDelete = new MenuItem(MydocMain.rb.getString("MENU_DELETE"));
        this.mDelete.setMnemonicParsing(true);
        this.mDelete.setOnAction(t -> {
            MydocMain.actionDelete((Entity)this.doc);
            this.hide();
        });
        this.mFav = new MenuItem(MydocMain.rb.getString("MENU_FAVOURITE"));
        this.mFav.setMnemonicParsing(true);
        this.mFav.setOnAction(t -> MydocMain.actionFavourite((Entity)this.doc));
        this.mContaining = new MenuItem(MydocMain.rb.getString("MENU_CONTAINING_FOLDER"));
        this.mContaining.setMnemonicParsing(true);
        this.mContaining.setOnAction(t -> MydocMain.actionGotoFolder((Entity)this.doc));
        this.mSave = new MenuItem(MydocMain.rb.getString("MENU_SAVE"));
        this.mSave.setMnemonicParsing(true);
        this.mSave.setOnAction(t -> this.save());
        this.mCancel = new MenuItem(MydocMain.rb.getString("MENU_QUIT"));
        this.mCancel.setMnemonicParsing(true);
        this.mCancel.setOnAction(t -> this.hide());
        menuFile.getItems().addAll((Object[])new MenuItem[]{this.mOpen, this.mOpenOrig, this.mContaining, this.mFav, this.mDelete, new SeparatorMenuItem(), this.mSave, this.mCancel});
        bar.getMenus().addAll((Object[])new Menu[]{menuFile});
        this.bp = new BorderPane();
        this.bp.setCenter((Node)sp);
        this.bp.setTop((Node)bar);
        this.scene = new Scene((Parent)this.bp);
        this.setScene(this.scene);
        this.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                MydocMain.getInstance().releaseEntity((Entity)DocPropertyEditingStage.this.doc);
                if (DocPropertyEditingStage.this.isSaved) {
                    MydocMain.getInstance().updateMainList((Entity)DocPropertyEditingStage.this.doc, MydocMain.ListOperationMode.Modify);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntity(Long id) {
        this.isSaved = false;
        try (Session s = this.sf.openSession();){
            this.doc = (Doc)s.get(Doc.class, (Serializable)id);
            if (this.doc.isFavourite()) {
                this.mFav.setText(MydocMain.rb.getString("MENU_UNMAKR_FAV"));
            } else {
                this.mFav.setText(MydocMain.rb.getString("MENU_MAKR_FAV"));
            }
            this.setTitle(this.doc.toString());
            this.entityView.setEntity((Entity)this.doc);
        }
    }

    protected void save() {
        if (!this.entityView.validateEntity()) {
            return;
        }
        Session s = this.sf.openSession();
        s.beginTransaction();
        try {
            s.update((Object)this.doc);
            s.getTransaction().commit();
            this.isSaved = true;
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        finally {
            s.close();
        }
        this.hide();
    }
}

