/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.code;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.entity.EntityValidator;
import myencyclopedia.common.gui.entity.Spec;
import myencyclopedia.common.gui.entity.view.AbstractEditorRenderer;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.gui.mydoc.code.CodeEditor;
import myencyclopedia.gui.mydoc.code.CodeEntityValidator;
import myencyclopedia.gui.mydoc.code.CodeSpecBuilder;
import myencyclopedia.gui.mydoc.code.SnippetEditorRenderer;
import myencyclopedia.logic.mydoc.CodeDAO;
import myencyclopedia.logic.mydoc.ConfigMydoc;
import myencyclopedia.logic.mydoc.tag.TagManager;
import myencyclopedia.model.Entity;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.mydoc.Code;
import myencyclopedia.model.mydoc.Snippet;
import org.apache.commons.io.FileUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeStage
extends Stage
implements GUIListener {
    private EntityView codeEntityView;
    private EntityView snippetEntityView;
    private Code code;
    private Button btnSave;
    private boolean isSaved;
    private boolean isNewCode;
    private BorderPane border;
    private SnippetEditorRenderer snippetEditorRenderer;
    private CodeEditor codeEditor;
    private Map<Snippet, String> mapSnippetToCode;
    private SessionFactory sf;
    private SplitPane splitPane;
    private VBox leftPane;
    private Spec specCode;
    private Spec specSnippet;
    private static final Logger logger = LoggerFactory.getLogger(CodeStage.class);
    private ToggleGroup groupSnippet;
    private MenuItem mFav;
    private MenuItem mSave;
    private MenuItem mCancel;
    private CheckMenuItem cmiShowProp;
    private MenuItem mDelete;
    private MenuItem mContaining;
    private Menu menuSnippet;
    private RadioMenuItem radioKeymapDefault;
    private RadioMenuItem radioKeymapVim;

    public CodeStage(SessionFactory sf) {
        this.sf = sf;
        this.getIcons().add((Object)ImageFactory.IMG_STAGE_CODE);
        this.codeEntityView = new EntityView();
        this.specCode = CodeSpecBuilder.buildCodeNewSpec(this.codeEntityView);
        this.snippetEditorRenderer = new SnippetEditorRenderer(this);
        this.codeEntityView.setEditorRenderer(this.specCode.get("snippet"), (AbstractEditorRenderer)this.snippetEditorRenderer);
        this.codeEntityView.setCollapsible(false);
        this.codeEntityView.setGUIListener((GUIListener)this);
        this.codeEntityView.setEntityValidator((EntityValidator)new CodeEntityValidator());
        this.snippetEntityView = new EntityView();
        this.specSnippet = CodeSpecBuilder.buildSnippetSpec(this.snippetEntityView);
        this.snippetEntityView.setGUIListener((GUIListener)this);
        this.snippetEntityView.setCollapsible(false);
        MenuBar bar = new MenuBar();
        Menu menuAction = new Menu(MydocMain.rb.getString("MENU_ACTION"));
        menuAction.setMnemonicParsing(true);
        this.menuSnippet = new Menu(MydocMain.rb.getString("CODE_STAGE_SNIPPETS"));
        this.menuSnippet.setMnemonicParsing(true);
        Menu menuConfig = new Menu(MydocMain.rb.getString("CODE_STAGE_CONFIG"));
        menuConfig.setMnemonicParsing(true);
        this.mDelete = new MenuItem(MydocMain.rb.getString("MENU_DELETE"));
        this.mDelete.setMnemonicParsing(true);
        this.mDelete.setOnAction(t -> {
            MydocMain.actionDelete((Entity)this.code);
            this.hide();
        });
        this.mFav = new MenuItem(MydocMain.rb.getString("MENU_FAVOURITE"));
        this.mFav.setMnemonicParsing(true);
        this.mFav.setOnAction(t -> MydocMain.actionFavourite((Entity)this.code));
        this.mContaining = new MenuItem(MydocMain.rb.getString("MENU_CONTAINING_FOLDER"));
        this.mContaining.setMnemonicParsing(true);
        this.mContaining.setOnAction(t -> MydocMain.actionGotoFolder((Entity)this.code));
        this.mSave = new MenuItem(MydocMain.rb.getString("MENU_SAVE_QUIT"));
        this.mSave.setMnemonicParsing(true);
        this.mSave.setOnAction(t -> {
            try {
                this.save();
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
            this.hide();
        });
        this.mCancel = new MenuItem(MydocMain.rb.getString("MENU_QUIT_NO_SAVE"));
        this.mCancel.setMnemonicParsing(true);
        this.mCancel.setOnAction(t -> this.hide());
        menuAction.getItems().addAll((Object[])new MenuItem[]{this.mFav, this.mDelete, new SeparatorMenuItem(), this.mSave, this.mCancel});
        ToggleGroup groupKeymap = new ToggleGroup();
        this.radioKeymapDefault = new RadioMenuItem(MydocMain.rb.getString("CODE_STAGE_DEFAULT_KEYMAP"));
        this.radioKeymapDefault.setSelected(true);
        this.radioKeymapDefault.setOnAction(e -> this.codeEditor.setKeyMap("default"));
        this.radioKeymapDefault.setToggleGroup(groupKeymap);
        this.radioKeymapVim = new RadioMenuItem(MydocMain.rb.getString("CODE_STAGE_VIM_KEYMAP"));
        this.radioKeymapVim.setOnAction(e -> this.codeEditor.setKeyMap("vim"));
        this.radioKeymapVim.setToggleGroup(groupKeymap);
        this.cmiShowProp = new CheckMenuItem(MydocMain.rb.getString("CODE_STAGE_SHOW_PROPERTY"));
        this.cmiShowProp.setMnemonicParsing(true);
        this.cmiShowProp.setSelected(true);
        this.cmiShowProp.setOnAction(e -> this.switchToMode(!this.getIsFullMode()));
        menuConfig.getItems().addAll((Object[])new MenuItem[]{this.cmiShowProp, new SeparatorMenuItem(), this.radioKeymapDefault, this.radioKeymapVim});
        this.groupSnippet = new ToggleGroup();
        bar.getMenus().addAll((Object[])new Menu[]{menuAction, this.menuSnippet, menuConfig});
        this.btnSave = new Button(MydocMain.rb.getString("SAVE"));
        this.btnSave.setOnAction(e -> {
            try {
                this.save();
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
        });
        this.codeEditor = new CodeEditor();
        this.leftPane = new VBox();
        this.leftPane.getChildren().addAll((Object[])new Node[]{this.codeEntityView, this.snippetEntityView});
        this.border = new BorderPane();
        this.splitPane = new SplitPane();
        this.splitPane.setOrientation(Orientation.HORIZONTAL);
        this.splitPane.getItems().addAll((Object[])new Node[]{this.leftPane, this.codeEditor});
        SplitPane.setResizableWithParent((Node)this.leftPane, (Boolean)Boolean.FALSE);
        this.border.setTop((Node)bar);
        this.border.setCenter((Node)this.splitPane);
        this.border.setBottom((Node)this.btnSave);
        Scene scene = new Scene((Parent)this.border);
        this.setScene(scene);
        this.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (CodeStage.this.isNewCode && CodeStage.this.isSaved) {
                    MydocMain.getInstance().updateMainList((Entity)CodeStage.this.code, MydocMain.ListOperationMode.Add);
                } else if (!CodeStage.this.isNewCode) {
                    MydocMain.getInstance().releaseEntity((Entity)CodeStage.this.code);
                    MydocMain.getInstance().updateMainList((Entity)CodeStage.this.code, MydocMain.ListOperationMode.Modify);
                }
            }
        });
    }

    public boolean getIsFullMode() {
        return !this.border.getChildren().contains((Object)this.splitPane);
    }

    public void switchToMode(boolean isFullMode) {
        if (this.getIsFullMode() == isFullMode) {
            return;
        }
        if (isFullMode) {
            this.border.getChildren().remove((Object)this.splitPane);
            this.border.setCenter((Node)this.codeEditor);
        } else {
            this.border.getChildren().remove((Object)this.codeEditor);
            this.splitPane.getItems().clear();
            this.splitPane.getItems().addAll((Object[])new Node[]{this.leftPane, this.codeEditor});
            this.border.setCenter((Node)this.splitPane);
        }
        this.cmiShowProp.setSelected(!isFullMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCode(Code c) {
        this.groupSnippet.getToggles().clear();
        this.mapSnippetToCode = new HashMap<Snippet, String>();
        Session s = null;
        if (c.getId() != null) {
            s = this.sf.openSession();
            this.code = (Code)s.get(Code.class, (Serializable)c.getId());
        } else {
            this.code = c;
        }
        if (this.code.getId() != null) {
            this.isNewCode = false;
            try {
                RelationCollection r = (RelationCollection)this.code.getRelation("snippet");
                Path basePath = Paths.get(ConfigMydoc.getInstance().getAsPath("/myencyclopedia/mydoc/code/path").toString(), (String)this.code.getPropertyValue("filepath"));
                for (Entity en : r.getTarget()) {
                    Snippet snippet = (Snippet)en;
                    this.createSnippetRadio(snippet);
                    String relativePath = (String)snippet.getPropertyValue("filepath");
                    Path fullPath = Paths.get(basePath.toString(), relativePath);
                    String strCode = this.loadSnippet(fullPath).toString();
                    this.mapSnippetToCode.put(snippet, strCode);
                }
                this.codeEntityView.setEntity((Entity)this.code);
            }
            finally {
                s.close();
            }
            ((Toggle)this.groupSnippet.getToggles().get(0)).setSelected(true);
            this.setTitle(this.code.getTitle());
        } else {
            this.isNewCode = true;
            ((RelationCollection)this.code.getRelation("tags")).addTarget((Entity)TagManager.TAG_JAVA);
            RelationCollection r = (RelationCollection)this.code.getRelation("snippet");
            for (Entity en : r.getTarget()) {
                Snippet snippet = (Snippet)en;
                snippet.getRelation("tags").setTarget((Object)TagManager.TAG_JAVA);
                this.createSnippetRadio(snippet);
                String strCode = "";
                this.mapSnippetToCode.put(snippet, strCode);
            }
            this.codeEntityView.setEntity((Entity)this.code);
            ((Toggle)this.groupSnippet.getToggles().get(0)).setSelected(true);
            this.setTitle(MydocMain.rb.getString("CODE_STAGE_TITLE"));
        }
        this.isSaved = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        Session s;
        if (!this.codeEntityView.validateEntity()) {
            return;
        }
        String str = this.codeEditor.getCodeAndSnapshot();
        this.mapSnippetToCode.put(this.getSelectedSnippet(), str);
        Path basePath = null;
        basePath = this.isNewCode ? CodeDAO.initCode((Code)this.code) : Paths.get(MydocMain.conf.getNodeValue("/myencyclopedia/mydoc/code/path"), this.code.getFilepath());
        RelationCollection r = (RelationCollection)this.code.getRelation("snippet");
        for (Entity en : r.getTarget()) {
            Snippet snippet = (Snippet)en;
            String relativePath = (String)snippet.getPropertyValue("filepath");
            Path fullPath = Paths.get(basePath.toString(), relativePath);
            Path parentPath = fullPath.getParent();
            if (!Files.exists(parentPath, new LinkOption[0])) {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            String content = this.mapSnippetToCode.get(snippet);
            ArrayList<String> lst = new ArrayList<String>();
            lst.add(content);
            Files.write(fullPath, lst, new OpenOption[0]);
        }
        if (this.isNewCode) {
            s = this.sf.openSession();
            s.beginTransaction();
            CodeDAO.figureOutLang((Code)this.code, (Session)s);
            try {
                r = (RelationCollection)this.code.getRelation("snippet");
                for (Entity en : r.getTarget()) {
                    s.save((Object)en);
                }
                s.save((Object)this.code);
                s.getTransaction().commit();
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
                FileUtils.deleteDirectory((File)basePath.toFile());
            }
            finally {
                s.close();
            }
        } else {
            s = this.sf.openSession();
            s.beginTransaction();
            CodeDAO.figureOutLang((Code)this.code, (Session)s);
            try {
                r = (RelationCollection)this.code.getRelation("snippet");
                for (Entity en : r.getTarget()) {
                    s.saveOrUpdate((Object)en);
                }
                s.update((Object)this.code);
                s.getTransaction().commit();
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
            finally {
                s.close();
            }
        }
        this.isSaved = true;
        this.hide();
    }

    public boolean getSaved() {
        return this.isSaved;
    }

    public Object dispatch(GUIEvent e) {
        if (e.getSource().equals(this.codeEntityView)) {
            if (e.getEventName().equals("EntityView_add")) {
                Snippet newSnippet = new Snippet();
                RelationCollection r = (RelationCollection)this.code.getRelation("snippet");
                r.addTarget((Entity)newSnippet);
                return newSnippet;
            }
        } else if (e.getSource().equals((Object)this.snippetEditorRenderer)) {
            Snippet snippet = null;
            if (null != e.getEventName()) {
                switch (e.getEventName()) {
                    case "snippet_added": {
                        snippet = (Snippet)e.getValue();
                        this.createSnippetRadio(snippet);
                        this.mapSnippetToCode.put(snippet, "");
                        break;
                    }
                    case "snippet_removed": {
                        snippet = (Snippet)e.getValue();
                        this.removeSnippetMenu(snippet);
                        this.mapSnippetToCode.remove(snippet);
                        break;
                    }
                    case "snippet_selected": {
                        snippet = (Snippet)e.getValue();
                        if (snippet == null) break;
                        this.snippetEntityView.setEntity((Entity)snippet);
                    }
                }
            }
        } else if (e.getSource().equals(this.snippetEntityView) && "EntityView_committed".equals(e.getEventName())) {
            if (this.specSnippet.get("filepath").equals(e.getValue())) {
                this.codeEntityView.refresh((Entity)this.code, this.specCode.get("snippet"));
                this.refreshSnippetMenu();
            } else if (this.specSnippet.get("tags").equals(e.getValue())) {
                if (this.getSelectedSnippet() == this.snippetEditorRenderer.getSelected()) {
                    this.codeEditor.setLanguage(this.getSelectedSnippet().getTag().getName());
                }
                CodeDAO.updateCodeTags((Code)this.code);
                this.codeEntityView.refresh((Entity)this.code, this.specCode.get("tags"));
            }
        }
        return null;
    }

    public StringBuffer loadSnippet(Path file) {
        List<String> lines = null;
        try {
            lines = Files.readAllLines(file);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
        StringBuffer sb = new StringBuffer();
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        return sb;
    }

    private RadioMenuItem createSnippetRadio(final Snippet snippet) {
        final RadioMenuItem radio = new RadioMenuItem(snippet.getPath());
        radio.setUserData((Object)snippet);
        radio.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean old_val, Boolean new_val) {
                if (Boolean.TRUE.equals(new_val)) {
                    Snippet snippet2 = (Snippet)radio.getUserData();
                    String str = (String)CodeStage.this.mapSnippetToCode.get(snippet2);
                    CodeStage.this.codeEditor.setCode(str, snippet2.getTag() == null ? null : snippet2.getTag().getName());
                }
                if (Boolean.FALSE.equals(new_val)) {
                    String str = CodeStage.this.codeEditor.getCodeAndSnapshot();
                    CodeStage.this.mapSnippetToCode.put(snippet, str);
                }
            }
        });
        radio.setToggleGroup(this.groupSnippet);
        this.menuSnippet.getItems().add((Object)radio);
        return radio;
    }

    private void removeSnippetMenu(Snippet snippet) {
        for (Toggle t : this.groupSnippet.getToggles()) {
            if (t.getUserData() != snippet) continue;
            this.groupSnippet.getToggles().remove((Object)t);
            this.menuSnippet.getItems().remove((Object)t);
        }
    }

    private void refreshSnippetMenu() {
        for (Toggle t : this.groupSnippet.getToggles()) {
            Snippet snippet = (Snippet)t.getUserData();
            ((RadioMenuItem)t).setText(snippet.getPath());
        }
    }

    private Snippet getSelectedSnippet() {
        return (Snippet)this.groupSnippet.getSelectedToggle().getUserData();
    }
}

