/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.entity.view.AbstractStageEditor;
import myencyclopedia.common.gui.tree.Tree;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.hibernate.common.ParentChildrenManager;
import myencyclopedia.logic.mydoc.tag.TagManager;
import myencyclopedia.model.common.StringConverter;
import myencyclopedia.model.common.entity.Tag;

public class TagStage
extends AbstractStageEditor
implements GUIListener {
    private Tree<Tag> treeAllTags;
    private Tree<Tag> treeSpecificTags;
    private Tree<Tag> activeTree;
    private ListView<Tag> listView;
    private ParentChildrenManager mgr;
    private Button btnAdd;
    private Button btnRemove;
    private FlowPane addRemovePane;
    private Button btnSave;
    private Button btnCancel;
    private VBox box;
    private String name;
    private Button btnSwitch;

    public TagStage() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.getIcons().add((Object)ImageFactory.IMG_STAGE_TAG);
        this.treeAllTags = new Tree((ParentChildrenManager)TagManager.getInstance(), (GUIListener)this);
        VBox.setVgrow(this.treeAllTags, (Priority)Priority.ALWAYS);
        this.listView = new ListView();
        this.listView.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.listView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    Object obj = TagStage.this.listView.getSelectionModel().getSelectedItem();
                    TagStage.this.listView.getItems().remove(obj);
                }
            }
        });
        this.btnAdd = new Button(MydocMain.rb.getString("ADD"));
        this.btnAdd.setOnAction(e -> {
            Tag item = (Tag)this.activeTree.getSelectedItem();
            if (item != null && !this.listView.getItems().contains((Object)item)) {
                this.listView.getItems().add((Object)item);
            }
        });
        this.btnRemove = new Button(MydocMain.rb.getString("REMOVE"));
        this.btnRemove.setOnAction(e -> {
            Tag item = (Tag)this.listView.getSelectionModel().getSelectedItem();
            if (item != null) {
                this.listView.getItems().remove((Object)item);
            }
        });
        this.addRemovePane = new FlowPane();
        this.addRemovePane.getChildren().add((Object)this.btnAdd);
        this.addRemovePane.getChildren().add((Object)this.btnRemove);
        this.btnSave = new Button(MydocMain.rb.getString("SAVE"));
        this.btnSave.setOnAction(e -> {
            try {
                this.tryClose(this.listView.getItems());
            }
            catch (StringConverter.ConversionException conversionException) {
                // empty catch block
            }
        });
        this.btnCancel = new Button(MydocMain.rb.getString("CANCEL"));
        this.btnCancel.setOnAction(e -> this.close());
        FlowPane controlFlowPane = new FlowPane();
        controlFlowPane.getChildren().add((Object)this.btnSave);
        controlFlowPane.getChildren().add((Object)this.btnCancel);
        this.box = new VBox();
        this.box.getChildren().addAll((Object[])new Node[]{this.treeAllTags, this.addRemovePane, this.listView, controlFlowPane});
        this.activeTree = this.treeAllTags;
        Scene scene = new Scene((Parent)this.box, 550.0, 400.0);
        this.setScene(scene);
        this.setTitle(MydocMain.rb.getString("SELECT_TAGS"));
    }

    public TagStage(ParentChildrenManager mgr, String name) {
        this();
        this.name = name;
        this.treeSpecificTags = new Tree(mgr, (GUIListener)this);
        VBox.setVgrow(this.treeSpecificTags, (Priority)Priority.ALWAYS);
        this.box.getChildren().remove(this.treeAllTags);
        this.btnSwitch = new Button(MydocMain.rb.getString("SWITCH_TO_ALL_TAGS"));
        this.btnSwitch.setOnAction(e -> this.switchView());
        this.box.getChildren().add(0, this.treeSpecificTags);
        this.activeTree = this.treeSpecificTags;
        this.addRemovePane.getChildren().add((Object)this.btnSwitch);
    }

    private void switchView() {
        this.box.getChildren().remove(this.activeTree);
        if (this.activeTree == this.treeSpecificTags) {
            this.activeTree = this.treeAllTags;
            this.btnSwitch.setText(MydocMain.rb.getString("SWITCH_TO") + this.name);
        } else {
            this.activeTree = this.treeSpecificTags;
            this.btnSwitch.setText(MydocMain.rb.getString("SWITCH_TO_ALL_TAGS"));
        }
        this.box.getChildren().add(0, this.activeTree);
    }

    public Object dispatch(GUIEvent e) {
        return null;
    }

    public void loadEditorObject(Object obj) {
        Object[] tags = (Tag[])obj;
        this.listView.getItems().clear();
        if (tags != null) {
            this.listView.getItems().addAll(tags);
        }
    }
}

