/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import myencyclopedia.common.gui.FxOptionPane;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.entity.EntityList;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.model.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameMD5EntityDialog
extends FxOptionPane.Dialog
implements GUIListener {
    private static SameMD5EntityDialog instance;
    private EntityList entityList;
    private FxOptionPane.Response response = FxOptionPane.Response.CANCEL;
    private static final Logger logger;

    public static SameMD5EntityDialog getInstance() {
        if (instance == null) {
            instance = new SameMD5EntityDialog();
        }
        return instance;
    }

    private SameMD5EntityDialog() {
        super(MydocMain.primaryStage, "res/Confirm.png");
        this.setResizable(true);
        this.setTitle(MydocMain.rb.getString("WARNING"));
        this.entityList = new EntityList((GUIListener)this);
        this.entityList.setEnableFilter(false);
        VBox vb = new VBox();
        vb.setSpacing(10.0);
        Button yesButton = new Button(MydocMain.rb.getString("YES"));
        yesButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SameMD5EntityDialog.this.close();
                SameMD5EntityDialog.this.response = FxOptionPane.Response.YES;
            }
        });
        Button noButton = new Button(MydocMain.rb.getString("NO"));
        noButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SameMD5EntityDialog.this.close();
                SameMD5EntityDialog.this.response = FxOptionPane.Response.NO;
            }
        });
        HBox buttons = new HBox();
        buttons.setAlignment(Pos.CENTER);
        buttons.setSpacing(10.0);
        buttons.getChildren().addAll((Object[])new Node[]{yesButton, noButton});
        HBox msg = new HBox();
        msg.setSpacing(5.0);
        msg.getChildren().addAll((Object[])new Node[]{new Label(MydocMain.rb.getString("IDENTICAL_CONTINUE"))});
        vb.getChildren().add((Object)msg);
        vb.getChildren().add((Object)this.entityList);
        vb.getChildren().add((Object)buttons);
        Scene scene = new Scene((Parent)vb);
        this.setScene(scene);
    }

    public void setAndShow(List<? extends Entity> list) {
        this.response = FxOptionPane.Response.CANCEL;
        this.entityList.itemsReset();
        this.entityList.itemsAdd(list);
        this.showDialog();
    }

    public FxOptionPane.Response getResponse() {
        return this.response;
    }

    public Object dispatch(GUIEvent e) {
        if ("EntityList_default".equals(e.getEventName())) {
            MydocMain.getInstance().launchPropertyStage((Entity)e.getValue());
        }
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(SameMD5EntityDialog.class);
    }
}

