/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import java.util.List;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PopupControl;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.gui.mydoc.EntityListCell;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.hibernate.AsyncListReceiver;
import myencyclopedia.logic.query.EntityQueryUtil;
import myencyclopedia.logic.query.MECriteria;
import myencyclopedia.model.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInput
implements AsyncListReceiver {
    private TextField input;
    private ProgressIndicator pi;
    private HBox inputBox;
    private EntityListPopupControl entityListPopup;
    private GUIListener guiListener;
    private Stage owner;
    public static final String EVENT_HIDE = "QueryInput_hide";
    public static final String EVENT_LIST_DOUBLECLICKED = "QueryInput_double";
    public static final String EVENT_DEFAULT_ACTION_CONTROL = "QueryInput_default_control";
    private static final Logger logger = LoggerFactory.getLogger(QueryInput.class);

    public QueryInput(GUIListener listener) {
        this.guiListener = listener;
        this.entityListPopup = new EntityListPopupControl(EntityListCell.class);
        this.input = new TextField("");
        this.input.setPrefColumnCount(30);
        this.pi = new ProgressIndicator(-1.0);
        this.pi.setMaxSize(20.0, 20.0);
        this.pi.setVisible(false);
        this.input.textProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (QueryInput.this.input.getText().length() > 1) {
                    QueryInput.this.pi.setVisible(true);
                    ((QueryInput)QueryInput.this).entityListPopup.list.setVisible(true);
                    MECriteria c = new MECriteria((AsyncListReceiver)QueryInput.this, (Class[])MydocMain.getAllTargets());
                    boolean parseResult = EntityQueryUtil.parseInput((String)((String)newValue), (MECriteria)c);
                    if (parseResult) {
                        MydocMain.submitSearch(QueryInput.this, c);
                    } else {
                        QueryInput.this.entityListPopup.beginLoading();
                        ((QueryInput)QueryInput.this).entityListPopup.list.setVisible(false);
                    }
                } else {
                    ((QueryInput)QueryInput.this).entityListPopup.list.setVisible(false);
                }
            }
        });
        this.input.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.ESCAPE) {
                    if (QueryInput.this.input.getText().trim().isEmpty()) {
                        QueryInput.this.guiListener.dispatch(new GUIEvent((Object)QueryInput.this, QueryInput.EVENT_HIDE, null));
                    } else {
                        QueryInput.this.input.setText("");
                    }
                } else if (keyEvent.getCode() == KeyCode.DOWN) {
                    if (!(((QueryInput)QueryInput.this).entityListPopup.list.getItems().isEmpty() || QueryInput.this.entityListPopup.isShowing() || ((QueryInput)QueryInput.this).entityListPopup.list.getItems().isEmpty())) {
                        QueryInput.this.positionAndShowPopup();
                        ((QueryInput)QueryInput.this).entityListPopup.list.getSelectionModel().select(0);
                        ((QueryInput)QueryInput.this).entityListPopup.list.requestFocus();
                    }
                } else if (keyEvent.getCode() == KeyCode.ENTER && QueryInput.this.entityListPopup.isShowing() && !((QueryInput)QueryInput.this).entityListPopup.list.getItems().isEmpty()) {
                    ((QueryInput)QueryInput.this).entityListPopup.list.getSelectionModel().select(0);
                    QueryInput.this.entityListPopup.launchSelectedItem(keyEvent.isControlDown());
                }
            }
        });
        this.inputBox = new HBox();
        this.inputBox.getChildren().addAll((Object[])new Node[]{this.input, this.pi});
        HBox.setHgrow((Node)this.input, (Priority)Priority.ALWAYS);
    }

    public TextField getInputTextField() {
        return this.input;
    }

    public HBox getInputPane() {
        return this.inputBox;
    }

    public void hideList() {
        this.entityListPopup.list.setVisible(false);
    }

    public void beginLoading() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                QueryInput.this.pi.setVisible(true);
                QueryInput.this.entityListPopup.beginLoading();
            }
        });
    }

    public void endLoading() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                QueryInput.this.pi.setVisible(false);
            }
        });
    }

    public void appendList(final List<Entity> newList) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                QueryInput.this.entityListPopup.appendList(newList);
                QueryInput.this.positionAndShowPopup();
            }
        });
    }

    public void setOwnerStage(Stage owner) {
        this.owner = owner;
    }

    private void positionAndShowPopup() {
        if (this.entityListPopup.list.getItems().isEmpty()) {
            this.entityListPopup.hide();
            return;
        }
        Parent parent = this.input.getParent();
        Bounds childBounds = this.input.getBoundsInParent();
        Bounds parentBounds = parent.localToScene(parent.getBoundsInLocal());
        double layoutX = childBounds.getMinX() + parentBounds.getMinX() + parent.getScene().getX() + parent.getScene().getWindow().getX();
        double layoutY = childBounds.getMaxY() + parentBounds.getMinY() + parent.getScene().getY() + parent.getScene().getWindow().getY();
        this.entityListPopup.list.setPrefWidth(this.inputBox.getWidth());
        this.entityListPopup.show((Window)this.owner, layoutX + 4.0, layoutY);
    }

    class EntityListPopupControl
    extends PopupControl {
        private TreeSet<Long> set = new TreeSet();
        ListView list = new ListView();
        public static final int ROW_HEIGHT = 24;

        public EntityListPopupControl(final Class<? extends ListCell> listCellCls) {
            this.list.setCellFactory((Callback)new Callback<ListView, ListCell>(){

                public ListCell call(ListView listView) {
                    ListCell cell = null;
                    try {
                        cell = (ListCell)listCellCls.newInstance();
                    }
                    catch (Exception ex) {
                        logger.error("", (Throwable)ex);
                    }
                    return cell;
                }
            });
            this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        EntityListPopupControl.this.launchSelectedItem(event.isControlDown());
                    }
                }
            });
            this.list.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    if (keyEvent.getCode() == KeyCode.ESCAPE) {
                        EntityListPopupControl.this.hide();
                    } else if (keyEvent.getCode() == KeyCode.ENTER) {
                        EntityListPopupControl.this.launchSelectedItem(keyEvent.isControlDown());
                    }
                }
            });
            VBox boxx = new VBox();
            boxx.getChildren().add((Object)this.list);
            this.getScene().setRoot((Parent)boxx);
            this.setAutoHide(true);
            this.setHideOnEscape(true);
        }

        void launchSelectedItem(boolean isControlDown) {
            Object item = this.list.getSelectionModel().getSelectedItem();
            if (item != null) {
                QueryInput.this.guiListener.dispatch(new GUIEvent((Object)this, isControlDown ? QueryInput.EVENT_DEFAULT_ACTION_CONTROL : QueryInput.EVENT_LIST_DOUBLECLICKED, item));
            }
        }

        public void beginLoading() {
            this.set.clear();
            this.list.getItems().clear();
            this.list.setVisible(true);
        }

        public void endLoading() {
        }

        public void appendList(List<Entity> newList) {
            if (newList != null && !newList.isEmpty()) {
                for (Entity en : newList) {
                    if (!this.set.add(en.getId())) continue;
                    this.list.getItems().add((Object)en);
                }
                this.list.setVisible(!this.list.getItems().isEmpty());
                if (this.list.getItems().size() < 10) {
                    this.list.setPrefHeight((double)(this.list.getItems().size() * 24 + 7));
                } else {
                    this.list.setPrefHeight(247.0);
                }
            }
        }
    }
}

