/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.StageUtils;
import myencyclopedia.common.utils.CancelFlagHolder;
import myencyclopedia.gui.mydoc.MydocMain;

public class IndexingProgressStage
extends Stage {
    private Pane splashLayout;
    private ProgressBar singleProgress;
    private Label singleText;
    private Label currentEntityText;
    private ProgressBar totalProgress;
    private int totalEntities;
    private int entitiesProcessed;
    private Button cancelBtn;
    private CancelFlagHolder cancelFlag;

    public IndexingProgressStage(Stage owner) {
        double width = 550.0;
        double height = 300.0;
        this.cancelBtn = new Button(MydocMain.rb.getString("CANCEL"));
        this.cancelBtn.setOnAction(t -> this.cancelFlag.setCancelled());
        this.singleProgress = new ProgressBar();
        this.singleProgress.setPrefWidth(width);
        this.singleText = new Label("");
        this.totalProgress = new ProgressBar();
        this.totalProgress.setPrefWidth(width);
        this.currentEntityText = new Label("");
        this.splashLayout = new VBox();
        if (owner != null) {
            this.initOwner((Window)owner);
        }
        this.initModality(Modality.APPLICATION_MODAL);
        this.splashLayout.getChildren().addAll((Object[])new Node[]{this.totalProgress, this.currentEntityText, this.singleProgress, this.singleText, this.cancelBtn});
        this.singleText.setAlignment(Pos.CENTER);
        this.splashLayout.setStyle("-fx-padding: 5; -fx-background-color: cornsilk; -fx-border-width:5; -fx-border-color: linear-gradient(to bottom, chocolate, derive(chocolate, 50%));");
        this.splashLayout.setEffect((Effect)new DropShadow());
        Scene splashScene = new Scene((Parent)this.splashLayout);
        this.initStyle(StageStyle.UNDECORATED);
        Rectangle2D bounds = Screen.getPrimary().getBounds();
        this.setScene(splashScene);
        this.setX(bounds.getMinX() + bounds.getWidth() / 2.0 - width / 2.0);
        this.setY(bounds.getMinY() + bounds.getHeight() / 2.0 - height / 2.0);
        this.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (!IndexingProgressStage.this.cancelFlag.get()) {
                    IndexingProgressStage.this.cancelFlag.setCancelled();
                }
            }
        });
        StageUtils.addDragListeners((Stage)this);
        this.show();
    }

    public void setCancelFlagHolder(CancelFlagHolder cancelFlag) {
        this.cancelFlag = cancelFlag;
    }

    public void updateProgress(String msg, double percentage) {
        this.singleText.setText(msg);
        this.singleProgress.setProgress(percentage);
    }

    public void setTotalEntities(int number) {
        this.totalEntities = number;
        this.currentEntityText.setText(MydocMain.rb.getString("IndexingProgressStage.Total") + this.totalEntities);
    }

    public void updateTotalProgress(String entityString) {
        ++this.entitiesProcessed;
        this.currentEntityText.setText(entityString);
        this.totalProgress.setProgress((double)this.entitiesProcessed / (double)this.totalEntities);
    }
}

