/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.help;

import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import myencyclopedia.common.gui.LaunchUtils;
import myencyclopedia.gui.help.LicenseManager;
import myencyclopedia.gui.help.ProductInfo;

public class VersionStage
extends Stage {
    private Button okBtn;
    private TextArea versionArea;
    public static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-help");

    public VersionStage(final ProductInfo productInfo) {
        this.initModality(Modality.APPLICATION_MODAL);
        this.okBtn = new Button(rb.getString("OK"));
        this.okBtn.setDefaultButton(true);
        this.okBtn.setOnAction(e -> this.hide());
        String licenseInfo = productInfo.getDisplayName() + " " + productInfo.getFullVersion() + " [build" + productInfo.getBuildtime() + "]";
        String regUser = LicenseManager.getLicenseManager().getRegisteredUser();
        licenseInfo = regUser != null ? licenseInfo + rb.getString("VersionStage.licensed") + regUser : licenseInfo + rb.getString("VersionStage.unreg");
        this.versionArea = new TextArea(licenseInfo);
        this.versionArea.setEditable(false);
        VBox box = new VBox();
        box.getChildren().addAll((Object[])new Node[]{this.versionArea});
        if (regUser == null) {
            Hyperlink link = new Hyperlink();
            link.setText(rb.getString("VersionStage.reg") + "http://myencyclopedia.top/" + productInfo.getProductName() + "/register");
            link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    LaunchUtils.browsePage((String)("http://myencyclopedia.top/" + productInfo.getProductName() + "/register"));
                }
            });
            box.getChildren().add((Object)link);
        }
        box.getChildren().addAll((Object[])new Node[]{this.okBtn});
        Scene scene = new Scene((Parent)box);
        this.setScene(scene);
        this.setTitle(rb.getString("VersionStage.about") + productInfo.getDisplayName());
    }
}

