/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.help;

import myencyclopedia.gui.help.RegisterInfo;

public class ProductInfo {
    private String productName;
    private String displayName;
    private String internalName;
    private int majorVersion;
    private int minorVersion;
    private int ajustmentVersion;
    private String fullVersion;
    private boolean isDev;
    private RegisterInfo regInfo;
    private String buildtime;

    public ProductInfo(String productName) {
        this.productName = productName;
        this.displayName = "ME-" + productName.toUpperCase().substring(0, 1) + productName.substring(1);
        this.internalName = productName;
        if (productName.equals("datum")) {
            this.internalName = "files";
        }
        this.regInfo = new RegisterInfo();
    }

    void setFullVersion(String fullVersion) {
        this.fullVersion = fullVersion;
        String[] strs = fullVersion.split("\\.");
        if (strs.length < 2) {
            System.err.println("Error parsing fullVersion for product [" + this.productName + "," + fullVersion + "]");
            System.exit(-1);
        }
        try {
            this.majorVersion = Integer.parseInt(strs[0]);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Error parsing fullVersion for product [" + this.productName + "," + fullVersion + "]");
            System.exit(-1);
        }
        try {
            this.minorVersion = Integer.parseInt(strs[1]);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Error parsing fullVersion for product [" + this.productName + "," + fullVersion + "]");
            System.exit(-1);
        }
        if (strs.length == 3) {
            try {
                this.ajustmentVersion = Integer.parseInt(strs[2]);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error parsing fullVersion for product [" + this.productName + "," + fullVersion + "]");
                System.exit(-1);
            }
        }
    }

    void setBuildtime(String buildtime) {
        this.buildtime = buildtime;
    }

    public String getBuildtime() {
        return this.buildtime;
    }

    public boolean matchRegInfo() {
        return !((float)this.majorVersion > this.regInfo.version.floatValue());
    }

    RegisterInfo getRegisterInfo() {
        return this.regInfo;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getAjustmentVersion() {
        return this.ajustmentVersion;
    }

    public String getFullVersion() {
        return this.fullVersion;
    }

    public String getTitle() {
        String title = this.displayName;
        title = this.isDev ? title + " dev build " + this.buildtime : title + " " + this.fullVersion;
        return title;
    }

    public boolean isDev() {
        return this.isDev;
    }

    public void setIsDev(boolean isDev) {
        this.isDev = isDev;
    }
}

