/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import java.util.Map;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.hcore.impl.HibernateSearchSessionFactoryObserver;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class HibernateSearchIntegrator
implements Integrator {
    private static final Log log = LoggerFactory.make();
    public static final String AUTO_REGISTER = "hibernate.search.autoregister_listeners";

    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (!this.hibernateSearchNeedsToBeEnabled(configuration)) {
            return;
        }
        FullTextIndexEventListener fullTextIndexEventListener = new FullTextIndexEventListener();
        this.registerHibernateSearchEventListener(fullTextIndexEventListener, serviceRegistry);
        ClassLoaderService hibernateClassLoaderService = (ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class);
        HibernateSearchSessionFactoryObserver observer = new HibernateSearchSessionFactoryObserver(configuration, fullTextIndexEventListener, hibernateClassLoaderService);
        sessionFactory.addObserver((SessionFactoryObserver)observer);
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private boolean hibernateSearchNeedsToBeEnabled(Configuration configuration) {
        boolean enableHibernateSearch = ConfigurationHelper.getBoolean((String)AUTO_REGISTER, (Map)configuration.getProperties(), (boolean)true);
        if (!enableHibernateSearch) {
            log.debug((Object)"Skipping Hibernate Search event listener auto registration");
        }
        return enableHibernateSearch;
    }

    private void registerHibernateSearchEventListener(FullTextIndexEventListener eventListener, SessionFactoryServiceRegistry serviceRegistry) {
        EventListenerRegistry listenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy((DuplicationStrategy)new DuplicationStrategyImpl(FullTextIndexEventListener.class));
        listenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_RECREATE, (Object[])new PostCollectionRecreateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_REMOVE, (Object[])new PostCollectionRemoveEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_UPDATE, (Object[])new PostCollectionUpdateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.FLUSH, (Object[])new FlushEventListener[]{eventListener});
    }

    public static class DuplicationStrategyImpl
    implements DuplicationStrategy {
        private final Class checkClass;

        public DuplicationStrategyImpl(Class checkClass) {
            this.checkClass = checkClass;
        }

        public boolean areMatch(Object listener, Object original) {
            return this.checkClass == original.getClass() && this.checkClass == listener.getClass();
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    }
}

