/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.search.mydoc;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import myencyclopedia.common.utils.FileNameUtils;
import myencyclopedia.search.mydoc.parser.FileParser;
import myencyclopedia.search.mydoc.parser.HtmlParser;
import myencyclopedia.search.mydoc.parser.ParseContext;
import myencyclopedia.search.mydoc.parser.ParseException;
import myencyclopedia.search.mydoc.parser.ParseResult;
import myencyclopedia.search.mydoc.parser.PdfParser;
import myencyclopedia.search.mydoc.parser.TextParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseUtils {
    private static final Logger logger = LoggerFactory.getLogger(ParseUtils.class);

    public static ParseResult parseFile(Path file, ParseContext context) {
        String ext = FileNameUtils.getSuffixPart((String)file.toString()).toLowerCase();
        FileParser parser = null;
        switch (ext) {
            case "html": {
                parser = new HtmlParser();
                break;
            }
            case "txt": {
                parser = new TextParser();
                break;
            }
            case "pdf": {
                parser = new PdfParser();
                break;
            }
            case "doc": {
                break;
            }
        }
        if (parser == null) {
            return null;
        }
        ParseResult ret = null;
        try {
            ret = parser.parse(file.toFile(), context);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static ParseResult parseFolder(Path folder, ParseContext context) {
        StringBuilder sb = new StringBuilder("");
        if (Files.isDirectory(folder, new LinkOption[0])) {
            try {
                Files.walk(folder, new FileVisitOption[0]).forEach(path -> {
                    ParseResult ret;
                    if (Files.isRegularFile(path, new LinkOption[0]) && (ret = ParseUtils.parseFile(path, context)) != null) {
                        sb.append(ret.getContent()).append("\n");
                    }
                });
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
            }
            return new ParseResult(sb);
        }
        return ParseUtils.parseFile(folder, context);
    }
}

