/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui;

import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class Splash
extends Stage {
    private Pane splashLayout;
    private ProgressBar loadProgress = new ProgressBar();
    private Label progressText = new Label("Loading . . .");

    public Splash(Image img) {
        this.splashLayout = new VBox();
        double width = img.getWidth();
        double height = img.getHeight();
        this.loadProgress.setPrefWidth(img.getWidth());
        ImageView splash = new ImageView(img);
        this.splashLayout.getChildren().add((Object)splash);
        this.splashLayout.getChildren().addAll((Object[])new Node[]{this.loadProgress, this.progressText});
        this.progressText.setAlignment(Pos.CENTER);
        this.splashLayout.setStyle("-fx-padding: 5; -fx-background-color: cornsilk; -fx-border-width:5; -fx-border-color: linear-gradient(to bottom, chocolate, derive(chocolate, 50%));");
        this.splashLayout.setEffect((Effect)new DropShadow());
        Scene splashScene = new Scene((Parent)this.splashLayout);
        this.initStyle(StageStyle.UNDECORATED);
        Rectangle2D bounds = Screen.getPrimary().getBounds();
        this.setScene(splashScene);
        this.setX(bounds.getMinX() + bounds.getWidth() / 2.0 - width / 2.0);
        this.setY(bounds.getMinY() + bounds.getHeight() / 2.0 - height / 2.0);
        this.show();
    }

    public void updateProgress(String msg, double percentage) {
        this.progressText.setText(msg);
        this.loadProgress.setProgress(percentage);
    }
}

