/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui;

import java.util.List;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.StageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatingListStage
extends Stage {
    public static final String EVENT_FILE_DROPPED = "FloatingStage_dropped";
    private double stageX = 500.0;
    private double stageY = 500.0;
    private double stageWidth = 600.0;
    private int PREFERRED_COLUMN = 30;
    private double stageHeight = 100.0;
    private static final double INSET_TOP = 30.0;
    private static final double INSET_LEFT = 25.0;
    private GUIListener guiListener;
    private Scene scene;
    private static final Logger logger = LoggerFactory.getLogger(FloatingListStage.class);

    public FloatingListStage(GUIListener listener, Pane pane) {
        this.initModality(Modality.NONE);
        this.initStyle(StageStyle.UNDECORATED);
        this.guiListener = listener;
        BorderPane bp = new BorderPane();
        this.scene = new Scene((Parent)bp);
        bp.setStyle("-fx-background: #d0bbe3;");
        this.stageHeight = 80.0;
        bp.setPadding(new Insets(30.0, 25.0, 30.0, 25.0));
        bp.setCenter((Node)pane);
        this.setScene(this.scene);
        StageUtils.addDragListeners(this);
        this.scene.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                if (db.hasFiles()) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                } else {
                    event.consume();
                }
            }
        });
        this.scene.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasFiles()) {
                    success = true;
                    final List files = db.getFiles();
                    event.setDropCompleted(success);
                    event.consume();
                    if (files != null) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                FloatingListStage.this.guiListener.dispatch(new GUIEvent((Object)FloatingListStage.this, FloatingListStage.EVENT_FILE_DROPPED, files));
                            }
                        });
                    }
                }
            }
        });
        this.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                FloatingListStage.this.stageX = FloatingListStage.this.getX();
                FloatingListStage.this.stageY = FloatingListStage.this.getY();
            }
        });
        this.setOnShowing((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                FloatingListStage.this.setX(FloatingListStage.this.stageX);
                FloatingListStage.this.setY(FloatingListStage.this.stageY);
            }
        });
    }
}

