/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.mydoc;

import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import myencyclopedia.model.Entity;
import myencyclopedia.model.common.DateMarker;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.common.entity.Taggable;
import myencyclopedia.model.hbn.HBAbstractEntity;
import myencyclopedia.model.hbn.HBRelationCollection;
import myencyclopedia.model.hbn.PropertyField;
import myencyclopedia.model.hbn.RelationField;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@javax.persistence.Entity
@Indexed
public class Note
extends HBAbstractEntity
implements Taggable {
    public static final int _version = 1;
    public static final String P_TITLE = "title";
    public static final String P_FILEPATH = "filepath";
    public static final String P_IS_HIDDEN = "is_hidden";
    public static final String P_FAVOURITE = "favourite";
    public static final String P_VISITEDNUM = "visited_num";
    public static final String P_DATE = "datemarker";
    public static final String R_TAGS = "tags";
    @Transient
    private boolean isModified;
    @RelationField(name="tags")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="RC_Tags")
    protected HBRelationCollection<Tag> tags;
    @PropertyField(name="title")
    @Column(name="title")
    @Field(index=Index.YES, analyze=Analyze.YES, store=Store.YES)
    protected String title;
    @PropertyField(name="filepath")
    @Column(name="filepath")
    protected String path;
    @PropertyField(name="is_hidden")
    @Column(name="is_hidden")
    protected Boolean is_hidden;
    @PropertyField(name="favourite")
    @Column(name="favourite")
    protected Integer is_favourite;
    @PropertyField(name="visited_num")
    @Column(name="visited_num")
    protected Integer visited_num;
    @PropertyField(name="datemarker")
    @Column(name="datemarker")
    @Type(type="myencyclopedia.model.common.usertype.DateMarkerUserType")
    protected DateMarker creation_date;
    @Transient
    public String info;

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean isModified) {
        this.isModified = isModified;
    }

    public String getTitle() {
        return this.title;
    }

    public HBRelationCollection getTagContainer() {
        return this.tags;
    }

    public void setTagList(List<Tag> tagList) {
    }

    public DateMarker getDateMarker() {
        return this.creation_date;
    }

    public void setHidden(boolean bool) {
        this.is_hidden = bool;
    }

    public boolean isHidden() {
        return Boolean.TRUE.equals(this.is_hidden);
    }

    public boolean isFavourite() {
        return this.is_favourite != null;
    }

    public String getFilePath() {
        return this.path;
    }

    public void incrementVisitedNumber() {
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String str) {
        this.info = str;
    }

    public String toString() {
        return this.title;
    }

    public Tag[] getTags() {
        if (this.tags == null) {
            return Taggable.EMPTY_TAGS;
        }
        Entity[] entities = this.tags.getTarget();
        Tag[] ret = new Tag[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            ret[i] = (Tag)entities[i];
        }
        return ret;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Note other = (Note)((Object)obj);
        return Objects.equals(this.id, other.id);
    }
}

