/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.mydoc;

import java.util.Arrays;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import myencyclopedia.model.Entity;
import myencyclopedia.model.common.DateMarker;
import myencyclopedia.model.common.YearMonthDay;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.common.entity.Taggable;
import myencyclopedia.model.hbn.HBAbstractEntity;
import myencyclopedia.model.hbn.HBRelationCollection;
import myencyclopedia.model.hbn.PropertyField;
import myencyclopedia.model.hbn.RelationField;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
public class Doc
extends HBAbstractEntity
implements Taggable {
    public static final int _version = 1;
    public static final String P_TITLE = "title";
    public static final String P_SUBTITLE = "subtitle";
    public static final String P_AUTHORS = "authors";
    public static final String P_SOURCE = "source";
    public static final String P_FILEPATH = "filepath";
    public static final String P_IS_HIDDEN = "is_hidden";
    public static final String P_FAVOURITE = "favourite";
    public static final String P_IS_SCAN = "is_scan";
    public static final String P_IS_THESIS = "is_thesis";
    public static final String P_IS_SLIDE = "is_slide";
    public static final String P_PUBLISH_DATE = "published_date";
    public static final String P_VISITEDNUM = "visited_num";
    public static final String P_DATE = "datemarker";
    public static final String P_FILELIST = "filelist";
    public static final String P_MINE = "mine";
    public static final String P_MD5 = "hash_md5";
    public static final String R_TAGS = "tags";
    @RelationField(name="tags")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="RC_Tags")
    protected HBRelationCollection<Tag> tags;
    @PropertyField(name="title")
    @Column(name="title")
    protected String title;
    @PropertyField(name="subtitle")
    @Column(name="subtitle")
    protected String subtitle;
    @PropertyField(name="authors")
    @Column(name="authors")
    protected String authors;
    @PropertyField(name="hash_md5")
    @Column(name="hash_md5")
    private String md5;
    @PropertyField(name="source")
    @Column(name="source")
    protected String source;
    @PropertyField(name="filepath")
    @Column(name="filepath")
    protected String path;
    @PropertyField(name="is_hidden")
    @Column(name="is_hidden")
    protected Boolean is_hidden;
    @PropertyField(name="favourite")
    @Column(name="favourite")
    protected Integer is_favourite;
    @PropertyField(name="is_scan")
    @Column(name="is_scan")
    protected Boolean is_scan;
    @PropertyField(name="is_thesis")
    @Column(name="is_thesis")
    protected Boolean is_thesis;
    @PropertyField(name="is_slide")
    @Column(name="is_slide")
    protected Boolean is_slide;
    @PropertyField(name="published_date")
    @Column(name="published_date")
    @Type(type="myencyclopedia.model.common.usertype.YearMonthDayUserType")
    private YearMonthDay published_date;
    @PropertyField(name="visited_num")
    @Column(name="visited_num")
    protected Integer visited_num;
    @PropertyField(name="datemarker")
    @Column(name="datemarker")
    @Type(type="myencyclopedia.model.common.usertype.DateMarkerUserType")
    protected DateMarker creation_date;
    @PropertyField(name="filelist")
    @Column(name="filelist", length=1024)
    protected String file_list;
    @PropertyField(name="mine")
    @Column(name="mine")
    protected Boolean is_mine;
    @Transient
    public String info;

    public String getTitle() {
        return this.title;
    }

    public HBRelationCollection getTagContainer() {
        return this.tags;
    }

    public DateMarker getDateMarker() {
        return this.creation_date;
    }

    public String getContentFolder() {
        return this.path;
    }

    public List<String> getFileList() {
        return Arrays.asList(this.file_list.split(":"));
    }

    public void setFileList(List<String> fileList) {
        StringBuilder sb = new StringBuilder(fileList.get(0));
        for (int i = 1; i < fileList.size(); ++i) {
            sb.append(":").append(fileList.get(i));
        }
        this.setPropertyValue(P_FILELIST, sb.toString());
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String str) {
        this.info = str;
    }

    public void setHidden(boolean bool) {
        this.is_hidden = bool;
    }

    public boolean isHidden() {
        return Boolean.TRUE.equals(this.is_hidden);
    }

    public boolean isFavourite() {
        return this.is_favourite != null;
    }

    public String toString() {
        return this.title;
    }

    public Tag[] getTags() {
        if (this.tags == null) {
            return Taggable.EMPTY_TAGS;
        }
        Entity[] entities = this.tags.getTarget();
        Tag[] ret = new Tag[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            ret[i] = (Tag)entities[i];
        }
        return ret;
    }
}

