/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.hbn;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import myencyclopedia.model.hbn.HBAbstractEntity;
import myencyclopedia.model.hbn.HBRelation;
import myencyclopedia.model.hbn.HBRelationCollection;
import myencyclopedia.model.hbn.SchemaVersion;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtil {
    static final Logger logger = LoggerFactory.getLogger(SchemaUtil.class);
    public static final Class[] CORE_CLASSES = new Class[]{HBAbstractEntity.class, HBRelationCollection.class, HBRelation.class, SchemaVersion.class};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyDB(Class[] classes, SessionFactory sf) throws SchemaUnmatchedException {
        ArrayList<Class> clses = new ArrayList<Class>();
        clses.addAll(Arrays.asList(CORE_CLASSES));
        clses.addAll(Arrays.asList(classes));
        ArrayList<Unmatched> unmatchedList = new ArrayList<Unmatched>();
        try (Session s = sf.openSession();){
            Criteria c = s.createCriteria(SchemaVersion.class);
            List lst = c.list();
            for (Class cls : clses) {
                Unmatched unmatched;
                if (cls.equals(SchemaVersion.class) || (unmatched = SchemaUtil.verifyClass(cls, lst)) == null) continue;
                unmatchedList.add(unmatched);
            }
        }
        if (!unmatchedList.isEmpty()) {
            for (Unmatched unmatched : unmatchedList) {
                logger.error(unmatched.toString());
            }
            throw new SchemaUnmatchedException(unmatchedList.toArray(new Unmatched[0]));
        }
    }

    private static Unmatched verifyClass(Class cls, List<SchemaVersion> lst) {
        Integer verCls = null;
        try {
            Field field = cls.getField("_version");
            verCls = field.getInt(null);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            System.exit(-1);
        }
        for (SchemaVersion sv : lst) {
            if (!sv.name.equals(cls.getCanonicalName())) continue;
            if (sv.version.equals(verCls)) {
                return null;
            }
            return new Unmatched(cls, verCls, sv.version);
        }
        return new Unmatched(cls, verCls, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistVersion(Class[] classes, SessionFactory sf) {
        ArrayList<Class> clses = new ArrayList<Class>();
        clses.addAll(Arrays.asList(CORE_CLASSES));
        clses.addAll(Arrays.asList(classes));
        Session s = sf.openSession();
        s.beginTransaction();
        try {
            for (Class cls : clses) {
                if (cls.equals(SchemaVersion.class)) continue;
                Integer verCls = null;
                try {
                    Field field = cls.getField("_version");
                    verCls = field.getInt(null);
                }
                catch (Exception ex) {
                    logger.error("", (Throwable)ex);
                    System.exit(-1);
                }
                SchemaVersion sv = new SchemaVersion();
                sv.name = cls.getCanonicalName();
                sv.version = verCls;
                s.save((Object)sv);
            }
            s.getTransaction().commit();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            System.exit(-1);
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateVersion(Class[] classes, SessionFactory sf) {
        ArrayList<Class> clses = new ArrayList<Class>();
        clses.addAll(Arrays.asList(CORE_CLASSES));
        clses.addAll(Arrays.asList(classes));
        Session s = sf.openSession();
        s.beginTransaction();
        try {
            for (Class cls : clses) {
                if (cls.equals(SchemaVersion.class)) continue;
                Integer verCls = null;
                try {
                    Field field = cls.getField("_version");
                    verCls = field.getInt(null);
                }
                catch (Exception ex) {
                    logger.error("", (Throwable)ex);
                    System.exit(-1);
                }
                List queryList = s.createCriteria(SchemaVersion.class).add((Criterion)Restrictions.eq((String)"name", (Object)cls.getCanonicalName())).list();
                if (queryList.size() > 1) {
                    logger.error("Multiple(" + queryList.size() + ") SchemaVersion found:" + cls);
                    System.exit(-1);
                }
                SchemaVersion sv = null;
                if (queryList.isEmpty()) {
                    sv = new SchemaVersion();
                    sv.name = cls.getCanonicalName();
                    sv.version = verCls;
                    s.save((Object)sv);
                    System.out.println("Created " + sv.name + ":" + sv.version);
                    continue;
                }
                sv = (SchemaVersion)queryList.get(0);
                sv.version = verCls;
                s.saveOrUpdate((Object)sv);
                System.out.println("Updated " + sv.name + ":" + sv.version);
            }
            s.getTransaction().commit();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            System.exit(-1);
        }
        finally {
            s.close();
        }
    }

    public static class Unmatched {
        public Class cls;
        public Integer verCurrent;
        public Integer verDB;

        public Unmatched(Class cls, Integer verCurrent, Integer verDB) {
            this.cls = cls;
            this.verCurrent = verCurrent;
            this.verDB = verDB;
        }

        public String toString() {
            return this.cls.getCanonicalName() + ":" + "current_ver=" + this.verCurrent + " db_ver=" + this.verDB;
        }
    }

    public static class SchemaUnmatchedException
    extends Exception {
        public Unmatched[] unmatched;

        public SchemaUnmatchedException(Unmatched[] theUnmatched) {
            this.unmatched = theUnmatched;
        }
    }
}

