/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.hbn;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import myencyclopedia.model.Entity;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.hbn.HBAbstractEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@javax.persistence.Entity
@Table(name="relation_collection")
@Inheritance(strategy=InheritanceType.JOINED)
public class HBRelationCollection<T extends Entity>
extends HBAbstractEntity
implements RelationCollection<T> {
    public static final int _version = 1;
    private static final Logger logger = LoggerFactory.getLogger(HBAbstractEntity.class);
    @ManyToMany(targetEntity=HBAbstractEntity.class)
    @JoinTable(name="RelationCollection_Entity", joinColumns={@JoinColumn(name="r_id")}, inverseJoinColumns={@JoinColumn(name="target_id")})
    @OrderColumn
    protected List<T> targetEntity;
    @Transient
    protected HBAbstractEntity owner;
    @Transient
    protected String name;
    @Transient
    MethodHandle setter;

    public HBRelationCollection() {
    }

    public HBRelationCollection(HBAbstractEntity owner, String name, MethodHandle setter) {
        this.owner = owner;
        this.name = name;
        this.setter = setter;
    }

    public String getRelationName() {
        return this.name;
    }

    public void setRelationName(String name) {
        this.name = name;
    }

    public HBAbstractEntity getOwner() {
        return this.owner;
    }

    public void setOwner(Entity owner) {
        this.owner = (HBAbstractEntity)owner;
    }

    public T[] getTarget() {
        if (this.targetEntity == null || this.targetEntity.isEmpty()) {
            return null;
        }
        Entity[] toR = (Entity[])Array.newInstance(((Entity)this.targetEntity.get(0)).getClass(), this.targetEntity.size());
        for (int i = 0; i < this.targetEntity.size(); ++i) {
            toR[i] = (Entity)this.targetEntity.get(i);
        }
        return toR;
    }

    public void setTarget(T[] t) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void setOwnerField() {
        try {
            this.setter.invoke(this.getOwner(), this.targetEntity == null || this.targetEntity.isEmpty() ? null : this);
        }
        catch (Throwable ex) {
            logger.error("", ex);
        }
    }

    public void setTargets(T ... entities) {
        this.targetEntity = new ArrayList<T>();
        if (entities != null && entities.length > 0) {
            this.targetEntity.addAll(Arrays.asList(entities));
        }
        this.setOwnerField();
    }

    public void setTargets(List<T> entities) {
        this.targetEntity = new ArrayList<T>();
        if (entities != null && entities.size() > 0) {
            this.targetEntity.addAll(entities);
        }
        this.setOwnerField();
    }

    public void removeTarget(T entity) {
        if (this.targetEntity == null) {
            return;
        }
        Iterator<T> it = this.targetEntity.iterator();
        while (it.hasNext()) {
            Entity t = (Entity)it.next();
            if (t != entity && (t.getId() == null || !t.getId().equals(entity.getId()))) continue;
            it.remove();
            break;
        }
        this.setOwnerField();
    }

    public void addTarget(T entity) {
        if (this.targetEntity == null) {
            this.targetEntity = new ArrayList<T>();
        }
        this.targetEntity.add(entity);
        this.setOwnerField();
    }
}

