/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.hbn;

import java.lang.invoke.MethodHandle;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import myencyclopedia.model.Entity;
import myencyclopedia.model.Relation;
import myencyclopedia.model.hbn.HBAbstractEntity;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@javax.persistence.Entity
@Table(name="relation_base")
@Inheritance(strategy=InheritanceType.JOINED)
public class HBRelation<T extends HBAbstractEntity>
extends HBAbstractEntity
implements Relation<T> {
    public static final int _version = 1;
    private static final Logger logger = LoggerFactory.getLogger(HBRelation.class);
    @OneToOne
    @Type(type="myencyclopedia.model.hbn.HBAbstractEntity")
    @JoinColumn(name="en_id")
    protected T targetEntity;
    @Transient
    protected HBAbstractEntity owner;
    @Transient
    protected String name;
    @Transient
    MethodHandle setter;

    public HBRelation() {
    }

    public HBRelation(HBAbstractEntity owner, String name, MethodHandle setter) {
        this.owner = owner;
        this.name = name;
        this.setter = setter;
    }

    public void setTarget(T t) {
        this.targetEntity = t;
        try {
            this.setter.invoke(this.getOwner(), t == null ? null : this);
        }
        catch (Throwable ex) {
            logger.error("", ex);
        }
    }

    public T getTarget() {
        return this.targetEntity;
    }

    public String getRelationName() {
        return this.name;
    }

    public void setRelationName(String name) {
        this.name = name;
    }

    public HBAbstractEntity getOwner() {
        return this.owner;
    }

    public void setOwner(Entity owner) {
        this.owner = (HBAbstractEntity)owner;
    }
}

