/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.hbn;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;
import myencyclopedia.model.Entity;
import myencyclopedia.model.Property;
import myencyclopedia.model.Relation;
import myencyclopedia.model.hbn.HBPropertyImpl;
import myencyclopedia.model.hbn.HBRelation;
import myencyclopedia.model.hbn.HBRelationCollection;
import myencyclopedia.model.hbn.PropertyField;
import myencyclopedia.model.hbn.RelationField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@javax.persistence.Entity
@Table(name="entity")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class HBAbstractEntity
implements Entity {
    private static final Logger logger = LoggerFactory.getLogger(HBAbstractEntity.class);
    public static final int _version = 1;
    @Transient
    protected Map<String, Property> mapProp = new HashMap<String, Property>();
    @Transient
    protected Map<String, MethodHandle> mapRelNameToSetter = null;
    @Transient
    protected Map<String, Relation> mapRelNameToRel = null;
    @Transient
    protected MethodHandles.Lookup lookup = MethodHandles.lookup();
    @Id
    @GeneratedValue
    protected Long id;

    public HBAbstractEntity() {
        try {
            Class<?> klass = this.getClass();
            do {
                for (Field f : klass.getDeclaredFields()) {
                    PropertyField pf = f.getDeclaredAnnotation(PropertyField.class);
                    if (pf == null) continue;
                    Class<?> valueClass = f.getType();
                    f.setAccessible(true);
                    MethodHandle mhGetter = this.lookup.unreflectGetter(f);
                    MethodHandle mhSetter = this.lookup.unreflectSetter(f);
                    HBPropertyImpl p = new HBPropertyImpl(this, pf.name(), valueClass, mhGetter, mhSetter);
                    this.mapProp.put(pf.name(), p);
                }
            } while (!HBAbstractEntity.class.equals(klass = klass.getSuperclass()));
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    protected void init() {
        this.mapRelNameToSetter = new HashMap<String, MethodHandle>();
        this.mapRelNameToRel = new HashMap<String, Relation>();
        try {
            Class<?> klass = this.getClass();
            do {
                for (Field f : klass.getDeclaredFields()) {
                    if (!Relation.class.isAssignableFrom(f.getType())) continue;
                    Class<?> type = f.getType();
                    RelationField rf = f.getDeclaredAnnotation(RelationField.class);
                    String name = f.getName();
                    if (rf != null) {
                        name = rf.name();
                    }
                    f.setAccessible(true);
                    MethodHandle mhSetter = this.lookup.unreflectSetter(f);
                    this.mapRelNameToSetter.put(name, mhSetter);
                    HBRelation r = (Relation)f.get(this);
                    HBAbstractEntity owner = this;
                    if (r == null) {
                        if (type.equals(HBRelationCollection.class)) {
                            r = new HBRelationCollection(owner, name, mhSetter);
                        } else if (type.equals(HBRelation.class)) {
                            r = new HBRelation(owner, name, mhSetter);
                        }
                    } else {
                        r.setOwner(this);
                        if (type.equals(HBRelationCollection.class)) {
                            ((HBRelationCollection)((Object)r)).setRelationName(name);
                            ((HBRelationCollection)((Object)r)).setter = mhSetter;
                        } else if (type.equals(HBRelation.class)) {
                            ((HBRelation)r).setRelationName(name);
                            r.setter = mhSetter;
                        }
                    }
                    this.mapRelNameToRel.put(name, r);
                }
            } while (!HBAbstractEntity.class.equals(klass = klass.getSuperclass()));
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long theid) {
        this.id = theid;
    }

    public String[] getPropertyNames() {
        return this.mapProp.keySet().toArray(new String[0]);
    }

    public Property[] getProperties() {
        return this.mapProp.values().toArray(new Property[0]);
    }

    public Property getProperty(String name) {
        return this.mapProp.get(name);
    }

    public void setPropertyValue(String name, Object newValue) {
        Property p = this.mapProp.get(name);
        if (p != null) {
            p.setValue(newValue);
        }
    }

    public Object getPropertyValue(String name) {
        Property p = this.mapProp.get(name);
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public Relation[] getRelations() {
        if (this.mapRelNameToRel == null) {
            this.init();
        }
        return this.mapRelNameToRel.values().toArray(new Relation[0]);
    }

    public Relation[] getEffectiveRelations() {
        ArrayList<Relation> ret = new ArrayList<Relation>();
        for (Relation r : this.mapRelNameToRel.values()) {
            if (r.getTarget() == null) continue;
            ret.add(r);
        }
        return ret.toArray(new Relation[0]);
    }

    public Relation getRelation(String name) {
        if (this.mapRelNameToRel == null) {
            this.init();
        }
        return this.mapRelNameToRel.get(name);
    }

    public String[] getRelationNames() {
        if (this.mapRelNameToRel == null) {
            this.init();
        }
        return this.mapRelNameToRel.keySet().toArray(new String[0]);
    }
}

