/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.hbn;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import myencyclopedia.model.hbn.HBAbstractEntity;
import myencyclopedia.model.hbn.HBRelationCollection;
import myencyclopedia.model.hbn.PropertyField;
import myencyclopedia.model.hbn.RelationField;

public class EntityUtil {
    public static HashMap<String, Class> getClassPropertyInfo(Class<? extends HBAbstractEntity> cls) {
        HashMap<String, Class> ret = new HashMap<String, Class>();
        EntityUtil.getClassPropertyInfoImpl(cls, ret);
        Class<? extends HBAbstractEntity> klass = cls;
        while (!HBAbstractEntity.class.equals(klass.getSuperclass())) {
            klass = klass.getSuperclass();
            EntityUtil.getClassPropertyInfoImpl(klass, ret);
        }
        return ret;
    }

    @Deprecated
    public static List<PropertyField> getClassProperties(Class<? extends HBAbstractEntity> cls) {
        List<PropertyField> ret = EntityUtil.getClassPropertiesImpl(cls);
        Class<? extends HBAbstractEntity> klass = cls;
        while (!HBAbstractEntity.class.equals(klass.getSuperclass())) {
            klass = klass.getSuperclass();
            ret.addAll(EntityUtil.getClassPropertiesImpl(klass));
        }
        return ret;
    }

    public static HashMap<String, Boolean> getClassRelationInfo(Class<? extends HBAbstractEntity> cls) {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        EntityUtil.getClassRelationInfoImpl(cls, ret);
        Class<? extends HBAbstractEntity> klass = cls;
        while (!HBAbstractEntity.class.equals(klass.getSuperclass())) {
            klass = klass.getSuperclass();
            EntityUtil.getClassRelationInfoImpl(klass, ret);
        }
        return ret;
    }

    @Deprecated
    public static List<RelationField> getClassRelations(Class<? extends HBAbstractEntity> cls) {
        List<RelationField> ret = EntityUtil.getClassRelationsImpl(cls);
        Class<? extends HBAbstractEntity> klass = cls;
        while (!HBAbstractEntity.class.equals(klass.getSuperclass())) {
            klass = klass.getSuperclass();
            ret.addAll(EntityUtil.getClassRelationsImpl(klass));
        }
        return ret;
    }

    private static void getClassPropertyInfoImpl(Class<? extends HBAbstractEntity> cls, HashMap<String, Class> map) {
        for (Field f : cls.getDeclaredFields()) {
            PropertyField pf = f.getDeclaredAnnotation(PropertyField.class);
            if (pf == null) continue;
            Class<?> valueClass = f.getType();
            map.put(pf.name(), valueClass);
        }
    }

    private static void getClassRelationInfoImpl(Class<? extends HBAbstractEntity> cls, HashMap<String, Boolean> map) {
        for (Field f : cls.getDeclaredFields()) {
            RelationField rf = f.getDeclaredAnnotation(RelationField.class);
            if (rf == null) continue;
            boolean isRelationCollection = f.getType().equals(HBRelationCollection.class);
            map.put(rf.name(), isRelationCollection);
        }
    }

    private static List<PropertyField> getClassPropertiesImpl(Class<? extends HBAbstractEntity> cls) {
        ArrayList<PropertyField> ret = new ArrayList<PropertyField>();
        for (Field f : cls.getDeclaredFields()) {
            PropertyField pf = f.getDeclaredAnnotation(PropertyField.class);
            if (pf == null) continue;
            ret.add(pf);
        }
        return ret;
    }

    private static List<RelationField> getClassRelationsImpl(Class<? extends HBAbstractEntity> cls) {
        ArrayList<RelationField> ret = new ArrayList<RelationField>();
        for (Field f : cls.getDeclaredFields()) {
            RelationField rf = f.getDeclaredAnnotation(RelationField.class);
            if (rf == null) continue;
            ret.add(rf);
        }
        return ret;
    }
}

