/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view.predefined;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import myencyclopedia.common.gui.entity.view.AbstractEditorRenderer;
import myencyclopedia.model.common.StringConverter;

public class TextFieldEditorRenderer
extends AbstractEditorRenderer {
    protected TextField textField = new TextField();

    public TextFieldEditorRenderer() {
        this.textField.setEditable(false);
        this.textField.focusedProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue.equals(false) && !TextFieldEditorRenderer.this.isRenderer) {
                    TextFieldEditorRenderer.this.forceCommit();
                } else if (newValue.equals(true) && TextFieldEditorRenderer.this.isRenderer) {
                    TextFieldEditorRenderer.this.setMode(false);
                }
            }
        });
    }

    @Override
    public boolean forceCommit() {
        try {
            this.validateAndCommit(this.textField.getText());
        }
        catch (StringConverter.ConversionException ex) {
            this.textField.requestFocus();
            return false;
        }
        this.setMode(true);
        return true;
    }

    @Override
    public void postSetMode(boolean isRenderer) {
        this.textField.setEditable(!isRenderer);
    }

    @Override
    public Region getComponent() {
        return this.textField;
    }

    @Override
    public void loadObject(Object obj) {
        this.textField.setText(this.fromObjToString(obj));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new TextFieldEditorRenderer();
    }
}

