/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view.predefined;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import myencyclopedia.common.gui.entity.view.AbstractEditor;
import myencyclopedia.model.common.StringConverter;

public class TextFieldEditor
extends AbstractEditor {
    protected TextField textField = new TextField();

    public TextFieldEditor() {
        this.textField.focusedProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue.equals(false)) {
                    TextFieldEditor.this.forceCommit();
                }
            }
        });
    }

    public TextFieldEditor(StringConverter converter) {
        this();
        this.stringConverter = converter;
    }

    @Override
    public boolean forceCommit() {
        try {
            this.validateAndCommit(this.textField.getText());
        }
        catch (StringConverter.ConversionException ex) {
            this.textField.requestFocus();
            return false;
        }
        this.requestSwitchToRenderer();
        return true;
    }

    @Override
    public void activate() {
        this.textField.requestFocus();
    }

    @Override
    public Region getEditorControl() {
        return this.textField;
    }

    @Override
    public void loadEditorObject(Object obj) {
        this.textField.setText(this.fromObjToString(obj));
    }
}

