/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view.predefined;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Region;
import myencyclopedia.common.gui.entity.view.AbstractEditor;
import myencyclopedia.model.common.StringConverter;

public class TextAreaEditor
extends AbstractEditor {
    protected TextArea area = new TextArea();

    public TextAreaEditor() {
        this.area.focusedProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue.equals(false)) {
                    TextAreaEditor.this.forceCommit();
                }
            }
        });
    }

    public TextAreaEditor(StringConverter converter) {
        this();
        this.stringConverter = converter;
    }

    @Override
    public boolean forceCommit() {
        try {
            this.validateAndCommit(this.area.getText());
        }
        catch (StringConverter.ConversionException ex) {
            this.area.requestFocus();
            return false;
        }
        this.requestSwitchToRenderer();
        return true;
    }

    @Override
    public void activate() {
        this.area.requestFocus();
    }

    @Override
    public Region getEditorControl() {
        return this.area;
    }

    @Override
    public void loadEditorObject(Object obj) {
        this.area.setText(this.fromObjToString(obj));
    }
}

