/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view.predefined;

import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import myencyclopedia.common.gui.entity.ObjectWrapper;
import myencyclopedia.common.gui.entity.view.AbstractRenderer;

public class ListViewRenderer
extends AbstractRenderer {
    protected ListView list = new ListView();
    final int ROW_HEIGHT = 24;

    public ListViewRenderer() {
        this.list.setPrefHeight(24.0);
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ListViewRenderer.this.requestSwitchToEditor();
                }
            }
        });
        this.list.getItems().addListener(new ListChangeListener(){

            public void onChanged(ListChangeListener.Change change) {
                if (ListViewRenderer.this.list.getItems().isEmpty()) {
                    ListViewRenderer.this.list.setPrefHeight(24.0);
                } else if (ListViewRenderer.this.list.getItems().size() < 4) {
                    ListViewRenderer.this.list.setPrefHeight((double)(ListViewRenderer.this.list.getItems().size() * 24));
                } else {
                    ListViewRenderer.this.list.setPrefHeight(96.0);
                }
            }
        });
    }

    public Control getRendererControl() {
        return this.list;
    }

    @Override
    public void loadRendererObject(Object obj) {
        this.list.getItems().clear();
        if (obj == null) {
            return;
        }
        if (obj instanceof List) {
            List lst = (List)obj;
            for (Object element : lst) {
                String str = this.fromObjToString(element);
                ObjectWrapper wrapper = new ObjectWrapper(element, str);
                this.list.getItems().add(wrapper);
            }
        } else if (obj instanceof Object[]) {
            Object[] lst;
            for (Object element : lst = (Object[])obj) {
                String str = this.fromObjToString(element);
                ObjectWrapper<Object> wrapper = new ObjectWrapper<Object>(element, str);
                this.list.getItems().add(wrapper);
            }
        } else {
            String str = this.fromObjToString(obj);
            ObjectWrapper<Object> wrapper = new ObjectWrapper<Object>(obj, str);
            this.list.getItems().add(wrapper);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new ListViewRenderer();
    }
}

