/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view.predefined;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import myencyclopedia.common.gui.entity.view.AbstractStageEditor;
import myencyclopedia.model.common.StringConverter;

public class DefaultMultiValueStage
extends AbstractStageEditor {
    protected ComboBox combo;
    protected ListView listSelection;
    protected Button btnOk = new Button("OK");
    protected Button btnCancel;
    protected boolean saved;
    final int ROW_HEIGHT = 24;

    public DefaultMultiValueStage(String title) {
        this.btnOk.setOnAction(e -> {
            try {
                this.tryClose(this.listSelection.getItems());
            }
            catch (StringConverter.ConversionException conversionException) {
                // empty catch block
            }
        });
        this.btnCancel = new Button("Cancel");
        this.btnCancel.setOnAction(e -> this.close());
        HBox controlBox = new HBox();
        controlBox.getChildren().addAll((Object[])new Node[]{this.btnOk, this.btnCancel});
        this.combo = new ComboBox();
        this.combo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Object obj = DefaultMultiValueStage.this.combo.getSelectionModel().getSelectedItem();
                if (obj == null) {
                    return;
                }
                if (!DefaultMultiValueStage.this.listSelection.getItems().contains(obj)) {
                    DefaultMultiValueStage.this.listSelection.getItems().add(obj);
                }
            }
        });
        this.listSelection = new ListView();
        this.listSelection.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    Object obj = DefaultMultiValueStage.this.listSelection.getSelectionModel().getSelectedItem();
                    DefaultMultiValueStage.this.listSelection.getItems().remove(obj);
                }
            }
        });
        VBox vbox = new VBox();
        this.combo.setMaxWidth(Double.MAX_VALUE);
        vbox.getChildren().addAll((Object[])new Node[]{this.combo, this.listSelection, controlBox});
        VBox.setVgrow((Node)this.listSelection, (Priority)Priority.ALWAYS);
        Scene scene = new Scene((Parent)vbox, 550.0, 400.0);
        this.setScene(scene);
        this.setTitle(title);
    }

    public void populateItems(Object[] items) {
        this.combo.getItems().addAll(Arrays.asList(items));
    }

    public void populateItems(List items) {
        this.combo.getItems().addAll((Collection)items);
    }

    @Override
    public void loadEditorObject(Object obj) {
        this.listSelection.getItems().clear();
        if (obj == null) {
            return;
        }
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            this.listSelection.getItems().addAll(Arrays.asList(array));
        }
        if (obj instanceof List) {
            List list = (List)obj;
            this.listSelection.getItems().addAll((Collection)list);
        }
    }
}

