/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view.predefined;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.Region;
import myencyclopedia.common.gui.entity.view.AbstractEditorRenderer;
import myencyclopedia.model.common.StringConverter;

public class ComboBoxEditorRenderer<T>
extends AbstractEditorRenderer {
    protected ComboBox combo = new ComboBox();

    protected ComboBoxEditorRenderer() {
        this.combo.focusedProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue.equals(false) && !ComboBoxEditorRenderer.this.isRenderer) {
                    ComboBoxEditorRenderer.this.forceCommit();
                } else if (newValue.equals(true) && ComboBoxEditorRenderer.this.isRenderer) {
                    ComboBoxEditorRenderer.this.setMode(false);
                }
            }
        });
    }

    public ComboBoxEditorRenderer(T[] items) {
        this();
        this.combo.getItems().add(null);
        this.combo.getItems().addAll((Object[])items);
    }

    @Override
    public boolean forceCommit() {
        try {
            this.validateAndCommit(this.combo.getValue());
        }
        catch (StringConverter.ConversionException ex) {
            this.combo.requestFocus();
            return false;
        }
        this.setMode(true);
        return true;
    }

    @Override
    public Region getComponent() {
        return this.combo;
    }

    @Override
    public void loadObject(Object obj) {
        this.combo.getSelectionModel().select(obj);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new ComboBoxEditorRenderer<T>();
    }
}

