/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view.predefined;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.Region;
import myencyclopedia.common.gui.entity.view.AbstractEditorRenderer;
import myencyclopedia.model.common.StringConverter;

public class CheckBoxEditorRenderer
extends AbstractEditorRenderer {
    protected CheckBox checkBox = new CheckBox();

    public CheckBoxEditorRenderer() {
        this.checkBox.focusedProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue.equals(false) && !CheckBoxEditorRenderer.this.isRenderer) {
                    CheckBoxEditorRenderer.this.forceCommit();
                } else if (newValue.equals(true) && CheckBoxEditorRenderer.this.isRenderer) {
                    CheckBoxEditorRenderer.this.setMode(false);
                }
            }
        });
    }

    @Override
    public boolean forceCommit() {
        try {
            this.validateAndCommit(this.checkBox.isSelected());
        }
        catch (StringConverter.ConversionException ex) {
            this.checkBox.requestFocus();
            return false;
        }
        this.setMode(true);
        return true;
    }

    @Override
    public Region getComponent() {
        return this.checkBox;
    }

    @Override
    public void loadObject(Object obj) {
        if (obj == null) {
            this.checkBox.setSelected(false);
            return;
        }
        this.checkBox.setSelected(((Boolean)obj).booleanValue());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new CheckBoxEditorRenderer();
    }
}

