/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view;

import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.entity.Spec;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.model.Entity;

public class EntityViewStage
extends Stage {
    protected EntityView entityView;
    protected Button btnClose;
    protected Button btnSave;
    protected GUIListener listener;
    public static final String EVENT_SAVE = "save";

    public EntityViewStage(Stage owner, Class cls) {
        this(owner, null, new Spec(cls).buildDefaultEmbedded());
    }

    public EntityViewStage(Stage owner, GUIListener listener, Spec ... specList) {
        this.initOwner((Window)owner);
        this.initModality(Modality.APPLICATION_MODAL);
        this.listener = listener;
        this.entityView = new EntityView(specList);
        this.btnClose = new Button("Close");
        this.btnClose.setOnAction(e -> this.hide());
        HBox box = new HBox();
        box.getChildren().add((Object)this.btnClose);
        if (listener != null) {
            this.btnSave = new Button("Save");
            this.btnSave.setOnAction(e -> listener.dispatch(new GUIEvent((Object)this, EVENT_SAVE, (Object)this.entityView.getEntity())));
            box.getChildren().add((Object)this.btnSave);
        }
        BorderPane pane = new BorderPane();
        pane.setCenter((Node)this.entityView);
        pane.setBottom((Node)box);
        Scene scene = new Scene((Parent)pane, 550.0, 400.0);
        this.setScene(scene);
    }

    public void setCollapsible(boolean option) {
        this.entityView.setCollapsible(option);
    }

    public void setEntity(Entity entity) {
        this.entityView.setEntity(entity);
    }
}

