/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view;

import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.entity.SpecElement;
import myencyclopedia.common.gui.entity.SpecProperty;
import myencyclopedia.common.gui.entity.SpecRelation;
import myencyclopedia.common.gui.entity.view.Editor;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.model.Entity;
import myencyclopedia.model.Relation;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.common.StringConverter;

public abstract class AbstractStageEditor
extends Stage
implements Editor {
    protected EntityView owner;
    protected StringConverter stringConverter;
    protected Entity entity;
    protected SpecElement specEle;

    public AbstractStageEditor() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                AbstractStageEditor.this.requestSwitchToRenderer();
            }
        });
    }

    public Stage getStage() {
        return this;
    }

    public final Control getEditorControl() {
        return null;
    }

    public void tryClose(Object data) throws StringConverter.ConversionException {
        this.validateAndCommit(data);
        this.hide();
        this.owner.notifyCommittedEvent(this.specEle);
    }

    @Override
    public void activate() {
    }

    @Override
    public void setEntityView(EntityView owner) {
        this.owner = owner;
    }

    @Override
    public void bind(Entity entity, SpecElement specElement) {
        this.entity = entity;
        this.specEle = specElement;
    }

    @Override
    public boolean forceCommit() {
        return true;
    }

    @Override
    public void validateAndCommit(Object input) throws StringConverter.ConversionException {
        String propName = this.specEle.getName();
        Object obj = input;
        if (this.stringConverter != null && input != null) {
            obj = this.stringConverter.fromString(input.toString());
        }
        if (this.specEle instanceof SpecProperty) {
            this.entity.setPropertyValue(propName, obj);
        } else {
            SpecRelation specR = (SpecRelation)this.specEle;
            if (specR.isCollection()) {
                RelationCollection r = (RelationCollection)this.entity.getRelation(this.specEle.getName());
                if (obj instanceof List) {
                    r.setTargets((List)obj);
                } else if (obj instanceof Object[]) {
                    r.setTargets((Entity[])obj);
                }
            } else {
                Relation r = this.entity.getRelation(this.specEle.getName());
                r.setTarget(obj);
            }
        }
    }

    @Override
    public String fromObjToString(Object obj) {
        if (this.stringConverter != null) {
            return this.stringConverter.toString(obj);
        }
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public Object fromStringToObj(String str) throws StringConverter.ConversionException {
        if (this.stringConverter != null) {
            return this.stringConverter.fromString(str);
        }
        return str;
    }

    @Override
    public void requestSwitchToRenderer() {
        this.owner.switchToRenderer(this, this.entity);
    }

    @Override
    public void beginEditorTransition() {
    }

    @Override
    public void endEditorTransition() {
    }

    @Override
    public void setStringConverter(StringConverter converter) {
        this.stringConverter = converter;
    }
}

