/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view;

import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.common.gui.entity.view.Renderer;
import myencyclopedia.model.common.StringConverter;

public abstract class AbstractRenderer
implements Renderer {
    protected EntityView owner;
    protected boolean isSwitching = false;
    protected StringConverter stringConverter;

    @Override
    public void setEntityView(EntityView owner) {
        this.owner = owner;
    }

    @Override
    public void requestSwitchToEditor() {
        this.owner.switchToEditor(this);
    }

    @Override
    public void beginRendererTransition() {
        this.isSwitching = true;
    }

    @Override
    public void endRendererTransition() {
        this.isSwitching = false;
    }

    @Override
    public void setStringConverter(StringConverter converter) {
        this.stringConverter = converter;
    }

    @Override
    public String fromObjToString(Object obj) {
        if (this.stringConverter != null) {
            return this.stringConverter.toString(obj);
        }
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public Object fromStringToObj(String str) throws StringConverter.ConversionException {
        if (this.stringConverter != null) {
            return this.stringConverter.fromString(str);
        }
        return str;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }
}

