/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view;

import java.util.List;
import myencyclopedia.common.gui.entity.SpecElement;
import myencyclopedia.common.gui.entity.SpecProperty;
import myencyclopedia.common.gui.entity.SpecRelation;
import myencyclopedia.common.gui.entity.view.Editor;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.model.Entity;
import myencyclopedia.model.Relation;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.common.StringConverter;

public abstract class AbstractEditor
implements Editor {
    protected EntityView owner;
    protected boolean isSwitching = false;
    protected StringConverter stringConverter;
    protected Entity entity;
    protected SpecElement specEle;

    @Override
    public void setEntityView(EntityView owner) {
        this.owner = owner;
    }

    @Override
    public void bind(Entity entity, SpecElement specElement) {
        this.entity = entity;
        this.specEle = specElement;
    }

    @Override
    public void validateAndCommit(Object input) throws StringConverter.ConversionException {
        Object obj = input;
        if (this.stringConverter != null && input != null) {
            obj = this.stringConverter.fromString(input.toString());
        }
        this.commit(obj);
        this.owner.notifyCommittedEvent(this.specEle);
    }

    public void commit(Object obj) {
        String propName = this.specEle.getName();
        if (this.specEle instanceof SpecProperty) {
            this.entity.setPropertyValue(propName, obj);
        } else {
            SpecRelation specR = (SpecRelation)this.specEle;
            if (specR.isCollection()) {
                RelationCollection r = (RelationCollection)this.entity.getRelation(this.specEle.getName());
                if (obj instanceof List) {
                    r.setTargets((List)obj);
                } else if (obj instanceof Object[]) {
                    r.setTargets((Entity[])obj);
                }
            } else {
                Relation r = this.entity.getRelation(this.specEle.getName());
                r.setTarget(obj);
            }
        }
    }

    @Override
    public String fromObjToString(Object obj) {
        if (this.stringConverter != null) {
            return this.stringConverter.toString(obj);
        }
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public Object fromStringToObj(String str) throws StringConverter.ConversionException {
        if (this.stringConverter != null) {
            return this.stringConverter.fromString(str);
        }
        return str;
    }

    @Override
    public void requestSwitchToRenderer() {
        this.owner.switchToRenderer(this, this.entity);
    }

    @Override
    public void beginEditorTransition() {
        this.isSwitching = true;
    }

    @Override
    public void endEditorTransition() {
        this.isSwitching = false;
    }

    @Override
    public void setStringConverter(StringConverter converter) {
        this.stringConverter = converter;
    }
}

