/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.table;

import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import myencyclopedia.model.Entity;
import myencyclopedia.model.common.StringConverter;

public class EntityPropertyValueFactory<S>
implements Callback<TableColumn.CellDataFeatures<S, String>, ObservableValue<String>> {
    private String name;
    private StringConverter factory;

    public EntityPropertyValueFactory(String propertyName, StringConverter factory) {
        this.name = propertyName;
        this.factory = factory;
    }

    public ObservableValue<String> call(TableColumn.CellDataFeatures<S, String> param) {
        Entity entity = (Entity)param.getValue();
        Object value = entity.getPropertyValue(this.name);
        if (value == null) {
            return null;
        }
        String str = value.toString();
        if (this.factory != null) {
            str = this.factory.toString(value);
        }
        return new ReadOnlyObjectWrapper((Object)str);
    }
}

