/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.converter;

import myencyclopedia.model.common.StringConverter;

public class ShortConverter
implements StringConverter<Short> {
    private static final ShortConverter theConverter = new ShortConverter(true);
    private static final ShortConverter theConverterNonEmpty = new ShortConverter(false);
    private boolean isEmptyAllowed;

    private ShortConverter(boolean isEmptyAllowed) {
        this.isEmptyAllowed = isEmptyAllowed;
    }

    public static ShortConverter getConverter(boolean allowEmpty) {
        if (allowEmpty) {
            return theConverter;
        }
        return theConverterNonEmpty;
    }

    public String toString(Short object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Short fromString(String str) throws StringConverter.ConversionException {
        if (this.isEmptyAllowed && (str == null || str.trim().isEmpty())) {
            return null;
        }
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException ex) {
            throw new StringConverter.ConversionException((Throwable)ex);
        }
    }
}

