/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.converter;

import myencyclopedia.model.common.StringConverter;

public class LongConverter
implements StringConverter<Long> {
    private static final LongConverter theConverter = new LongConverter(true);
    private static final LongConverter theConverterNonEmpty = new LongConverter(false);
    private boolean isEmptyAllowed;

    private LongConverter(boolean isEmptyAllowed) {
        this.isEmptyAllowed = isEmptyAllowed;
    }

    public static LongConverter getConverter(boolean allowEmpty) {
        if (allowEmpty) {
            return theConverter;
        }
        return theConverterNonEmpty;
    }

    public String toString(Long object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Long fromString(String str) throws StringConverter.ConversionException {
        if (this.isEmptyAllowed && (str == null || str.trim().isEmpty())) {
            return null;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException ex) {
            throw new StringConverter.ConversionException((Throwable)ex);
        }
    }
}

