/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.converter;

import myencyclopedia.model.common.StringConverter;

public class IntegerConverter
implements StringConverter<Integer> {
    private static final IntegerConverter theConverter = new IntegerConverter(true);
    private static final IntegerConverter theConverterNonEmpty = new IntegerConverter(false);
    private boolean isEmptyAllowed;

    private IntegerConverter(boolean isEmptyAllowed) {
        this.isEmptyAllowed = isEmptyAllowed;
    }

    public static IntegerConverter getConverter(boolean allowEmpty) {
        if (allowEmpty) {
            return theConverter;
        }
        return theConverterNonEmpty;
    }

    public String toString(Integer object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Integer fromString(String str) throws StringConverter.ConversionException {
        if (this.isEmptyAllowed && (str == null || str.trim().isEmpty())) {
            return null;
        }
        try {
            int b = Integer.parseInt(str);
            return b;
        }
        catch (NumberFormatException ex) {
            throw new StringConverter.ConversionException((Throwable)ex);
        }
    }
}

