/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.converter;

import myencyclopedia.model.common.StringConverter;

public class FloatConverter
implements StringConverter<Float> {
    private static final FloatConverter theConverter = new FloatConverter(true);
    private static final FloatConverter theConverterNonEmpty = new FloatConverter(false);
    private boolean isEmptyAllowed;

    private FloatConverter(boolean isEmptyAllowed) {
        this.isEmptyAllowed = isEmptyAllowed;
    }

    public static FloatConverter getConverter(boolean allowEmpty) {
        if (allowEmpty) {
            return theConverter;
        }
        return theConverterNonEmpty;
    }

    public String toString(Float object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Float fromString(String str) throws StringConverter.ConversionException {
        if (this.isEmptyAllowed && (str == null || str.trim().isEmpty())) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(str));
        }
        catch (NumberFormatException ex) {
            throw new StringConverter.ConversionException((Throwable)ex);
        }
    }
}

