/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.converter;

import myencyclopedia.model.common.StringConverter;

public class ByteConverter
implements StringConverter<Byte> {
    private static final ByteConverter theConverter = new ByteConverter(true);
    private static final ByteConverter theConverterNonEmpty = new ByteConverter(false);
    private boolean isEmptyAllowed;

    private ByteConverter(boolean isEmptyAllowed) {
        this.isEmptyAllowed = isEmptyAllowed;
    }

    public static ByteConverter getConverter(boolean allowEmpty) {
        if (allowEmpty) {
            return theConverter;
        }
        return theConverterNonEmpty;
    }

    public String toString(Byte object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Byte fromString(String str) throws StringConverter.ConversionException {
        if (this.isEmptyAllowed && (str == null || str.trim().isEmpty())) {
            return null;
        }
        try {
            byte b = Byte.parseByte(str);
            return b;
        }
        catch (NumberFormatException ex) {
            throw new StringConverter.ConversionException((Throwable)ex);
        }
    }
}

