/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity;

import java.util.Objects;
import myencyclopedia.common.gui.entity.Spec;

public class SpecElement {
    protected boolean dislayChildren = false;
    protected String name;
    protected boolean modifiable = false;
    protected String displayText;
    protected boolean canHaveMore = false;
    protected boolean canHaveLess = false;
    private Spec spec;

    public SpecElement(String name, Spec spec) {
        this.name = name;
        this.spec = spec;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDislayChildren() {
        return this.dislayChildren;
    }

    public SpecElement setDislayChildren() {
        this.dislayChildren = true;
        return this;
    }

    public boolean canHaveMore() {
        return this.canHaveMore;
    }

    public SpecElement setHaveMore(boolean canHaveMore) {
        this.canHaveMore = canHaveMore;
        return this;
    }

    public boolean canHaveLess() {
        return this.canHaveLess;
    }

    public SpecElement setHaveLess(boolean canHaveLess) {
        this.canHaveLess = canHaveLess;
        return this;
    }

    public SpecElement setHaveMoreOrLess(boolean isAble) {
        this.canHaveLess = isAble;
        this.canHaveMore = isAble;
        return this;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public SpecElement setModifiable() {
        this.modifiable = true;
        return this;
    }

    public SpecElement setDisplayName(String string) {
        this.displayText = string;
        return this;
    }

    public String getDisplayName() {
        return this.displayText == null ? this.name : this.displayText;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpecElement other = (SpecElement)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.spec, other.spec);
    }

    public String toString() {
        return this.spec.toString() + ":" + this.name;
    }
}

