/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import myencyclopedia.common.gui.entity.SpecElement;
import myencyclopedia.common.gui.entity.SpecProperty;
import myencyclopedia.common.gui.entity.SpecRelation;
import myencyclopedia.model.Entity;
import myencyclopedia.model.common.StringConverter;
import myencyclopedia.model.hbn.EntityUtil;
import myencyclopedia.model.hbn.HBAbstractEntity;

public class Spec<T extends Entity> {
    private List<SpecProperty> propertyList;
    private List<SpecRelation> relationList;
    private SpecElement[] embededElements;
    private List<SpecElement> standaloneElements;
    private Map<SpecElement, StringConverter> mapStringFactory;
    private Class cls;
    private String displayText;

    public Spec(Class<? extends HBAbstractEntity> cls) {
        this.cls = cls;
        this.mapStringFactory = new HashMap<SpecElement, StringConverter>();
        this.standaloneElements = new ArrayList<SpecElement>();
        this.propertyList = new ArrayList<SpecProperty>();
        for (Map.Entry entry : EntityUtil.getClassPropertyInfo(cls).entrySet()) {
            this.propertyList.add(new SpecProperty((String)entry.getKey(), (Class)entry.getValue(), this));
        }
        this.relationList = new ArrayList<SpecRelation>();
        for (Map.Entry entry : EntityUtil.getClassRelationInfo(cls).entrySet()) {
            this.relationList.add(new SpecRelation((String)entry.getKey(), (Boolean)entry.getValue(), this));
        }
    }

    public Spec buildDefaultEmbedded() {
        if (this.embededElements == null) {
            this.embededElements = new SpecElement[this.propertyList.size()];
            for (int i = 0; i < this.propertyList.size(); ++i) {
                this.embededElements[i] = this.propertyList.get(i);
            }
        }
        return this;
    }

    public SpecElement get(String str) {
        for (SpecProperty p : this.propertyList) {
            if (!p.getName().equals(str)) continue;
            return p;
        }
        for (SpecRelation r : this.relationList) {
            if (!r.getName().equals(str)) continue;
            return r;
        }
        return null;
    }

    public Spec setEmdeded(SpecElement ... elements) {
        this.embededElements = elements;
        return this;
    }

    public Spec addStandalone(SpecElement element) {
        this.standaloneElements.add(element);
        return this;
    }

    public Spec setStringFactory(SpecElement specEle, StringConverter f) {
        this.mapStringFactory.put(specEle, f);
        return this;
    }

    public StringConverter getStringFactoryFor(SpecElement specEle) {
        return this.mapStringFactory.get(specEle);
    }

    public SpecElement[] getEmbedded() {
        return this.embededElements;
    }

    public SpecRelation[] getStandAlone() {
        return this.standaloneElements.toArray(new SpecRelation[0]);
    }

    public Class getEntityClass() {
        return this.cls;
    }

    public Spec setDisplayName(String string) {
        this.displayText = string;
        return this;
    }

    public String getDisplayName() {
        return this.displayText == null ? this.cls.getCanonicalName() : this.displayText;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Spec other = (Spec)obj;
        return Objects.equals(this.cls, other.cls);
    }

    public String toString() {
        return this.cls.getCanonicalName();
    }
}

