/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.common;

import java.text.ParseException;

public class YearMonthDay {
    private String value;
    private Integer intValue;
    private int year;
    private int month;
    private int day;

    public YearMonthDay(int y, int m, int d) {
        this.year = y;
        this.month = m;
        this.day = d;
        this.intValue = this.year * 10000 + this.month * 100 + this.day;
        this.value = String.valueOf(y) + "-" + String.format("%02d", m) + "-" + String.format("%02d", d);
    }

    public static YearMonthDay parseYearMonthDay(Integer dateValue) throws ParseException {
        if (dateValue == null) {
            return null;
        }
        if (dateValue == 0) {
            throw new ParseException("int value is 0", 0);
        }
        int y = dateValue / 10000;
        dateValue = dateValue % 10000;
        int m = dateValue / 100;
        dateValue = dateValue % 100;
        int d = dateValue;
        return new YearMonthDay(y, m, d);
    }

    public static YearMonthDay parseYearMonthDay(String dateValue) throws ParseException {
        if (dateValue == null) {
            throw new ParseException("Init String is null", 0);
        }
        boolean hasMonth = false;
        boolean hasDay = false;
        switch (dateValue.length()) {
            case 4: {
                break;
            }
            case 7: {
                hasMonth = true;
                break;
            }
            case 10: {
                hasMonth = true;
                hasDay = true;
                break;
            }
            default: {
                throw new ParseException("Length not valid", 0);
            }
        }
        String year4digits = dateValue.substring(0, 4);
        if (!YearMonthDay.areAllDigits(year4digits)) {
            throw new ParseException("Year format error", 0);
        }
        int y = 0;
        int m = 0;
        int d = 0;
        try {
            y = Integer.parseInt(year4digits);
            if (y > 2050 || y < 1600) {
                throw new ParseException("Year not in range", 0);
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Year format error", 0);
        }
        if (!hasMonth) {
            return new YearMonthDay(y, m, d);
        }
        if ('-' != dateValue.charAt(4)) {
            throw new ParseException("Use '-' to seperate", 4);
        }
        String month2digits = dateValue.substring(5, 7);
        if (!YearMonthDay.areAllDigits(month2digits)) {
            throw new ParseException("Month format error", 5);
        }
        try {
            m = Integer.parseInt(month2digits);
            if (m > 12 || m < 0) {
                throw new ParseException("Month not in range", 5);
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Month format error", 5);
        }
        if (!hasDay) {
            return new YearMonthDay(y, m, d);
        }
        if ('-' != dateValue.charAt(7)) {
            throw new ParseException("Use '-' to seperate", 7);
        }
        String day2digits = dateValue.substring(8, 10);
        if (!YearMonthDay.areAllDigits(day2digits)) {
            throw new ParseException("Day format error", 8);
        }
        if (day2digits.equals("00")) {
            YearMonthDay ymd = new YearMonthDay(y, m, d);
            return ymd;
        }
        if (m == 0) {
            throw new ParseException("Can't specify day if month is omitted", 8);
        }
        try {
            d = Integer.parseInt(day2digits);
            if (d > 31) {
                throw new ParseException("Day not in range", 8);
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Day format error", 7);
        }
        YearMonthDay ymd = new YearMonthDay(y, m, d);
        return ymd;
    }

    private static boolean areAllDigits(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isFullDate() {
        return this.year != 0 && this.month != 0 && this.day != 0;
    }

    public Integer getDate() {
        return this.intValue;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof YearMonthDay)) {
            return false;
        }
        YearMonthDay targetMEDate = (YearMonthDay)obj;
        return targetMEDate.getDay() == this.getDay() && targetMEDate.getMonth() == this.getMonth() && targetMEDate.getYear() == this.getYear();
    }
}

