/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IntCustomClass {
    protected String name;
    protected int value;
    protected boolean isDeprecated = false;
    private static final Logger logger = LoggerFactory.getLogger(IntCustomClass.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IntCustomClass> loadFromFile(Class<? extends IntCustomClass> cls) {
        ArrayList<IntCustomClass> ret = new ArrayList<IntCustomClass>();
        String res = "/" + cls.getName().replaceAll("\\.", "/") + ".txt";
        URL url = IntCustomClass.class.getResource(res);
        if (url == null) {
            return ret;
        }
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            ArrayList<IntCustomClass> arrayList = ret;
            return arrayList;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
            }
        }
        Constructor<? extends IntCustomClass> c = null;
        try {
            c = cls.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            if (lines.isEmpty()) {
                return ret;
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            return ret;
        }
        int idx = 0;
        try {
            while (true) {
                if (idx + 1 > lines.size() - 1) {
                    return ret;
                }
                IntCustomClass instance = c.newInstance(new Object[0]);
                instance.name = (String)lines.get(idx);
                instance.value = Integer.parseInt((String)lines.get(idx + 1));
                ret.add(instance);
                if ((idx += 2) > lines.size() - 1) {
                    return ret;
                }
                String bool = (String)lines.get(idx);
                if (!bool.trim().isEmpty()) {
                    instance.isDeprecated = Boolean.parseBoolean(bool);
                }
                do {
                    if (++idx <= lines.size() - 1) continue;
                    return ret;
                } while (((String)lines.get(idx)).trim().isEmpty());
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            return ret;
        }
    }

    protected IntCustomClass() {
    }

    public IntCustomClass(String name, int v) {
        this.name = name;
        this.value = v;
    }

    public IntCustomClass(String name, int v, boolean deprecated) {
        this.name = name;
        this.value = v;
        this.isDeprecated = deprecated;
    }

    public static IntCustomClass fromIntValue(Integer intValue, Class<? extends IntCustomClass> klass) {
        IntCustomClass intStaticType = null;
        try {
            Constructor<? extends IntCustomClass> c = klass.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            intStaticType = c.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            return null;
        }
        return intStaticType.validate(intValue);
    }

    public abstract IntCustomClass[] valuesAll();

    public abstract IntCustomClass[] valuesActive();

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public Integer getIntValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public final IntCustomClass validate(int intValue) {
        for (IntCustomClass type : this.valuesAll()) {
            if (type.getIntValue() != intValue) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

