/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.common;

public class DateMarker
implements Comparable<DateMarker> {
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private final long longForm;

    public DateMarker(int year, int month, int day, int hour, int minute, int second) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.longForm = (long)year * 10000000000L + (long)(month * 100000000) + (long)(day * 1000000) + (long)(hour * 10000) + (long)(minute * 100) + (long)second;
    }

    public DateMarker(Long longValue) {
        this.longForm = longValue;
        this.year = (int)(longValue / 10000000000L);
        longValue = longValue % 10000000000L;
        this.month = (int)(longValue / 100000000L);
        longValue = longValue % 100000000L;
        this.day = (int)(longValue / 1000000L);
        longValue = longValue % 1000000L;
        this.hour = (int)(longValue / 10000L);
        longValue = longValue % 10000L;
        this.minute = (int)(longValue / 100L);
        longValue = longValue % 100L;
        this.second = longValue.intValue();
    }

    public Long getLongForm() {
        return this.longForm;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getMonth() {
        return this.month;
    }

    public int getSecond() {
        return this.second;
    }

    public int getYear() {
        return this.year;
    }

    @Override
    public int compareTo(DateMarker obj) {
        if (this.getYear() != obj.getYear()) {
            return this.getYear() - obj.getYear();
        }
        if (this.getMonth() != obj.getMonth()) {
            return this.getMonth() - obj.getMonth();
        }
        if (this.getDay() != obj.getDay()) {
            return this.getDay() - obj.getDay();
        }
        if (this.getHour() != obj.getHour()) {
            return this.getHour() - obj.getHour();
        }
        if (this.getMinute() != obj.getMinute()) {
            return this.getMinute() - obj.getMinute();
        }
        return this.getSecond() - obj.getSecond();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateMarker)) {
            return false;
        }
        return this.compareTo((DateMarker)obj) == 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.year;
        hash = 41 * hash + this.month;
        hash = 41 * hash + this.day;
        hash = 41 * hash + this.hour;
        hash = 41 * hash + this.minute;
        hash = 41 * hash + this.second;
        return hash;
    }

    public String toString() {
        String dayStr;
        String monthStr = String.valueOf(this.getMonth());
        if (monthStr.length() == 1) {
            monthStr = "0" + monthStr;
        }
        if ((dayStr = String.valueOf(this.getDay())).length() == 1) {
            dayStr = "0" + dayStr;
        }
        return this.getYear() + "-" + monthStr + "-" + dayStr + " " + this.getHour() + ":" + this.getMinute() + ":" + this.getSecond();
    }
}

